/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.service;

import java.util.Iterator;
import java.util.Set;
import org.apache.directory.server.dns.DnsException;
import org.apache.directory.server.dns.messages.QuestionRecord;
import org.apache.directory.server.dns.messages.QuestionRecords;
import org.apache.directory.server.dns.messages.ResponseCode;
import org.apache.directory.server.dns.service.DnsContext;
import org.apache.directory.server.dns.store.RecordStore;
import org.apache.directory.server.protocol.shared.chain.Context;
import org.apache.directory.server.protocol.shared.chain.impl.CommandBase;

public class GetResourceRecords
extends CommandBase {
    public boolean execute(Context context) throws Exception {
        DnsContext dnsContext = (DnsContext)context;
        RecordStore store = dnsContext.getStore();
        QuestionRecords questions = dnsContext.getRequest().getQuestionRecords();
        Iterator it = questions.iterator();
        while (it.hasNext()) {
            dnsContext.addResourceRecords(this.getEntry(store, (QuestionRecord)it.next()));
        }
        return false;
    }

    public Set getEntry(RecordStore store, QuestionRecord question) throws Exception {
        Set records = null;
        try {
            records = store.getRecords(question);
        }
        catch (Exception e) {
            throw new DnsException(ResponseCode.SERVER_FAILURE);
        }
        if (records == null || records.isEmpty()) {
            throw new DnsException(ResponseCode.NAME_ERROR);
        }
        return records;
    }
}

