/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.service;

import org.apache.directory.server.dns.messages.DnsMessage;
import org.apache.directory.server.dns.messages.DnsMessageModifier;
import org.apache.directory.server.dns.messages.MessageType;
import org.apache.directory.server.dns.messages.OpCode;
import org.apache.directory.server.dns.messages.ResourceRecords;
import org.apache.directory.server.dns.messages.ResponseCode;
import org.apache.directory.server.dns.service.DnsContext;
import org.apache.directory.server.protocol.shared.chain.Context;
import org.apache.directory.server.protocol.shared.chain.impl.CommandBase;

public class BuildReply
extends CommandBase {
    public boolean execute(Context context) throws Exception {
        DnsContext dnsContext = (DnsContext)context;
        ResourceRecords records = dnsContext.getResourceRecords();
        DnsMessage request = dnsContext.getRequest();
        DnsMessageModifier modifier = new DnsMessageModifier();
        modifier.setTransactionId(request.getTransactionId());
        modifier.setMessageType(MessageType.RESPONSE);
        modifier.setOpCode(OpCode.QUERY);
        modifier.setAuthoritativeAnswer(false);
        modifier.setTruncated(false);
        modifier.setRecursionDesired(request.isRecursionDesired());
        modifier.setRecursionAvailable(false);
        modifier.setReserved(false);
        modifier.setAcceptNonAuthenticatedData(false);
        modifier.setResponseCode(ResponseCode.NO_ERROR);
        modifier.setQuestionRecords(request.getQuestionRecords());
        modifier.setAnswerRecords(records);
        modifier.setAuthorityRecords(new ResourceRecords());
        modifier.setAdditionalRecords(new ResourceRecords());
        dnsContext.setReply(modifier.getDnsMessage());
        return false;
    }
}

