/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dhcp.messages;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class MessageType
implements Comparable {
    public static final MessageType NULL = new MessageType(0, "Null");
    public static final MessageType DHCPDISCOVER = new MessageType(1, "DHCP Discover");
    public static final MessageType DHCPOFFER = new MessageType(2, "DHCP Offer");
    public static final MessageType DHCPREQUEST = new MessageType(3, "DHCP Request");
    public static final MessageType DHCPDECLINE = new MessageType(4, "DHCP Decline");
    public static final MessageType DHCPACK = new MessageType(5, "DHCP Acknowledge");
    public static final MessageType DHCPNAK = new MessageType(6, "DHCP Not Acknowledge");
    public static final MessageType DHCPRELEASE = new MessageType(7, "DHCP Release");
    public static final MessageType DHCPINFORM = new MessageType(8, "DHCP Inform");
    private final String name;
    private final int ordinal;
    private static final MessageType[] values = new MessageType[]{NULL, DHCPDISCOVER, DHCPOFFER, DHCPREQUEST, DHCPDECLINE, DHCPACK, DHCPNAK, DHCPRELEASE, DHCPINFORM};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(values));

    public String toString() {
        return this.name;
    }

    public int compareTo(Object that) {
        return this.ordinal - ((MessageType)that).ordinal;
    }

    public static MessageType getTypeByOrdinal(int type) {
        for (int ii = 0; ii < values.length; ++ii) {
            if (MessageType.values[ii].ordinal != type) continue;
            return values[ii];
        }
        return NULL;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    private MessageType(int ordinal, String name) {
        this.ordinal = ordinal;
        this.name = name;
    }
}

