/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec.actions;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.Asn1Container;
import org.apache.directory.shared.asn1.ber.Asn1Decoder;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.kerberos.codec.authorizationData.AuthorizationDataContainer;
import org.apache.directory.shared.kerberos.components.AuthorizationData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReadAuthorizationData<E extends Asn1Container>
extends GrammarAction<E> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractReadAuthorizationData.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public AbstractReadAuthorizationData(String name) {
        super(name);
    }

    protected abstract void setAuthorizationData(AuthorizationData var1, E var2);

    public final void action(E container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err((I18n)I18n.ERR_04066, (Object[])new Object[0]));
            throw new DecoderException(I18n.err((I18n)I18n.ERR_04067, (Object[])new Object[0]));
        }
        Asn1Decoder authorizationDataDecoder = new Asn1Decoder();
        AuthorizationDataContainer authorizationDataContainer = new AuthorizationDataContainer();
        authorizationDataDecoder.decode(container.getStream(), (Asn1Container)authorizationDataContainer);
        AuthorizationData authorizationData = authorizationDataContainer.getAuthorizationData();
        if (IS_DEBUG) {
            LOG.debug("AuthorizationData : " + (Object)((Object)authorizationData));
        }
        this.setAuthorizationData(authorizationData, container);
        tlv.setExpectedLength(tlv.getExpectedLength() - tlv.getLength());
        container.updateParent();
    }
}

