/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.ldif.LdapLdifException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaAwareLdifReader
extends LdifReader {
    private SchemaManager schemaManager;
    private static final Logger LOG = LoggerFactory.getLogger(SchemaAwareLdifReader.class);

    public SchemaAwareLdifReader(SchemaManager schemaManager) throws Exception {
        this.schemaManager = schemaManager;
        this.validateDn = false;
    }

    @Override
    protected LdifEntry createLdifEntry() {
        DefaultEntry entry = new DefaultEntry(this.schemaManager);
        return new LdifEntry(entry);
    }

    public LdifEntry parseLdifEntry(String ldif) throws LdapLdifException {
        LOG.debug("Starts parsing ldif buffer");
        if (Strings.isEmpty(ldif)) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new StringReader(ldif));
        try {
            this.reader = reader;
            this.version = this.parseVersion();
            LdifEntry ldifEntry = this.parseEntry();
            return ldifEntry;
        }
        catch (LdapLdifException ne) {
            LOG.error(I18n.err(I18n.ERR_12069, ne.getLocalizedMessage()));
            throw new LdapLdifException(I18n.err(I18n.ERR_12070, new Object[0]), ne);
        }
        catch (LdapException le) {
            throw new LdapLdifException(le.getMessage(), le);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ioe) {
                throw new LdapLdifException(I18n.err(I18n.ERR_12024_CANNOT_CLOSE_FILE, new Object[0]), ioe);
            }
        }
    }
}

