/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.ldif.ChangeType;
import org.apache.directory.api.ldap.model.ldif.LdapLdifException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;
import org.apache.directory.mavibot.btree.DnTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FastLdifReader
extends LdifReader {
    private static final Logger LOG = LoggerFactory.getLogger(FastLdifReader.class);
    private DnTuple firstFetchedTuple;
    private DnTuple nextTuple;

    public FastLdifReader(File file) throws LdapLdifException {
        super(file);
        this.validateDn = false;
    }

    @Override
    protected void init() throws LdapException {
        this.lines = new ArrayList();
        this.position = 0;
        this.version = 1;
        this.containsChanges = false;
        this.containsEntries = false;
        this.version = this.parseVersion();
        this.firstFetchedTuple = this.parseDnAlone();
    }

    @Override
    public boolean hasNext() {
        return this.firstFetchedTuple != null;
    }

    public DnTuple getDnTuple() {
        return this.nextTuple;
    }

    @Override
    public LdifEntry next() {
        try {
            LOG.debug("next(): -- called");
            this.nextTuple = this.firstFetchedTuple;
            this.readLines();
            try {
                this.firstFetchedTuple = this.parseDnAlone();
            }
            catch (LdapLdifException ne) {
                this.error = ne;
                throw new NoSuchElementException(ne.getMessage());
            }
            catch (LdapException le) {
                throw new NoSuchElementException(le.getMessage());
            }
            LOG.debug("next(): -- saving DnTuple {}\n", (Object)this.nextTuple);
            return null;
        }
        catch (LdapLdifException ne) {
            LOG.error(I18n.err(I18n.ERR_12071, new Object[0]));
            this.error = ne;
            return null;
        }
    }

    private DnTuple parseDnAlone() throws LdapException {
        if (this.lines == null || this.lines.size() == 0) {
            LOG.debug("The entry is empty : end of ldif file");
            return null;
        }
        String line = (String)this.lines.get(0);
        this.lineNumber -= this.lines.size() - 1;
        String name = this.parseDn(line);
        Dn dn = new Dn(name);
        DnTuple tuple = new DnTuple(dn, this.entryOffset, this.entryLen);
        this.lines.remove(0);
        Iterator iter = this.lines.iterator();
        boolean type = false;
        boolean controlSeen = false;
        boolean changeTypeSeen = false;
        ChangeType operation = ChangeType.Add;
        while (iter.hasNext()) {
            ++this.lineNumber;
            line = (String)iter.next();
            String lowerLine = Strings.toLowerCase(line);
            if (lowerLine.startsWith("control:")) {
                if (this.containsEntries) {
                    LOG.error(I18n.err(I18n.ERR_12004_CHANGE_NOT_ALLOWED, new Object[0]));
                    throw new LdapLdifException(I18n.err(I18n.ERR_12005_NO_CHANGE, new Object[0]));
                }
                this.containsChanges = true;
                if (!controlSeen) continue;
                LOG.error(I18n.err(I18n.ERR_12050, new Object[0]));
                throw new LdapLdifException(I18n.err(I18n.ERR_12051, new Object[0]));
            }
            if (lowerLine.startsWith("changetype:")) {
                if (this.containsEntries) {
                    LOG.error(I18n.err(I18n.ERR_12004_CHANGE_NOT_ALLOWED, new Object[0]));
                    throw new LdapLdifException(I18n.err(I18n.ERR_12005_NO_CHANGE, new Object[0]));
                }
                this.containsChanges = true;
                if (changeTypeSeen) {
                    LOG.error(I18n.err(I18n.ERR_12052, new Object[0]));
                    throw new LdapLdifException(I18n.err(I18n.ERR_12053, new Object[0]));
                }
                type = true;
                controlSeen = true;
                operation = this.parseChangeType(line);
                if (operation != ChangeType.Add) {
                    throw new IllegalArgumentException("ChangeType " + (Object)((Object)operation) + " is not allowed during bulk load");
                }
                while (iter.hasNext()) {
                    iter.next();
                }
                changeTypeSeen = true;
                continue;
            }
            if (line.indexOf(58) > 0) {
                if (this.containsChanges) {
                    LOG.error(I18n.err(I18n.ERR_12004_CHANGE_NOT_ALLOWED, new Object[0]));
                    throw new LdapLdifException(I18n.err(I18n.ERR_12005_NO_CHANGE, new Object[0]));
                }
                this.containsEntries = true;
                if (controlSeen || changeTypeSeen) {
                    LOG.error(I18n.err(I18n.ERR_12054, new Object[0]));
                    throw new LdapLdifException(I18n.err(I18n.ERR_12055, new Object[0]));
                }
                type = false;
                continue;
            }
            LOG.error(I18n.err(I18n.ERR_12056, new Object[0]));
            throw new LdapLdifException(I18n.err(I18n.ERR_12057_BAD_ATTRIBUTE, new Object[0]));
        }
        if (!type) {
            LOG.debug("Read an entry : {}", (Object)tuple);
        } else if (type) {
            LOG.debug("Read a modification : {}", (Object)tuple);
        } else {
            LOG.error(I18n.err(I18n.ERR_12058_UNKNOWN_ENTRY_TYPE, new Object[0]));
            throw new LdapLdifException(I18n.err(I18n.ERR_12059_UNKNOWN_ENTRY, new Object[0]));
        }
        return tuple;
    }
}

