/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.schemaloader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.schema.registries.AbstractSchemaLoader;
import org.apache.directory.api.ldap.model.schema.registries.Schema;
import org.apache.directory.api.ldap.schemaextractor.impl.DefaultSchemaLdifExtractor;
import org.apache.directory.api.ldap.schemaextractor.impl.ResourceMap;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarLdifSchemaLoader
extends AbstractSchemaLoader {
    private static final String SEPARATOR_PATTERN = "[/\\Q\\\\E]";
    private static final String LDIF_EXT = "ldif";
    private static final Logger LOG = LoggerFactory.getLogger(JarLdifSchemaLoader.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static final Map<String, Boolean> RESOURCE_MAP = ResourceMap.getResources(Pattern.compile("schema[/\\Q\\\\E]ou=schema.*"));

    public JarLdifSchemaLoader() throws Exception {
        this.initializeSchemas();
    }

    private URL getResource(String resource, String msg) throws IOException {
        if (RESOURCE_MAP.get(resource).booleanValue()) {
            return DefaultSchemaLdifExtractor.getUniqueResource(resource, msg);
        }
        return new File(resource).toURI().toURL();
    }

    private void initializeSchemas() throws Exception {
        if (IS_DEBUG) {
            LOG.debug("Initializing schema");
        }
        Pattern pat = Pattern.compile("schema[/\\Q\\\\E]ou=schema[/\\Q\\\\E]cn=[a-z0-9-_]*\\.ldif");
        for (String file : RESOURCE_MAP.keySet()) {
            if (!pat.matcher(file).matches()) continue;
            URL resource = this.getResource(file, "schema LDIF file");
            InputStream in = resource.openStream();
            try {
                LdifReader reader = new LdifReader(in);
                LdifEntry entry = reader.next();
                reader.close();
                Schema schema = this.getSchema(entry.getEntry());
                this.schemaMap.put(schema.getSchemaName(), schema);
                if (!IS_DEBUG) continue;
                LOG.debug("Schema Initialized ... \n{}", (Object)schema);
            }
            catch (Exception e) {
                LOG.error(I18n.err((I18n)I18n.ERR_10003, (Object[])new Object[]{file}), (Throwable)e);
                throw e;
            }
            finally {
                in.close();
            }
        }
    }

    private String getSchemaDirectoryString(Schema schema) {
        return "schema/ou=schema/cn=" + Strings.lowerCase((String)schema.getSchemaName()) + "/";
    }

    public List<Entry> loadComparators(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> comparatorList = new ArrayList<Entry>();
        if (schemas == null) {
            return comparatorList;
        }
        for (Schema schema : schemas) {
            String start = this.getSchemaDirectoryString(schema) + "ou=comparators" + "/" + "m-oid=";
            String end = ".ldif";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                if (!resourcePath.startsWith(start) || !resourcePath.endsWith(end)) continue;
                URL resource = this.getResource(resourcePath, "comparator LDIF file");
                LdifReader reader = new LdifReader(resource.openStream());
                LdifEntry entry = reader.next();
                reader.close();
                comparatorList.add(entry.getEntry());
            }
        }
        return comparatorList;
    }

    public List<Entry> loadSyntaxCheckers(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> syntaxCheckerList = new ArrayList<Entry>();
        if (schemas == null) {
            return syntaxCheckerList;
        }
        for (Schema schema : schemas) {
            String start = this.getSchemaDirectoryString(schema) + "ou=syntaxcheckers" + "/" + "m-oid=";
            String end = ".ldif";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                if (!resourcePath.startsWith(start) || !resourcePath.endsWith(end)) continue;
                URL resource = this.getResource(resourcePath, "syntaxChecker LDIF file");
                LdifReader reader = new LdifReader(resource.openStream());
                LdifEntry entry = reader.next();
                reader.close();
                syntaxCheckerList.add(entry.getEntry());
            }
        }
        return syntaxCheckerList;
    }

    public List<Entry> loadNormalizers(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> normalizerList = new ArrayList<Entry>();
        if (schemas == null) {
            return normalizerList;
        }
        for (Schema schema : schemas) {
            String start = this.getSchemaDirectoryString(schema) + "ou=normalizers" + "/" + "m-oid=";
            String end = ".ldif";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                if (!resourcePath.startsWith(start) || !resourcePath.endsWith(end)) continue;
                URL resource = this.getResource(resourcePath, "normalizer LDIF file");
                LdifReader reader = new LdifReader(resource.openStream());
                LdifEntry entry = reader.next();
                reader.close();
                normalizerList.add(entry.getEntry());
            }
        }
        return normalizerList;
    }

    public List<Entry> loadMatchingRules(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> matchingRuleList = new ArrayList<Entry>();
        if (schemas == null) {
            return matchingRuleList;
        }
        for (Schema schema : schemas) {
            String start = this.getSchemaDirectoryString(schema) + "ou=matchingrules" + "/" + "m-oid=";
            String end = ".ldif";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                if (!resourcePath.startsWith(start) || !resourcePath.endsWith(end)) continue;
                URL resource = this.getResource(resourcePath, "matchingRules LDIF file");
                LdifReader reader = new LdifReader(resource.openStream());
                LdifEntry entry = reader.next();
                reader.close();
                matchingRuleList.add(entry.getEntry());
            }
        }
        return matchingRuleList;
    }

    public List<Entry> loadSyntaxes(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> syntaxList = new ArrayList<Entry>();
        if (schemas == null) {
            return syntaxList;
        }
        for (Schema schema : schemas) {
            String start = this.getSchemaDirectoryString(schema) + "ou=syntaxes" + "/" + "m-oid=";
            String end = ".ldif";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                if (!resourcePath.startsWith(start) || !resourcePath.endsWith(end)) continue;
                URL resource = this.getResource(resourcePath, "syntax LDIF file");
                LdifReader reader = new LdifReader(resource.openStream());
                LdifEntry entry = reader.next();
                reader.close();
                syntaxList.add(entry.getEntry());
            }
        }
        return syntaxList;
    }

    public List<Entry> loadAttributeTypes(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> attributeTypeList = new ArrayList<Entry>();
        if (schemas == null) {
            return attributeTypeList;
        }
        for (Schema schema : schemas) {
            String start = this.getSchemaDirectoryString(schema) + "ou=attributetypes" + "/" + "m-oid=";
            String end = ".ldif";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                if (!resourcePath.startsWith(start) || !resourcePath.endsWith(end)) continue;
                URL resource = this.getResource(resourcePath, "attributeType LDIF file");
                LdifReader reader = new LdifReader(resource.openStream());
                LdifEntry entry = reader.next();
                reader.close();
                attributeTypeList.add(entry.getEntry());
            }
        }
        return attributeTypeList;
    }

    public List<Entry> loadMatchingRuleUses(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> matchingRuleUseList = new ArrayList<Entry>();
        if (schemas == null) {
            return matchingRuleUseList;
        }
        for (Schema schema : schemas) {
            String start = this.getSchemaDirectoryString(schema) + "ou=matchingruleuse" + "/" + "m-oid=";
            String end = ".ldif";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                if (!resourcePath.startsWith(start) || !resourcePath.endsWith(end)) continue;
                URL resource = this.getResource(resourcePath, "matchingRuleUse LDIF file");
                LdifReader reader = new LdifReader(resource.openStream());
                LdifEntry entry = reader.next();
                reader.close();
                matchingRuleUseList.add(entry.getEntry());
            }
        }
        return matchingRuleUseList;
    }

    public List<Entry> loadNameForms(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> nameFormList = new ArrayList<Entry>();
        if (schemas == null) {
            return nameFormList;
        }
        for (Schema schema : schemas) {
            String start = this.getSchemaDirectoryString(schema) + "ou=nameforms" + "/" + "m-oid=";
            String end = ".ldif";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                if (!resourcePath.startsWith(start) || !resourcePath.endsWith(end)) continue;
                URL resource = this.getResource(resourcePath, "nameForm LDIF file");
                LdifReader reader = new LdifReader(resource.openStream());
                LdifEntry entry = reader.next();
                reader.close();
                nameFormList.add(entry.getEntry());
            }
        }
        return nameFormList;
    }

    public List<Entry> loadDitContentRules(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> ditContentRulesList = new ArrayList<Entry>();
        if (schemas == null) {
            return ditContentRulesList;
        }
        for (Schema schema : schemas) {
            String start = this.getSchemaDirectoryString(schema) + "ou=ditcontentrules" + "/" + "m-oid=";
            String end = ".ldif";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                if (!resourcePath.startsWith(start) || !resourcePath.endsWith(end)) continue;
                URL resource = this.getResource(resourcePath, "ditContentRule LDIF file");
                LdifReader reader = new LdifReader(resource.openStream());
                LdifEntry entry = reader.next();
                reader.close();
                ditContentRulesList.add(entry.getEntry());
            }
        }
        return ditContentRulesList;
    }

    public List<Entry> loadDitStructureRules(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> ditStructureRuleList = new ArrayList<Entry>();
        if (schemas == null) {
            return ditStructureRuleList;
        }
        for (Schema schema : schemas) {
            String start = this.getSchemaDirectoryString(schema) + "ou=ditstructurerules" + "/" + "m-oid=";
            String end = ".ldif";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                if (!resourcePath.startsWith(start) || !resourcePath.endsWith(end)) continue;
                URL resource = this.getResource(resourcePath, "ditStructureRule LDIF file");
                LdifReader reader = new LdifReader(resource.openStream());
                LdifEntry entry = reader.next();
                reader.close();
                ditStructureRuleList.add(entry.getEntry());
            }
        }
        return ditStructureRuleList;
    }

    public List<Entry> loadObjectClasses(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> objectClassList = new ArrayList<Entry>();
        if (schemas == null) {
            return objectClassList;
        }
        for (Schema schema : schemas) {
            String start = this.getSchemaDirectoryString(schema) + "ou=objectclasses" + "/" + "m-oid=";
            String end = ".ldif";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                if (!resourcePath.startsWith(start) || !resourcePath.endsWith(end)) continue;
                URL resource = this.getResource(resourcePath, "objectClass LDIF file");
                LdifReader reader = new LdifReader(resource.openStream());
                LdifEntry entry = reader.next();
                reader.close();
                objectClassList.add(entry.getEntry());
            }
        }
        return objectClassList;
    }
}

