/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtherMailboxSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(OtherMailboxSyntaxChecker.class);

    public OtherMailboxSyntaxChecker() {
        super("1.3.6.1.4.1.1466.115.121.1.39");
    }

    public boolean isValidSyntax(Object value) {
        String mailbox;
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for 'null'");
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        if (strValue.length() == 0) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        int dollar = strValue.indexOf(36);
        if (dollar == -1) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        String mailboxType = strValue.substring(0, dollar);
        String string = mailbox = dollar < strValue.length() - 1 ? strValue.substring(dollar + 1) : "";
        if (mailbox.indexOf(36) != -1) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        if (!Strings.isPrintableString((String)mailboxType)) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        boolean result = Strings.isIA5String((String)mailbox);
        if (result) {
            LOG.debug("Syntax valid for '{}'", value);
        } else {
            LOG.debug("Syntax invalid for '{}'", value);
        }
        return result;
    }
}

