/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.normalizers;

import java.io.UnsupportedEncodingException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.BinaryValue;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.normalizers.NameComponentNormalizer;
import org.apache.directory.api.ldap.model.schema.normalizers.NoOpNormalizer;
import org.apache.directory.api.util.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcreteNameComponentNormalizer
implements NameComponentNormalizer {
    private static final Logger LOG = LoggerFactory.getLogger(ConcreteNameComponentNormalizer.class);
    private final SchemaManager schemaManager;

    public ConcreteNameComponentNormalizer(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    private String unescape(String value) {
        char[] newVal = new char[value.length()];
        int escaped = 0;
        char high = '\u0000';
        char low = '\u0000';
        int pos = 0;
        block5: for (char c : value.toCharArray()) {
            switch (escaped) {
                case 0: {
                    if (c == '\\') {
                        escaped = 1;
                        continue block5;
                    }
                    newVal[pos++] = c;
                    continue block5;
                }
                case 1: {
                    ++escaped;
                    high = c;
                    continue block5;
                }
                case 2: {
                    escaped = 0;
                    low = c;
                    newVal[pos++] = (char)Hex.getHexValue((char)high, (char)low);
                }
            }
        }
        return new String(newVal, 0, pos);
    }

    public Object normalizeByName(String name, String value) throws LdapException {
        AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(name);
        if (attributeType.getSyntax().isHumanReadable()) {
            return this.lookup(name).normalize(value);
        }
        try {
            String unescaped = this.unescape(value);
            byte[] valBytes = unescaped.getBytes("UTF-8");
            return this.lookup(name).normalize(new BinaryValue(valBytes));
        }
        catch (UnsupportedEncodingException uee) {
            String message = I18n.err((I18n)I18n.ERR_04222, (Object[])new Object[0]);
            LOG.error(message);
            throw new LdapException(message, uee);
        }
    }

    public Object normalizeByName(String name, byte[] value) throws LdapException {
        AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(name);
        if (!attributeType.getSyntax().isHumanReadable()) {
            return this.lookup(name).normalize(new BinaryValue(value));
        }
        try {
            String valStr = new String(value, "UTF-8");
            return this.lookup(name).normalize(valStr);
        }
        catch (UnsupportedEncodingException uee) {
            String message = I18n.err((I18n)I18n.ERR_04223, (Object[])new Object[0]);
            LOG.error(message);
            throw new LdapException(message, uee);
        }
    }

    public Object normalizeByOid(String oid, String value) throws LdapException {
        return this.lookup(oid).normalize(value);
    }

    public Object normalizeByOid(String oid, byte[] value) throws LdapException {
        return this.lookup(oid).normalize(new BinaryValue(value));
    }

    private Normalizer lookup(String id) throws LdapException {
        AttributeType type = this.schemaManager.lookupAttributeTypeRegistry(id);
        MatchingRule mrule = type.getEquality();
        if (mrule == null) {
            return new NoOpNormalizer(id);
        }
        return mrule.getNormalizer();
    }

    public boolean isDefined(String id) {
        return this.schemaManager.getAttributeTypeRegistry().contains(id);
    }

    public String normalizeName(String attributeName) throws LdapException {
        return this.schemaManager.getAttributeTypeRegistry().getOidByName(attributeName);
    }
}

