/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.message;

import org.apache.directory.api.ldap.model.exception.MessageException;
import org.apache.directory.api.ldap.model.message.AbstractAbandonableRequest;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.DeleteRequest;
import org.apache.directory.api.ldap.model.message.DeleteResponse;
import org.apache.directory.api.ldap.model.message.DeleteResponseImpl;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.apache.directory.api.ldap.model.name.Dn;

public class DeleteRequestImpl
extends AbstractAbandonableRequest
implements DeleteRequest {
    static final long serialVersionUID = 3187847454305567542L;
    private Dn name;
    private DeleteResponse response;

    public DeleteRequestImpl() {
        super(-1, TYPE);
    }

    public Dn getName() {
        return this.name;
    }

    public DeleteRequest setName(Dn name) {
        this.name = name;
        return this;
    }

    public DeleteRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    public DeleteRequest addControl(Control control) throws MessageException {
        return (DeleteRequest)super.addControl(control);
    }

    public DeleteRequest addAllControls(Control[] controls) throws MessageException {
        return (DeleteRequest)super.addAllControls(controls);
    }

    public DeleteRequest removeControl(Control control) throws MessageException {
        return (DeleteRequest)super.removeControl(control);
    }

    public MessageTypeEnum getResponseType() {
        return RESP_TYPE;
    }

    public DeleteResponse getResultResponse() {
        if (this.response == null) {
            this.response = new DeleteResponseImpl(this.getMessageId());
        }
        return this.response;
    }

    public int hashCode() {
        int hash = 37;
        if (this.name != null) {
            hash = hash * 17 + this.name.hashCode();
        }
        hash = hash * 17 + super.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        DeleteRequest req = (DeleteRequest)obj;
        if (this.name != null && req.getName() == null) {
            return false;
        }
        if (this.name == null && req.getName() != null) {
            return false;
        }
        return this.name == null || req.getName() == null || this.name.equals(req.getName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    Del request\n");
        sb.append("        Entry : '").append(this.name.toString()).append("'\n");
        sb.append(super.toString());
        return super.toString(sb.toString());
    }
}

