/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec;

import java.util.Map;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ControlFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.controls.cascade.CascadeFactory;
import org.apache.directory.api.ldap.codec.controls.manageDsaIT.ManageDsaITFactory;
import org.apache.directory.api.ldap.codec.controls.proxiedauthz.ProxiedAuthzFactory;
import org.apache.directory.api.ldap.codec.controls.search.entryChange.EntryChangeFactory;
import org.apache.directory.api.ldap.codec.controls.search.pagedSearch.PagedResultsFactory;
import org.apache.directory.api.ldap.codec.controls.search.persistentSearch.PersistentSearchFactory;
import org.apache.directory.api.ldap.codec.controls.search.subentries.SubentriesFactory;
import org.apache.directory.api.ldap.codec.controls.sort.SortRequestFactory;
import org.apache.directory.api.ldap.codec.controls.sort.SortResponseFactory;
import org.apache.directory.api.ldap.model.message.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StockCodecFactoryUtil {
    private static final Logger LOG = LoggerFactory.getLogger(StockCodecFactoryUtil.class);

    private StockCodecFactoryUtil() {
    }

    public static void loadStockControls(LdapApiService apiService) {
        Map<String, ControlFactory<? extends Control>> requestControlFactories = apiService.getRequestControlFactories();
        Map<String, ControlFactory<? extends Control>> responseControlFactories = apiService.getResponseControlFactories();
        CascadeFactory cascadeFactory = new CascadeFactory(apiService);
        requestControlFactories.put(cascadeFactory.getOid(), cascadeFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, cascadeFactory.getOid()));
        }
        EntryChangeFactory entryChangeFactory = new EntryChangeFactory(apiService);
        responseControlFactories.put(entryChangeFactory.getOid(), entryChangeFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, entryChangeFactory.getOid()));
        }
        ManageDsaITFactory manageDsaITFactory = new ManageDsaITFactory(apiService);
        requestControlFactories.put(manageDsaITFactory.getOid(), manageDsaITFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, manageDsaITFactory.getOid()));
        }
        PagedResultsFactory pagedResultsFactory = new PagedResultsFactory(apiService);
        requestControlFactories.put(pagedResultsFactory.getOid(), pagedResultsFactory);
        responseControlFactories.put(pagedResultsFactory.getOid(), pagedResultsFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, pagedResultsFactory.getOid()));
        }
        PersistentSearchFactory persistentSearchFactory = new PersistentSearchFactory(apiService);
        requestControlFactories.put(persistentSearchFactory.getOid(), persistentSearchFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, persistentSearchFactory.getOid()));
        }
        ProxiedAuthzFactory proxiedAuthzFactory = new ProxiedAuthzFactory(apiService);
        requestControlFactories.put(proxiedAuthzFactory.getOid(), proxiedAuthzFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, proxiedAuthzFactory.getOid()));
        }
        SortRequestFactory sortRequestFactory = new SortRequestFactory(apiService);
        requestControlFactories.put(sortRequestFactory.getOid(), sortRequestFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, sortRequestFactory.getOid()));
        }
        SortResponseFactory sortResponseFactory = new SortResponseFactory(apiService);
        responseControlFactories.put(sortResponseFactory.getOid(), sortResponseFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, sortResponseFactory.getOid()));
        }
        SubentriesFactory subentriesFactory = new SubentriesFactory(apiService);
        requestControlFactories.put(subentriesFactory.getOid(), subentriesFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, subentriesFactory.getOid()));
        }
    }
}

