/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.name;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Ava;
import org.apache.directory.api.ldap.model.name.ComplexDnParser;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.FastDnParser;
import org.apache.directory.api.ldap.model.name.TooComplexDnException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.Chars;
import org.apache.directory.api.util.Hex;
import org.apache.directory.api.util.Serialize;
import org.apache.directory.api.util.StringConstants;
import org.apache.directory.api.util.Strings;
import org.apache.directory.api.util.Unicode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rdn
implements Cloneable,
Externalizable,
Iterable<Ava>,
Comparable<Rdn> {
    protected static final Logger LOG = LoggerFactory.getLogger(Rdn.class);
    public static final Rdn EMPTY_RDN = new Rdn();
    private static final long serialVersionUID = 1L;
    private String upName = null;
    private String normName = null;
    private List<Ava> avas = null;
    private MultiMap avaTypes = new MultiValueMap();
    private String avaType = null;
    protected Ava ava = null;
    private int nbAvas = 0;
    public static final int UNDEFINED = Integer.MAX_VALUE;
    public static final int SUPERIOR = 1;
    public static final int INFERIOR = -1;
    public static final int EQUAL = 0;
    private boolean normalized = false;
    private SchemaManager schemaManager;
    private volatile int h;

    public Rdn() {
        this((SchemaManager)null);
    }

    public Rdn(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
        this.upName = "";
        this.normName = "";
        this.normalized = false;
        this.h = 0;
    }

    public Rdn(SchemaManager schemaManager, String rdn) throws LdapInvalidDnException {
        if (Strings.isNotEmpty(rdn)) {
            Rdn.parse(rdn, this);
            if (schemaManager != null) {
                this.schemaManager = schemaManager;
                this.apply(schemaManager);
                this.normalized = true;
            } else {
                this.normalize();
                this.normalized = false;
            }
            if (this.upName.length() < rdn.length()) {
                throw new LdapInvalidDnException("Invalid RDN");
            }
            this.upName = rdn;
        } else {
            this.upName = "";
            this.normName = "";
            this.normalized = false;
        }
        this.hashCode();
    }

    public Rdn(String rdn) throws LdapInvalidDnException {
        this((SchemaManager)null, rdn);
    }

    public Rdn(SchemaManager schemaManager, String upType, String upValue) throws LdapInvalidDnException {
        this.addAVA(schemaManager, upType, upType, new StringValue(upValue));
        this.upName = upType + '=' + upValue;
        if (schemaManager != null) {
            this.schemaManager = schemaManager;
            this.apply(schemaManager);
            this.normalized = true;
        } else {
            this.normalize();
            this.normalized = false;
        }
        this.hashCode();
    }

    public Rdn(String upType, String upValue) throws LdapInvalidDnException {
        this(null, upType, upValue);
    }

    public Rdn(SchemaManager schemaManager, Ava ... avas) throws LdapInvalidDnException {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < avas.length; ++i) {
            if (i > 0) {
                buffer.append('+');
            }
            this.addAVA(schemaManager, avas[i]);
            buffer.append(avas[i].getName());
        }
        this.setUpName(buffer.toString());
        this.normalize();
    }

    public Rdn(Ava ... avas) throws LdapInvalidDnException {
        this((SchemaManager)null, avas);
    }

    public Rdn(Rdn rdn) {
        this.nbAvas = rdn.size();
        this.normName = rdn.normName;
        this.upName = rdn.getName();
        this.normalized = rdn.normalized;
        this.schemaManager = rdn.schemaManager;
        switch (rdn.size()) {
            case 0: {
                this.hashCode();
                return;
            }
            case 1: {
                this.ava = rdn.ava.clone();
                this.hashCode();
                return;
            }
        }
        this.avas = new ArrayList<Ava>();
        this.avaTypes = new MultiValueMap();
        for (Ava currentAva : rdn.avas) {
            this.avas.add(currentAva.clone());
            this.avaTypes.put((Object)currentAva.getNormType(), (Object)currentAva);
        }
        this.hashCode();
    }

    void normalize() {
        switch (this.nbAvas) {
            case 0: {
                this.normName = "";
                break;
            }
            case 1: {
                if (this.ava.getValue().isHumanReadable()) {
                    this.normName = this.ava.getNormName();
                    break;
                }
                this.normName = this.ava.getNormType() + "=#" + Strings.dumpHexPairs(this.ava.getValue().getBytes());
                break;
            }
            default: {
                StringBuffer sb = new StringBuffer();
                boolean isFirst = true;
                for (Ava ata : this.avas) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append('+');
                    }
                    sb.append(ata.getNormName());
                }
                this.normName = sb.toString();
            }
        }
        this.hashCode();
    }

    public Rdn apply(SchemaManager schemaManager) throws LdapInvalidDnException {
        if (this.normalized) {
            return this;
        }
        String savedUpName = this.getName();
        Dn.rdnOidToName(this, schemaManager);
        this.normalize();
        this.upName = savedUpName;
        this.normalized = true;
        this.schemaManager = schemaManager;
        this.hashCode();
        return this;
    }

    private void addAVA(SchemaManager schemaManager, String upType, String type, Value<?> value) throws LdapInvalidDnException {
        AttributeType attributeType = null;
        String normalizedType = Strings.lowerCaseAscii(type);
        this.schemaManager = schemaManager;
        if (schemaManager != null) {
            attributeType = schemaManager.getAttributeType(normalizedType);
            try {
                value.apply(attributeType);
            }
            catch (LdapInvalidAttributeValueException liave) {
                throw new LdapInvalidDnException(liave.getMessage(), liave);
            }
        }
        switch (this.nbAvas) {
            case 0: {
                this.ava = new Ava(schemaManager, upType, normalizedType, value);
                this.nbAvas = 1;
                this.avaType = normalizedType;
                this.hashCode();
                return;
            }
            case 1: {
                this.avas = new ArrayList<Ava>();
                this.avas.add(this.ava);
                this.avaTypes = new MultiValueMap();
                this.avaTypes.put((Object)this.avaType, (Object)this.ava);
                this.ava = null;
            }
        }
        Ava newAva = new Ava(schemaManager, upType, normalizedType, value);
        this.avas.add(newAva);
        this.avaTypes.put((Object)normalizedType, (Object)newAva);
        ++this.nbAvas;
        this.hashCode();
    }

    void replaceAva(Ava value, int pos) throws LdapInvalidDnException {
        if (pos < 0 || pos > this.nbAvas) {
            throw new LdapInvalidDnException("Cannot set the AVA at position " + pos);
        }
        String normalizedType = value.getNormType();
        switch (this.nbAvas) {
            case 1: {
                this.ava = value;
                this.avaType = normalizedType;
                break;
            }
            default: {
                Ava oldAva = this.avas.get(pos);
                this.avas.set(pos, value);
                this.avaTypes.remove((Object)oldAva.getType());
                this.avaTypes.put((Object)normalizedType, (Object)value);
            }
        }
        this.h = 0;
        this.hashCode();
    }

    void addAVA(SchemaManager schemaManager, Ava value) throws LdapInvalidDnException {
        this.schemaManager = schemaManager;
        String normalizedType = value.getNormType();
        switch (this.nbAvas) {
            case 0: {
                this.ava = value;
                this.nbAvas = 1;
                this.avaType = normalizedType;
                this.hashCode();
                return;
            }
            case 1: {
                if (this.avaType.equals(normalizedType) && this.ava.getValue().equals(value.getValue())) {
                    throw new LdapInvalidDnException("Invalid RDN: the " + normalizedType + " is already present in the RDN");
                }
                this.avas = new ArrayList<Ava>();
                this.avas.add(this.ava);
                this.avaTypes = new MultiValueMap();
                this.avaTypes.put((Object)this.avaType, (Object)this.ava);
                this.ava = null;
            }
        }
        if (this.avaTypes.containsKey((Object)normalizedType)) {
            Collection atavList = (Collection)this.avaTypes.get((Object)normalizedType);
            if (atavList.contains(value)) {
                throw new LdapInvalidDnException("Invalid RDN: the " + normalizedType + " is already present in the RDN");
            }
            atavList.add(value);
            ++this.nbAvas;
        } else {
            this.avas.add(value);
            this.avaTypes.put((Object)normalizedType, (Object)value);
            ++this.nbAvas;
            this.hashCode();
        }
    }

    void clear() {
        this.ava = null;
        this.avas = null;
        this.avaType = null;
        this.avaTypes.clear();
        this.nbAvas = 0;
        this.normName = "";
        this.upName = "";
        this.normalized = false;
        this.h = 0;
    }

    public Object getValue(String type) throws LdapInvalidDnException {
        AttributeType attributeType;
        String normalizedType = Strings.lowerCaseAscii(Strings.trim(type));
        if (this.schemaManager != null && (attributeType = this.schemaManager.getAttributeType(normalizedType)) != null) {
            normalizedType = attributeType.getOid();
        }
        switch (this.nbAvas) {
            case 0: {
                return "";
            }
            case 1: {
                if (Strings.equals(this.ava.getNormType(), normalizedType)) {
                    return this.ava.getValue().getValue();
                }
                return "";
            }
        }
        if (this.avaTypes.containsKey((Object)normalizedType)) {
            Collection atavList = (Collection)this.avaTypes.get((Object)normalizedType);
            StringBuffer sb = new StringBuffer();
            boolean isFirst = true;
            for (Ava elem : atavList) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(',');
                }
                sb.append(elem.getValue());
            }
            return sb.toString();
        }
        return "";
    }

    public Object getNormValue(String type) throws LdapInvalidDnException {
        AttributeType attributeType;
        String normalizedType = Strings.lowerCaseAscii(Strings.trim(type));
        if (this.schemaManager != null && (attributeType = this.schemaManager.getAttributeType(normalizedType)) != null) {
            normalizedType = attributeType.getOid();
        }
        switch (this.nbAvas) {
            case 0: {
                return "";
            }
            case 1: {
                if (Strings.equals(this.ava.getNormType(), normalizedType)) {
                    return this.ava.getValue().getNormValue();
                }
                return "";
            }
        }
        if (this.avaTypes.containsKey((Object)normalizedType)) {
            Collection atavList = (Collection)this.avaTypes.get((Object)normalizedType);
            StringBuffer sb = new StringBuffer();
            boolean isFirst = true;
            for (Ava elem : atavList) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(',');
                }
                sb.append(elem.getValue().getNormValue());
            }
            return sb.toString();
        }
        return "";
    }

    public Ava getAva(String type) {
        String normalizedType = Strings.lowerCaseAscii(Strings.trim(type));
        switch (this.nbAvas) {
            case 0: {
                return null;
            }
            case 1: {
                if (this.ava.getNormType().equals(normalizedType)) {
                    return this.ava;
                }
                return null;
            }
        }
        if (this.avaTypes.containsKey((Object)normalizedType)) {
            Collection atavList = (Collection)this.avaTypes.get((Object)normalizedType);
            return (Ava)atavList.iterator().next();
        }
        return null;
    }

    @Override
    public Iterator<Ava> iterator() {
        if (this.nbAvas == 1 || this.nbAvas == 0) {
            return new Iterator<Ava>(){
                private boolean hasMoreElement;
                {
                    this.hasMoreElement = Rdn.this.nbAvas == 1;
                }

                @Override
                public boolean hasNext() {
                    return this.hasMoreElement;
                }

                @Override
                public Ava next() {
                    Ava obj = Rdn.this.ava;
                    this.hasMoreElement = false;
                    return obj;
                }

                @Override
                public void remove() {
                }
            };
        }
        return this.avas.iterator();
    }

    public Rdn clone() {
        try {
            Rdn rdn = (Rdn)super.clone();
            rdn.normalized = this.normalized;
            switch (rdn.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    rdn.ava = this.ava.clone();
                    rdn.avaTypes = this.avaTypes;
                    break;
                }
                default: {
                    rdn.avaTypes = new MultiValueMap();
                    rdn.avas = new ArrayList<Ava>();
                    for (Ava currentAva : this.avas) {
                        rdn.avas.add(currentAva.clone());
                        rdn.avaTypes.put((Object)currentAva.getNormType(), (Object)currentAva);
                    }
                }
            }
            return rdn;
        }
        catch (CloneNotSupportedException cnse) {
            throw new Error("Assertion failure", cnse);
        }
    }

    public String getName() {
        return this.upName;
    }

    public String getNormName() {
        return this.normName == null ? "" : this.normName;
    }

    void setUpName(String upName) {
        this.upName = upName;
    }

    public Ava getAva() {
        switch (this.nbAvas) {
            case 0: {
                return null;
            }
            case 1: {
                return this.ava;
            }
        }
        return this.avas.get(0);
    }

    public String getType() {
        switch (this.nbAvas) {
            case 0: {
                return null;
            }
            case 1: {
                return this.ava.getType();
            }
        }
        return this.avas.get(0).getType();
    }

    public String getNormType() {
        switch (this.nbAvas) {
            case 0: {
                return null;
            }
            case 1: {
                return this.ava.getNormType();
            }
        }
        return this.avas.get(0).getNormType();
    }

    public String getValue() {
        switch (this.nbAvas) {
            case 0: {
                return null;
            }
            case 1: {
                return this.ava.getValue().getString();
            }
        }
        return this.avas.get(0).getValue().getString();
    }

    public String getNormValue() {
        switch (this.nbAvas) {
            case 0: {
                return null;
            }
            case 1: {
                return this.ava.getValue().getNormValue().toString();
            }
        }
        return this.avas.get(0).getValue().getNormValue().toString();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Rdn)) {
            return false;
        }
        Rdn rdn = (Rdn)that;
        if (this.normName.equals(rdn.normName)) {
            return true;
        }
        if (this.normName.equals(rdn.normName)) {
            return true;
        }
        if (rdn.nbAvas != this.nbAvas) {
            return false;
        }
        switch (this.nbAvas) {
            case 0: {
                return true;
            }
            case 1: {
                return this.ava.equals(rdn.ava);
            }
        }
        Iterator<Ava> localIterator = this.avas.iterator();
        while (localIterator.hasNext()) {
            Iterator<Ava> paramIterator = rdn.avas.iterator();
            Ava localAva = localIterator.next();
            boolean equals = false;
            while (paramIterator.hasNext()) {
                Ava paramAva = paramIterator.next();
                if (!localAva.equals(paramAva)) continue;
                equals = true;
                break;
            }
            if (equals) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.nbAvas;
    }

    public static Object unescapeValue(String value) throws IllegalArgumentException {
        if (Strings.isEmpty(value)) {
            return "";
        }
        char[] chars = value.toCharArray();
        if (chars[0] == '\"' && chars[chars.length - 1] == '\"') {
            return new String(chars, 1, chars.length - 2);
        }
        if (chars[0] == '#') {
            if (chars.length == 1) {
                return StringConstants.EMPTY_BYTES;
            }
            if (chars.length % 2 != 1) {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_04213, new Object[0]));
            }
            byte[] hexValue = new byte[(chars.length - 1) / 2];
            int pos = 0;
            for (int i = 1; i < chars.length; i += 2) {
                if (!Chars.isHex(chars, i) || !Chars.isHex(chars, i + 1)) {
                    throw new IllegalArgumentException(I18n.err(I18n.ERR_04214, new Object[0]));
                }
                hexValue[pos++] = Hex.getHexValue(chars[i], chars[i + 1]);
            }
            return hexValue;
        }
        boolean escaped = false;
        boolean isHex = false;
        int pair = -1;
        int pos = 0;
        byte[] bytes = new byte[chars.length * 6];
        block10: for (int i = 0; i < chars.length; ++i) {
            if (escaped) {
                escaped = false;
                switch (chars[i]) {
                    case ' ': 
                    case '\"': 
                    case '#': 
                    case '+': 
                    case ',': 
                    case ';': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '\\': {
                        bytes[pos++] = (byte)chars[i];
                        break;
                    }
                    default: {
                        if (!Chars.isHex(chars, i)) continue block10;
                        isHex = true;
                        pair = (byte)(Hex.getHexValue(chars[i]) << 4);
                        break;
                    }
                }
                continue;
            }
            if (isHex) {
                if (!Chars.isHex(chars, i)) continue;
                pair = (byte)(pair + Hex.getHexValue(chars[i]));
                bytes[pos++] = pair;
                isHex = false;
                pair = 0;
                continue;
            }
            switch (chars[i]) {
                case '\\': {
                    escaped = true;
                    continue block10;
                }
                case '\"': 
                case '#': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '>': {
                    if (i != 0) {
                        bytes[pos++] = 35;
                        continue block10;
                    }
                }
                case '=': {
                    throw new IllegalArgumentException(I18n.err(I18n.ERR_04215, new Object[0]));
                }
                case ' ': {
                    if (i == 0 || i == chars.length - 1) {
                        throw new IllegalArgumentException(I18n.err(I18n.ERR_04215, new Object[0]));
                    }
                    bytes[pos++] = 32;
                    continue block10;
                }
                default: {
                    if (chars[i] < '\u0080') {
                        bytes[pos++] = (byte)chars[i];
                        continue block10;
                    }
                    byte[] result = Unicode.charToBytes(chars[i]);
                    System.arraycopy(result, 0, bytes, pos, result.length);
                    pos += result.length;
                }
            }
        }
        return Strings.utf8ToString(bytes, pos);
    }

    public static String escapeValue(String value) {
        if (Strings.isEmpty(value)) {
            return "";
        }
        char[] chars = value.toCharArray();
        char[] newChars = new char[chars.length * 3];
        int pos = 0;
        block8: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case ' ': {
                    if (i > 0 && i < chars.length - 1) {
                        newChars[pos++] = chars[i];
                        continue block8;
                    }
                    newChars[pos++] = 92;
                    newChars[pos++] = chars[i];
                    continue block8;
                }
                case '#': {
                    if (i != 0) {
                        newChars[pos++] = chars[i];
                        continue block8;
                    }
                    newChars[pos++] = 92;
                    newChars[pos++] = chars[i];
                    continue block8;
                }
                case '\"': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '\\': {
                    newChars[pos++] = 92;
                    newChars[pos++] = chars[i];
                    continue block8;
                }
                case '\u007f': {
                    newChars[pos++] = 92;
                    newChars[pos++] = 55;
                    newChars[pos++] = 70;
                    continue block8;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u000f': {
                    newChars[pos++] = 92;
                    newChars[pos++] = 48;
                    newChars[pos++] = Strings.dumpHex((byte)(chars[i] & 0xF));
                    continue block8;
                }
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    newChars[pos++] = 92;
                    newChars[pos++] = 49;
                    newChars[pos++] = Strings.dumpHex((byte)(chars[i] & 0xF));
                    continue block8;
                }
                default: {
                    newChars[pos++] = chars[i];
                }
            }
        }
        return new String(newChars, 0, pos);
    }

    public static String escapeValue(byte[] attrValue) {
        if (Strings.isEmpty(attrValue)) {
            return "";
        }
        String value = Strings.utf8ToString(attrValue);
        return Rdn.escapeValue(value);
    }

    public boolean isSchemaAware() {
        return this.schemaManager != null;
    }

    public static boolean isValid(String dn) {
        Rdn rdn = new Rdn();
        try {
            Rdn.parse(dn, rdn);
            return true;
        }
        catch (LdapInvalidDnException e) {
            return false;
        }
    }

    private static void parse(String dn, Rdn rdn) throws LdapInvalidDnException {
        try {
            FastDnParser.parseRdn(dn, rdn);
        }
        catch (TooComplexDnException e) {
            rdn.clear();
            new ComplexDnParser().parseRdn(dn, rdn);
        }
    }

    public int hashCode() {
        if (this.h == 0) {
            this.h = 37;
            switch (this.nbAvas) {
                case 0: {
                    break;
                }
                case 1: {
                    this.h = this.h * 17 + this.ava.hashCode();
                    break;
                }
                default: {
                    for (Ava ata : this.avas) {
                        this.h = this.h * 17 + ata.hashCode();
                    }
                }
            }
        }
        return this.h;
    }

    public int serialize(byte[] buffer, int pos) throws IOException {
        int length = 8;
        pos = Serialize.serialize(this.nbAvas, buffer, pos);
        byte[] upNameBytes = Strings.getBytesUtf8(this.upName);
        length += 4 + upNameBytes.length;
        byte[] normNameBytes = Strings.EMPTY_BYTES;
        length += 4;
        if (!this.upName.equals(this.normName)) {
            normNameBytes = Strings.getBytesUtf8(this.normName);
            length += 4 + normNameBytes.length;
        }
        if (buffer.length - pos < length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        pos = Serialize.serialize(upNameBytes, buffer, pos);
        pos = Serialize.serialize(normNameBytes, buffer, pos);
        switch (this.nbAvas) {
            case 0: {
                break;
            }
            case 1: {
                pos = this.ava.serialize(buffer, pos);
                break;
            }
            default: {
                for (Ava localAva : this.avas) {
                    pos = localAva.serialize(buffer, pos);
                }
            }
        }
        pos = Serialize.serialize(this.h, buffer, pos);
        return pos;
    }

    public int deserialize(byte[] buffer, int pos) throws IOException, LdapInvalidAttributeValueException {
        if (pos < 0 || pos >= buffer.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.nbAvas = Serialize.deserializeInt(buffer, pos);
        byte[] upNameBytes = Serialize.deserializeBytes(buffer, pos += 4);
        this.upName = Strings.utf8ToString(upNameBytes);
        byte[] normNameBytes = Serialize.deserializeBytes(buffer, pos += 4 + upNameBytes.length);
        pos += 4 + normNameBytes.length;
        this.normName = normNameBytes.length == 0 ? this.upName : Strings.utf8ToString(normNameBytes);
        switch (this.nbAvas) {
            case 0: {
                break;
            }
            case 1: {
                this.ava = new Ava(this.schemaManager);
                pos = this.ava.deserialize(buffer, pos);
                this.avaType = this.ava.getNormType();
                break;
            }
            default: {
                this.avas = new ArrayList<Ava>();
                this.avaTypes = new MultiValueMap();
                for (int i = 0; i < this.nbAvas; ++i) {
                    Ava newAva = new Ava(this.schemaManager);
                    pos = newAva.deserialize(buffer, pos);
                    this.avas.add(newAva);
                    this.avaTypes.put((Object)newAva.getNormType(), (Object)newAva);
                }
                this.ava = null;
                this.avaType = null;
            }
        }
        this.h = Serialize.deserializeInt(buffer, pos);
        return pos += 4;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.nbAvas);
        out.writeUTF(this.upName);
        if (this.upName.equals(this.normName)) {
            out.writeUTF("");
        } else {
            out.writeUTF(this.normName);
        }
        switch (this.nbAvas) {
            case 0: {
                break;
            }
            case 1: {
                this.ava.writeExternal(out);
                break;
            }
            default: {
                for (Ava localAva : this.avas) {
                    localAva.writeExternal(out);
                }
            }
        }
        out.writeInt(this.h);
        out.flush();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.nbAvas = in.readInt();
        this.upName = in.readUTF();
        this.normName = in.readUTF();
        if (Strings.isEmpty(this.normName)) {
            this.normName = this.upName;
        }
        switch (this.nbAvas) {
            case 0: {
                this.ava = null;
                break;
            }
            case 1: {
                this.ava = new Ava(this.schemaManager);
                this.ava.readExternal(in);
                this.avaType = this.ava.getNormType();
                break;
            }
            default: {
                this.avas = new ArrayList<Ava>();
                this.avaTypes = new MultiValueMap();
                for (int i = 0; i < this.nbAvas; ++i) {
                    Ava newAva = new Ava(this.schemaManager);
                    newAva.readExternal(in);
                    this.avas.add(newAva);
                    this.avaTypes.put((Object)newAva.getNormType(), (Object)newAva);
                }
                this.ava = null;
                this.avaType = null;
            }
        }
        this.h = in.readInt();
    }

    @Override
    public int compareTo(Rdn arg0) {
        return 0;
    }

    public String toString() {
        return this.upName == null ? "" : this.upName;
    }
}

