/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.ldif.LdifUtils;
import org.apache.directory.api.ldap.model.ldif.anonymizer.Anonymizer;
import org.apache.directory.api.ldap.model.ldif.anonymizer.BinaryAnonymizer;
import org.apache.directory.api.ldap.model.ldif.anonymizer.IntegerAnonymizer;
import org.apache.directory.api.ldap.model.ldif.anonymizer.StringAnonymizer;
import org.apache.directory.api.ldap.model.name.Ava;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.schema.manager.impl.DefaultSchemaManager;

public class LdifAnonymizer {
    Map<AttributeType, Anonymizer> attributeAnonymizers = new HashMap<AttributeType, Anonymizer>();
    SchemaManager schemaManager;
    private static final String CONFIG_FILE_OPT = "f";
    private static String configFile;

    public LdifAnonymizer() {
        try {
            this.schemaManager = new DefaultSchemaManager();
        }
        catch (Exception e) {
            System.out.println("Missing a SchemaManager !");
            System.exit(-1);
        }
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("carLicense"), new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("cn"), new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("description"), new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("displayName"), new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("gecos"), new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("gidNumber"), new IntegerAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("givenName"), new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("homeDirectory"), new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("homePhone"), new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("homePostalAddress"), new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("host"), new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("houseIdentifier"), new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("jpegPhoto"), new BinaryAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("labeledURI"), new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("localityName"), new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("mail"), new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("manager"), new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("memberUid"), new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("mobile"), new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("organizationName"), new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("organizationalUnitName"), new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("pager"), new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("postalAddress"), new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("photo"), new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("secretary"), new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("seeAlso"), new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("sn"), new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("telephoneNumber"), new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("uid"), new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("uidNumber"), new IntegerAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("userCertificate"), new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("userPassword"), new BinaryAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("userPKCS12"), new BinaryAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("userSMIMECertificate"), new BinaryAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("x500UniqueIdentifier"), new BinaryAnonymizer());
    }

    public LdifAnonymizer(Map<String, Anonymizer> attributeAnonymizers) {
        for (String string : attributeAnonymizers.keySet()) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String anonymize(String ldif) throws LdapException, IOException {
        LdifReader ldifReader = new LdifReader(this.schemaManager);
        try {
            List<LdifEntry> entries = ldifReader.parseLdif(ldif);
            StringBuilder result = new StringBuilder();
            for (LdifEntry ldifEntry : entries) {
                Entry entry = ldifEntry.getEntry();
                DefaultEntry newEntry = new DefaultEntry(this.schemaManager);
                Dn dn = entry.getDn();
                Rdn rdns = dn.getRdn();
                ArrayList<Attribute> rdnAttributes = new ArrayList<Attribute>();
                ArrayList<Ava> avas = new ArrayList<Ava>();
                boolean dnAnonymized = false;
                for (Ava ava : rdns) {
                    Anonymizer anonymizer;
                    Attribute rdnAttribute = entry.get(ava.getType());
                    DefaultAttribute newRdnAttribute = new DefaultAttribute(rdnAttribute.getUpId(), rdnAttribute.getAttributeType());
                    newRdnAttribute.add(rdnAttribute.get());
                    rdnAttribute.remove(rdnAttribute.get());
                    if (rdnAttribute.size() == 0) {
                        entry.remove(rdnAttribute);
                    }
                    if ((anonymizer = this.attributeAnonymizers.get(rdnAttribute.getAttributeType())) != null) {
                        Attribute anonymizedAttribute = anonymizer.anonymize(newRdnAttribute);
                        dnAnonymized = true;
                        rdnAttributes.add(anonymizedAttribute);
                        if (anonymizedAttribute.isHumanReadable()) {
                            avas.add(new Ava(this.schemaManager, rdnAttribute.getUpId(), anonymizedAttribute.getString()));
                            continue;
                        }
                        avas.add(new Ava(this.schemaManager, rdnAttribute.getUpId(), anonymizedAttribute.getBytes()));
                        continue;
                    }
                    avas.add(ava);
                }
                if (dnAnonymized) {
                    Rdn newRdn = new Rdn(this.schemaManager, avas.toArray(new Ava[0]));
                    dn = new Dn(newRdn, dn.getParent());
                }
                for (Attribute attribute : entry) {
                    Anonymizer anonymizer = this.attributeAnonymizers.get(attribute.getAttributeType());
                    if (anonymizer == null) {
                        newEntry.add(attribute);
                        continue;
                    }
                    Attribute anonymizedAttribute = anonymizer.anonymize(attribute);
                    newEntry.add(anonymizedAttribute);
                }
                for (Attribute rdnAttribute : rdnAttributes) {
                    Attribute attribute = newEntry.get(rdnAttribute.getAttributeType());
                    if (attribute == null) {
                        newEntry.add(rdnAttribute);
                        continue;
                    }
                    for (Value value : rdnAttribute) {
                        attribute.add(value);
                    }
                }
                newEntry.setDn(dn);
                result.append(LdifUtils.convertToLdif(newEntry));
                result.append("\n");
            }
            String string = result.toString();
            return string;
        }
        finally {
            ldifReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, LdapException {
        if (args == null || args.length < 1) {
            System.out.println("No file to anonymize");
            return;
        }
        LdifAnonymizer anonymizer = new LdifAnonymizer();
        BufferedReader br = new BufferedReader(new FileReader(args[0]));
        String ldifString = null;
        try {
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append(System.lineSeparator());
                line = br.readLine();
            }
            ldifString = sb.toString();
        }
        finally {
            br.close();
        }
        String result = anonymizer.anonymize(ldifString);
        System.out.println(result);
    }
}

