/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.dsmlv2;

import java.io.IOException;
import java.util.HashMap;
import org.apache.directory.api.dsmlv2.Dsmlv2Container;
import org.apache.directory.api.dsmlv2.Dsmlv2StatesEnum;
import org.apache.directory.api.dsmlv2.Grammar;
import org.apache.directory.api.dsmlv2.GrammarAction;
import org.apache.directory.api.dsmlv2.GrammarTransition;
import org.apache.directory.api.dsmlv2.Tag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.util.Strings;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class AbstractGrammar
implements Grammar {
    protected HashMap<Tag, GrammarTransition>[] transitions;
    protected String name;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public GrammarTransition getTransition(Enum<Dsmlv2StatesEnum> state, Tag tag) {
        return this.transitions[state.ordinal()].get(tag);
    }

    @Override
    public Enum<Dsmlv2StatesEnum>[] getStatesEnum() {
        return Dsmlv2StatesEnum.values();
    }

    @Override
    public void executeAction(Dsmlv2Container container) throws XmlPullParserException, IOException {
        XmlPullParser xpp = container.getParser();
        int eventType = xpp.getEventType();
        do {
            switch (eventType) {
                case 0: {
                    container.setState(Dsmlv2StatesEnum.INIT_GRAMMAR_STATE);
                    break;
                }
                case 1: {
                    container.setState(Dsmlv2StatesEnum.GRAMMAR_END);
                    break;
                }
                case 2: {
                    this.processTag(container, 0);
                    break;
                }
                case 3: {
                    this.processTag(container, 1);
                }
            }
        } while ((eventType = xpp.next()) != 1);
    }

    private void processTag(Dsmlv2Container container, int tagType) throws XmlPullParserException {
        XmlPullParser xpp = container.getParser();
        String tagName = Strings.toLowerCase(xpp.getName());
        GrammarTransition transition = this.getTransition(container.getState(), new Tag(tagName, tagType));
        if (transition != null) {
            container.setState(transition.getNextState());
            if (transition.hasAction()) {
                GrammarAction action = transition.getAction();
                action.action(container);
            }
        } else {
            throw new XmlPullParserException(I18n.err(I18n.ERR_03036, new Tag(tagName, tagType)), xpp, null);
        }
    }
}

