/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.proxy.impl.invocation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.interceptor.InvocationContext;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;
import org.apache.deltaspike.proxy.impl.invocation.AbstractManualInvocationHandler;
import org.apache.deltaspike.proxy.impl.invocation.ManualInvocationThrowableWrapperException;

@Typed
public class ManualInvocationContext<T, H>
implements InvocationContext {
    protected List<Interceptor<H>> interceptors;
    protected int interceptorIndex;
    protected T target;
    protected Method method;
    protected Object[] parameters;
    protected Map<String, Object> contextData;
    protected Object timer;
    protected AbstractManualInvocationHandler manualInvocationHandler;
    protected BeanManager beanManager;
    protected boolean proceedOriginal;
    protected Object proceedOriginalReturnValue;

    public ManualInvocationContext(AbstractManualInvocationHandler manualInvocationHandler, List<Interceptor<H>> interceptors, T target, Method method, Object[] parameters, Object timer) {
        this.manualInvocationHandler = manualInvocationHandler;
        this.interceptors = interceptors;
        this.target = target;
        this.method = method;
        this.parameters = parameters;
        this.timer = timer;
        this.interceptorIndex = 0;
    }

    public Object getTarget() {
        return this.target;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object[] os) {
        this.parameters = os;
    }

    public Map<String, Object> getContextData() {
        if (this.contextData == null) {
            this.contextData = new HashMap<String, Object>();
        }
        return this.contextData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object proceed() throws Exception {
        if (this.proceedOriginal) {
            return null;
        }
        if (this.interceptors.size() > this.interceptorIndex) {
            Object object;
            block10: {
                CreationalContext creationalContext;
                block11: {
                    Interceptor<H> interceptor = null;
                    creationalContext = null;
                    Object interceptorInstance = null;
                    try {
                        if (this.beanManager == null) {
                            this.beanManager = BeanManagerProvider.getInstance().getBeanManager();
                        }
                        interceptor = this.interceptors.get(this.interceptorIndex++);
                        creationalContext = this.beanManager.createCreationalContext(interceptor);
                        interceptorInstance = interceptor.create(creationalContext);
                        object = interceptor.intercept(InterceptionType.AROUND_INVOKE, interceptorInstance, (InvocationContext)this);
                        if (creationalContext == null) break block10;
                        if (interceptorInstance == null || interceptor == null) break block11;
                    }
                    catch (Throwable throwable) {
                        if (creationalContext != null) {
                            if (interceptorInstance != null && interceptor != null) {
                                interceptor.destroy(interceptorInstance, creationalContext);
                            }
                            creationalContext.release();
                        }
                        throw throwable;
                    }
                    interceptor.destroy(interceptorInstance, creationalContext);
                }
                creationalContext.release();
            }
            return object;
        }
        try {
            this.proceedOriginal = true;
            this.proceedOriginalReturnValue = this.manualInvocationHandler.proceedOriginal(this.target, this.method, this.parameters);
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ManualInvocationThrowableWrapperException(e);
        }
        return null;
    }

    public Object getTimer() {
        return this.timer;
    }

    public Constructor getConstructor() {
        return null;
    }

    public boolean isProceedOriginal() {
        return this.proceedOriginal;
    }

    public Object getProceedOriginalReturnValue() {
        return this.proceedOriginalReturnValue;
    }

    public void setProceedOriginalReturnValue(Object proceedOriginalReturnValue) {
        this.proceedOriginalReturnValue = proceedOriginalReturnValue;
    }
}

