/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.proxy.impl.invocation;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.interceptor.InterceptorBinding;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;
import org.apache.deltaspike.proxy.impl.invocation.ManualInvocationContext;
import org.apache.deltaspike.proxy.impl.invocation.ManualInvocationThrowableWrapperException;

@Typed
public abstract class AbstractManualInvocationHandler
implements InvocationHandler {
    @Override
    public Object invoke(Object proxy, Method method, Object[] parameters) throws Throwable {
        List interceptors = this.resolveInterceptors(proxy, method);
        if (interceptors != null && interceptors.size() > 0) {
            try {
                ManualInvocationContext invocationContext = new ManualInvocationContext(this, interceptors, proxy, method, parameters, null);
                Object returnValue = invocationContext.proceed();
                if (invocationContext.isProceedOriginal()) {
                    return invocationContext.getProceedOriginalReturnValue();
                }
                return returnValue;
            }
            catch (ManualInvocationThrowableWrapperException e) {
                throw e.getCause();
            }
        }
        return this.proceedOriginal(proxy, method, parameters);
    }

    protected abstract Object proceedOriginal(Object var1, Method var2, Object[] var3) throws Throwable;

    protected List<Interceptor<?>> resolveInterceptors(Object instance, Method method) {
        BeanManager beanManager = BeanManagerProvider.getInstance().getBeanManager();
        Annotation[] interceptorBindings = this.extractInterceptorBindings(beanManager, instance, method);
        if (interceptorBindings.length > 0) {
            return beanManager.resolveInterceptors(InterceptionType.AROUND_INVOKE, interceptorBindings);
        }
        return null;
    }

    protected Annotation[] extractInterceptorBindings(BeanManager beanManager, Object instance, Method method) {
        ArrayList<Annotation> bindings = new ArrayList<Annotation>();
        this.addInterceptorBindings(beanManager, bindings, instance.getClass().getDeclaredAnnotations());
        this.addInterceptorBindings(beanManager, bindings, method.getDeclaredAnnotations());
        return bindings.toArray(new Annotation[bindings.size()]);
    }

    protected void addInterceptorBindings(BeanManager beanManager, ArrayList<Annotation> bindings, Annotation[] declaredAnnotations) {
        for (Annotation annotation : declaredAnnotations) {
            if (bindings.contains(annotation)) continue;
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (annotationType.isAnnotationPresent(InterceptorBinding.class)) {
                bindings.add(annotation);
            }
            if (!beanManager.isStereotype(annotationType)) continue;
            for (Annotation subAnnotation : annotationType.getDeclaredAnnotations()) {
                if (bindings.contains(subAnnotation) || !subAnnotation.annotationType().isAnnotationPresent(InterceptorBinding.class)) continue;
                bindings.add(subAnnotation);
            }
        }
    }
}

