/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.proxy.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import javax.enterprise.inject.Typed;
import org.apache.deltaspike.proxy.asm5.ClassWriter;
import org.apache.deltaspike.proxy.asm5.Label;
import org.apache.deltaspike.proxy.asm5.Type;
import org.apache.deltaspike.proxy.asm5.commons.GeneratorAdapter;
import org.apache.deltaspike.proxy.asm5.commons.Method;
import org.apache.deltaspike.proxy.impl.invocation.DelegateManualInvocationHandler;
import org.apache.deltaspike.proxy.impl.invocation.InterceptManualInvocationHandler;
import org.apache.deltaspike.proxy.spi.DeltaSpikeProxy;
import org.apache.deltaspike.proxy.spi.ProxyClassGenerator;

@Typed
public class AsmProxyClassGenerator
implements ProxyClassGenerator {
    private static final String FIELDNAME_DELEGATE_INVOCATION_HANDLER = "delegateInvocationHandler";
    private static final Type TYPE_CLASS = Type.getType(Class.class);
    private static final Type TYPE_OBJECT = Type.getType(Object.class);

    public <T> Class<T> generateProxyClass(ClassLoader classLoader, Class<T> targetClass, Class<? extends InvocationHandler> delegateInvocationHandlerClass, String suffix, String superAccessorMethodSuffix, Class<?>[] additionalInterfaces, java.lang.reflect.Method[] delegateMethods, java.lang.reflect.Method[] interceptMethods) {
        String proxyName = targetClass.getCanonicalName() + suffix;
        String classFileName = proxyName.replace('.', '/');
        byte[] proxyBytes = AsmProxyClassGenerator.generateProxyClassBytes(targetClass, delegateInvocationHandlerClass, classFileName, superAccessorMethodSuffix, additionalInterfaces, delegateMethods, interceptMethods);
        Class<?> proxyClass = AsmProxyClassGenerator.loadClass(classLoader, proxyName, proxyBytes, targetClass.getProtectionDomain());
        return proxyClass;
    }

    private static byte[] generateProxyClassBytes(Class<?> targetClass, Class<? extends InvocationHandler> delegateInvocationHandlerClass, String proxyName, String superAccessorMethodSuffix, Class<?>[] additionalInterfaces, java.lang.reflect.Method[] delegateMethods, java.lang.reflect.Method[] interceptMethods) {
        Class<Object> superClass = targetClass;
        String[] interfaces = new String[]{};
        if (targetClass.isInterface()) {
            superClass = Object.class;
            interfaces = new String[]{Type.getInternalName(targetClass)};
        }
        interfaces = Arrays.copyOf(interfaces, interfaces.length + 1);
        interfaces[interfaces.length - 1] = Type.getInternalName(DeltaSpikeProxy.class);
        if (additionalInterfaces != null && additionalInterfaces.length > 0) {
            interfaces = Arrays.copyOf(interfaces, interfaces.length + additionalInterfaces.length);
            for (int i = 0; i < additionalInterfaces.length; ++i) {
                interfaces[interfaces.length - 1 + i] = Type.getInternalName(additionalInterfaces[i]);
            }
        }
        Type superType = Type.getType(superClass);
        Type proxyType = Type.getObjectType(proxyName);
        Type delegateInvocationHandlerType = Type.getType(delegateInvocationHandlerClass);
        ClassWriter cw = new ClassWriter(1);
        cw.visit(50, 33, proxyType.getInternalName(), null, superType.getInternalName(), interfaces);
        for (Annotation annotation : targetClass.getDeclaredAnnotations()) {
            cw.visitAnnotation(Type.getDescriptor(annotation.annotationType()), true).visitEnd();
        }
        AsmProxyClassGenerator.defineInvocationHandlerField(cw, delegateInvocationHandlerType);
        AsmProxyClassGenerator.defineDefaultConstructor(cw, proxyType, superType);
        AsmProxyClassGenerator.defineDelegateInvocationHandlerConstructor(cw, proxyType, superType, delegateInvocationHandlerType);
        AsmProxyClassGenerator.defineDeltaSpikeProxyMethods(cw, proxyType, delegateInvocationHandlerType);
        for (java.lang.reflect.Method method : delegateMethods) {
            AsmProxyClassGenerator.defineMethod(cw, method, DelegateManualInvocationHandler.class);
        }
        for (java.lang.reflect.Method method : interceptMethods) {
            AsmProxyClassGenerator.defineSuperAccessorMethod(cw, method, superType, superAccessorMethodSuffix);
            AsmProxyClassGenerator.defineMethod(cw, method, InterceptManualInvocationHandler.class);
        }
        return cw.toByteArray();
    }

    private static void defineInvocationHandlerField(ClassWriter cw, Type delegateInvocationHandlerType) {
        cw.visitField(2, FIELDNAME_DELEGATE_INVOCATION_HANDLER, delegateInvocationHandlerType.getDescriptor(), null, null).visitEnd();
    }

    private static void defineDefaultConstructor(ClassWriter cw, Type proxyType, Type superType) {
        GeneratorAdapter mg = new GeneratorAdapter(1, new Method("<init>", Type.VOID_TYPE, new Type[0]), null, null, cw);
        mg.visitCode();
        mg.loadThis();
        mg.invokeConstructor(superType, Method.getMethod("void <init> ()"));
        mg.returnValue();
        mg.endMethod();
        mg.visitEnd();
    }

    private static void defineDelegateInvocationHandlerConstructor(ClassWriter cw, Type proxyType, Type superType, Type delegateInvocationHandlerType) {
        GeneratorAdapter mg = new GeneratorAdapter(1, new Method("<init>", Type.VOID_TYPE, new Type[]{delegateInvocationHandlerType}), null, null, cw);
        mg.visitCode();
        mg.loadThis();
        mg.invokeConstructor(superType, Method.getMethod("void <init> ()"));
        mg.loadThis();
        mg.loadArg(0);
        mg.putField(proxyType, FIELDNAME_DELEGATE_INVOCATION_HANDLER, delegateInvocationHandlerType);
        mg.returnValue();
        mg.endMethod();
        mg.visitEnd();
    }

    private static void defineDeltaSpikeProxyMethods(ClassWriter cw, Type proxyType, Type delegateInvocationHandlerType) {
        try {
            Method asmMethod = Method.getMethod(DeltaSpikeProxy.class.getDeclaredMethod("setDelegateInvocationHandler", InvocationHandler.class));
            GeneratorAdapter mg = new GeneratorAdapter(1, asmMethod, null, null, cw);
            mg.visitCode();
            mg.loadThis();
            mg.loadArg(0);
            mg.checkCast(delegateInvocationHandlerType);
            mg.putField(proxyType, FIELDNAME_DELEGATE_INVOCATION_HANDLER, delegateInvocationHandlerType);
            mg.returnValue();
            mg.visitMaxs(2, 1);
            mg.visitEnd();
            asmMethod = Method.getMethod(DeltaSpikeProxy.class.getDeclaredMethod("getDelegateInvocationHandler", new Class[0]));
            mg = new GeneratorAdapter(1, asmMethod, null, null, cw);
            mg.visitCode();
            mg.loadThis();
            mg.getField(proxyType, FIELDNAME_DELEGATE_INVOCATION_HANDLER, delegateInvocationHandlerType);
            mg.returnValue();
            mg.visitMaxs(2, 1);
            mg.visitEnd();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Unable to implement " + DeltaSpikeProxy.class.getName(), e);
        }
    }

    private static void defineSuperAccessorMethod(ClassWriter cw, java.lang.reflect.Method method, Type superType, String superAccessorMethodSuffix) {
        Method originalAsmMethod = Method.getMethod(method);
        Method newAsmMethod = new Method(method.getName() + superAccessorMethodSuffix, originalAsmMethod.getReturnType(), originalAsmMethod.getArgumentTypes());
        GeneratorAdapter mg = new GeneratorAdapter(1, newAsmMethod, null, null, cw);
        mg.visitCode();
        mg.loadThis();
        mg.loadArgs();
        mg.visitMethodInsn(183, superType.getInternalName(), method.getName(), Type.getMethodDescriptor(method), false);
        mg.returnValue();
        mg.endMethod();
        mg.visitMaxs(10, 10);
        mg.visitEnd();
    }

    private static void defineMethod(ClassWriter cw, java.lang.reflect.Method method, Class manualInvocationHandlerClass) {
        Type methodType = Type.getType(method);
        ArrayList<Type> exceptionsToCatch = new ArrayList<Type>();
        for (Class<?> exception : method.getExceptionTypes()) {
            if (RuntimeException.class.isAssignableFrom(exception)) continue;
            exceptionsToCatch.add(Type.getType(exception));
        }
        int modifiers = 5 & method.getModifiers();
        Method asmMethod = Method.getMethod(method);
        GeneratorAdapter mg = new GeneratorAdapter(modifiers, asmMethod, null, AsmProxyClassGenerator.getTypes(method.getExceptionTypes()), cw);
        for (Annotation annotation : method.getDeclaredAnnotations()) {
            mg.visitAnnotation(Type.getDescriptor(annotation.annotationType()), true).visitEnd();
        }
        mg.visitCode();
        Label tryBlockStart = mg.mark();
        mg.loadThis();
        AsmProxyClassGenerator.loadCurrentMethod(mg, method, methodType);
        AsmProxyClassGenerator.loadArguments(mg, method, methodType);
        mg.invokeStatic(Type.getType(manualInvocationHandlerClass), Method.getMethod("Object staticInvoke(Object, java.lang.reflect.Method, Object[])"));
        mg.unbox(methodType.getReturnType());
        Label tryBlockEnd = mg.mark();
        mg.returnValue();
        Label rethrow = mg.mark();
        mg.visitVarInsn(58, 1);
        mg.visitVarInsn(25, 1);
        mg.throwException();
        mg.visitTryCatchBlock(tryBlockStart, tryBlockEnd, rethrow, Type.getInternalName(RuntimeException.class));
        boolean throwableCatched = false;
        if (exceptionsToCatch.size() > 0) {
            rethrow = mg.mark();
            mg.visitVarInsn(58, 1);
            mg.visitVarInsn(25, 1);
            mg.throwException();
            for (Type exceptionType : exceptionsToCatch) {
                if (exceptionType.getClassName().equals(Throwable.class.getName())) {
                    throwableCatched = true;
                }
                mg.visitTryCatchBlock(tryBlockStart, tryBlockEnd, rethrow, exceptionType.getInternalName());
            }
        }
        if (!throwableCatched) {
            Type uteType = Type.getType(UndeclaredThrowableException.class);
            Label wrapAndRethrow = mg.mark();
            mg.visitVarInsn(58, 1);
            mg.newInstance(uteType);
            mg.dup();
            mg.visitVarInsn(25, 1);
            mg.invokeConstructor(uteType, Method.getMethod("void <init>(java.lang.Throwable)"));
            mg.throwException();
            mg.visitTryCatchBlock(tryBlockStart, tryBlockEnd, wrapAndRethrow, Type.getInternalName(Throwable.class));
        }
        mg.endMethod();
        mg.visitMaxs(10, 10);
        mg.visitEnd();
    }

    private static void loadCurrentMethod(GeneratorAdapter mg, java.lang.reflect.Method method, Type methodType) {
        mg.push(Type.getType(method.getDeclaringClass()));
        mg.push(method.getName());
        mg.push(methodType.getArgumentTypes().length);
        mg.newArray(TYPE_CLASS);
        for (int i = 0; i < methodType.getArgumentTypes().length; ++i) {
            mg.dup();
            mg.push(i);
            mg.push(methodType.getArgumentTypes()[i]);
            mg.arrayStore(TYPE_CLASS);
        }
        mg.invokeVirtual(TYPE_CLASS, Method.getMethod("java.lang.reflect.Method getDeclaredMethod(String, Class[])"));
    }

    private static void loadArguments(GeneratorAdapter mg, java.lang.reflect.Method method, Type methodType) {
        mg.push(methodType.getArgumentTypes().length);
        mg.newArray(TYPE_OBJECT);
        for (int i = 0; i < methodType.getArgumentTypes().length; ++i) {
            mg.dup();
            mg.push(i);
            mg.loadArg(i);
            mg.valueOf(methodType.getArgumentTypes()[i]);
            mg.arrayStore(TYPE_OBJECT);
        }
    }

    private static Type[] getTypes(Class<?> ... src) {
        Type[] result = new Type[src.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Type.getType(src[i]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> loadClass(ClassLoader loader, String className, byte[] b, ProtectionDomain protectionDomain) {
        java.lang.reflect.Method method = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
        boolean accessible = method.isAccessible();
        if (!accessible) {
            method.setAccessible(true);
        }
        try {
            Class clazz = (Class)method.invoke((Object)loader, className, b, 0, b.length, protectionDomain);
            if (!accessible) {
                method.setAccessible(false);
            }
            return clazz;
        }
        catch (Throwable throwable) {
            try {
                if (!accessible) {
                    method.setAccessible(false);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
            }
        }
    }
}

