/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.proxy.api;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.PassivationCapable;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.util.ExceptionUtils;
import org.apache.deltaspike.core.util.metadata.builder.ContextualLifecycle;
import org.apache.deltaspike.proxy.api.DeltaSpikeProxyFactory;

public class DeltaSpikeProxyContextualLifecycle<T, H extends InvocationHandler>
implements ContextualLifecycle<T> {
    private final Class<T> proxyClass;
    private final Class<H> delegateInvocationHandlerClass;
    private final Class<T> targetClass;
    private InjectionTarget<T> injectionTarget;
    private CreationalContext<?> creationalContextOfDependentHandler;

    public DeltaSpikeProxyContextualLifecycle(Class<T> targetClass, Class<H> delegateInvocationHandlerClass, DeltaSpikeProxyFactory proxyFactory, BeanManager beanManager) {
        this.targetClass = targetClass;
        this.delegateInvocationHandlerClass = delegateInvocationHandlerClass;
        this.proxyClass = proxyFactory.getProxyClass(beanManager, targetClass, delegateInvocationHandlerClass);
        if (!targetClass.isInterface()) {
            AnnotatedType annotatedType = beanManager.createAnnotatedType(this.targetClass);
            this.injectionTarget = beanManager.createInjectionTarget(annotatedType);
        }
    }

    public T create(Bean bean, CreationalContext creationalContext) {
        try {
            T instance;
            if (this.delegateInvocationHandlerClass == null) {
                instance = this.proxyClass.newInstance();
            } else {
                H delegateInvocationHandler = this.instantiateDelegateInvocationHandler();
                Constructor<T> constructor = this.proxyClass.getConstructor(this.delegateInvocationHandlerClass);
                instance = constructor.newInstance(delegateInvocationHandler);
            }
            if (this.injectionTarget != null) {
                this.injectionTarget.inject(instance, creationalContext);
                this.injectionTarget.postConstruct(instance);
            }
            return instance;
        }
        catch (Exception e) {
            ExceptionUtils.throwAsRuntimeException((Throwable)e);
            return null;
        }
    }

    public void destroy(Bean<T> bean, T instance, CreationalContext<T> creationalContext) {
        if (this.injectionTarget != null) {
            this.injectionTarget.preDestroy(instance);
        }
        if (this.creationalContextOfDependentHandler != null) {
            this.creationalContextOfDependentHandler.release();
        }
        creationalContext.release();
    }

    protected H instantiateDelegateInvocationHandler() {
        Set handlerBeans = BeanProvider.getBeanDefinitions(this.delegateInvocationHandlerClass, (boolean)false, (boolean)true);
        if (handlerBeans.size() != 1) {
            StringBuilder beanInfo = new StringBuilder();
            for (Bean bean : handlerBeans) {
                if (beanInfo.length() != 0) {
                    beanInfo.append(", ");
                }
                beanInfo.append(bean);
                if (!(bean instanceof PassivationCapable)) continue;
                beanInfo.append(" bean-id: ").append(((PassivationCapable)bean).getId());
            }
            throw new IllegalStateException(handlerBeans.size() + " beans found for " + this.delegateInvocationHandlerClass + " found beans: " + beanInfo.toString());
        }
        Bean handlerBean = (Bean)handlerBeans.iterator().next();
        BeanManager beanManager = BeanManagerProvider.getInstance().getBeanManager();
        CreationalContext creationalContext = beanManager.createCreationalContext((Contextual)handlerBean);
        InvocationHandler handlerInstance = (InvocationHandler)beanManager.getReference(handlerBean, this.delegateInvocationHandlerClass, creationalContext);
        if (handlerBean.getScope().equals(Dependent.class)) {
            this.creationalContextOfDependentHandler = creationalContext;
        }
        return (H)handlerInstance;
    }
}

