/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.handler;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.QueryHint;
import org.apache.deltaspike.data.api.SingleResultType;
import org.apache.deltaspike.data.api.mapping.QueryInOutMapper;
import org.apache.deltaspike.data.impl.handler.JpaQueryPostProcessor;
import org.apache.deltaspike.data.impl.handler.QueryStringPostProcessor;
import org.apache.deltaspike.data.impl.meta.RepositoryMethod;
import org.apache.deltaspike.data.impl.param.Parameters;
import org.apache.deltaspike.data.impl.util.EntityUtils;
import org.apache.deltaspike.data.impl.util.bean.Destroyable;
import org.apache.deltaspike.data.spi.QueryInvocationContext;

public class CdiQueryInvocationContext
implements QueryInvocationContext {
    private final EntityManager entityManager;
    private final Parameters params;
    private final Class<?> entityClass;
    private final Object proxy;
    private final Method method;
    private final Object[] args;
    private final RepositoryMethod repoMethod;
    private final List<QueryStringPostProcessor> queryPostProcessors;
    private final List<JpaQueryPostProcessor> jpaPostProcessors;
    private final List<Destroyable> cleanup;
    private String queryString;

    public CdiQueryInvocationContext(Object proxy, Method method, Object[] args, RepositoryMethod repoMethod, EntityManager entityManager) {
        this.entityManager = entityManager;
        this.args = args == null ? new Object[]{} : args;
        this.params = Parameters.create(method, this.args);
        this.proxy = proxy;
        this.method = method;
        this.repoMethod = repoMethod;
        this.entityClass = repoMethod.getRepository().getEntityClass();
        this.queryPostProcessors = new LinkedList<QueryStringPostProcessor>();
        this.jpaPostProcessors = new LinkedList<JpaQueryPostProcessor>();
        this.cleanup = new LinkedList<Destroyable>();
    }

    public void initMapper() {
        if (this.hasQueryInOutMapper()) {
            QueryInOutMapper<?> mapper = this.getQueryInOutMapper();
            this.params.applyMapper(mapper);
            for (int i = 0; i < this.args.length; ++i) {
                if (!mapper.mapsParameter(this.args[i])) continue;
                this.args[i] = mapper.mapParameter(this.args[i]);
            }
        }
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public boolean isNew(Object entity) {
        try {
            if (EntityUtils.primaryKeyValue(entity) == null) {
                return true;
            }
            return !this.entityManager.contains(entity) && this.countCheck(entity);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public Class<?> getRepositoryClass() {
        return this.repoMethod.getRepository().getRepositoryClass();
    }

    public Object proceed() throws Exception {
        return this.method.invoke(this.proxy, this.args);
    }

    public Method getMethod() {
        return this.method;
    }

    public Query applyRestrictions(Query query) {
        Parameters params = this.getParams();
        Method method = this.getMethod();
        if (params.hasSizeRestriction()) {
            query.setMaxResults(params.getSizeRestriciton());
        }
        if (params.hasFirstResult()) {
            query.setFirstResult(params.getFirstResult());
        }
        if (this.hasLockMode(method)) {
            query.setLockMode(this.extractLockMode(method));
        }
        if (this.hasQueryHints(method)) {
            QueryHint[] hints;
            for (QueryHint hint : hints = this.extractQueryHints(method)) {
                query.setHint(hint.name(), (Object)hint.value());
            }
        }
        query = this.applyJpaQueryPostProcessors(query);
        return query;
    }

    public Object[] getMethodParameters() {
        return this.args;
    }

    public void addQueryStringPostProcessor(QueryStringPostProcessor postProcessor) {
        this.queryPostProcessors.add(postProcessor);
    }

    public void addJpaQueryPostProcessor(JpaQueryPostProcessor postProcessor) {
        this.jpaPostProcessors.add(postProcessor);
    }

    public void removeJpaQueryPostProcessor(JpaQueryPostProcessor postProcessor) {
        this.jpaPostProcessors.remove(postProcessor);
    }

    public boolean hasQueryStringPostProcessors() {
        return !this.queryPostProcessors.isEmpty();
    }

    public String applyQueryStringPostProcessors(String queryString) {
        String result = queryString;
        for (QueryStringPostProcessor processor : this.queryPostProcessors) {
            result = processor.postProcess(result);
        }
        return result;
    }

    public Query applyJpaQueryPostProcessors(Query query) {
        Query result = query;
        for (JpaQueryPostProcessor processor : this.jpaPostProcessors) {
            result = processor.postProcess(this, result);
        }
        return result;
    }

    public void addDestroyable(Destroyable destroyable) {
        this.cleanup.add(destroyable);
    }

    public void cleanup() {
        for (Destroyable destroy : this.cleanup) {
            destroy.destroy();
        }
        this.cleanup.clear();
    }

    public Object executeQuery(Query jpaQuery) {
        return this.repoMethod.getQueryProcessor().executeQuery(jpaQuery, this);
    }

    public Parameters getParams() {
        return this.params;
    }

    public RepositoryMethod getRepositoryMethod() {
        return this.repoMethod;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public List<QueryStringPostProcessor> getQueryStringPostProcessors() {
        return this.queryPostProcessors;
    }

    public boolean hasQueryInOutMapper() {
        return this.repoMethod.hasQueryInOutMapper();
    }

    public QueryInOutMapper<?> getQueryInOutMapper() {
        return this.repoMethod.getQueryInOutMapperInstance(this);
    }

    public SingleResultType getSingleResultStyle() {
        return this.repoMethod.getSingleResultStyle();
    }

    public Object getProxy() {
        return this.proxy;
    }

    private boolean hasLockMode(Method method) {
        return this.extractLockMode(method) != null;
    }

    private LockModeType extractLockMode(Method method) {
        Class<org.apache.deltaspike.data.api.Query> query = org.apache.deltaspike.data.api.Query.class;
        if (method.isAnnotationPresent(query) && method.getAnnotation(query).lock() != LockModeType.NONE) {
            return method.getAnnotation(query).lock();
        }
        return null;
    }

    private QueryHint[] extractQueryHints(Method method) {
        Class<org.apache.deltaspike.data.api.Query> query = org.apache.deltaspike.data.api.Query.class;
        if (method.isAnnotationPresent(query) && method.getAnnotation(query).hints().length > 0) {
            return method.getAnnotation(query).hints();
        }
        return null;
    }

    private boolean hasQueryHints(Method method) {
        return this.extractQueryHints(method) != null;
    }

    private boolean countCheck(Object entity) {
        StringBuilder jpql = new StringBuilder("SELECT COUNT(e) FROM " + this.getEntityClass().getSimpleName() + " e ");
        jpql.append("WHERE e.");
        jpql.append(EntityUtils.primaryKey(this.getEntityClass()).getName());
        jpql.append(" = :id");
        Query query = this.entityManager.createQuery(jpql.toString());
        query.setParameter("id", EntityUtils.primaryKeyValue(entity));
        Long result = (Long)query.getSingleResult();
        return Long.valueOf(0L).equals(result);
    }
}

