/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.builder.part;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.apache.deltaspike.data.impl.builder.QueryBuilderContext;
import org.apache.deltaspike.data.impl.builder.part.BasePropertyQueryPart;
import org.apache.deltaspike.data.impl.builder.part.QueryPart;
import org.apache.deltaspike.data.impl.meta.RepositoryComponent;
import org.apache.deltaspike.data.impl.util.QueryUtils;

public class OrderByQueryPart
extends BasePropertyQueryPart {
    private static final String KEYWORD_ASC = "Asc";
    private static final String KEYWORD_DESC = "Desc";
    private final List<OrderByQueryAttribute> attributes = new LinkedList<OrderByQueryAttribute>();

    @Override
    protected QueryPart build(String queryPart, String method, RepositoryComponent repo) {
        TreeSet<String> collect = new TreeSet<String>();
        LinkedList<String> ascSplit = new LinkedList<String>();
        this.split(queryPart, KEYWORD_ASC, ascSplit);
        for (String ascPart : ascSplit) {
            this.split(ascPart, KEYWORD_DESC, collect);
        }
        for (String part : collect) {
            Direction direction = Direction.fromQueryPart(part);
            String attribute = direction.attribute(part);
            this.validate(attribute, method, repo);
            this.attributes.add(new OrderByQueryAttribute(attribute, direction));
        }
        return this;
    }

    @Override
    protected QueryPart buildQuery(QueryBuilderContext ctx) {
        ctx.append(" order by ");
        Iterator<OrderByQueryAttribute> it = this.attributes.iterator();
        while (it.hasNext()) {
            it.next().buildQuery(ctx);
            if (!it.hasNext()) continue;
            ctx.append(", ");
        }
        return this;
    }

    private void split(String queryPart, String keyword, Collection<String> result) {
        for (String part : QueryUtils.splitByKeyword(queryPart, keyword)) {
            String attribute = !part.endsWith(KEYWORD_DESC) && !part.endsWith(KEYWORD_ASC) ? part + keyword : part;
            result.add(attribute);
        }
    }

    private static enum Direction {
        ASC("Asc"),
        DESC("Desc"),
        DEFAULT("");

        private final String postfix;

        private Direction(String postfix) {
            this.postfix = postfix;
        }

        public boolean endsWith(String queryPart) {
            return QueryUtils.isNotEmpty(this.postfix) ? queryPart.endsWith(this.postfix) : false;
        }

        public String attribute(String queryPart) {
            String attribute = QueryUtils.isNotEmpty(this.postfix) ? queryPart.substring(0, queryPart.indexOf(this.postfix)) : queryPart;
            return QueryUtils.uncapitalize(attribute);
        }

        public String queryDirection() {
            return QueryUtils.isNotEmpty(this.postfix) ? " " + this.postfix.toLowerCase() : "";
        }

        public static Direction fromQueryPart(String queryPart) {
            for (Direction dir : Direction.values()) {
                if (!dir.endsWith(queryPart)) continue;
                return dir;
            }
            return DEFAULT;
        }
    }

    private class OrderByQueryAttribute {
        private final String attribute;
        private final Direction direction;

        public OrderByQueryAttribute(String attribute, Direction direction) {
            this.attribute = attribute;
            this.direction = direction;
        }

        protected void buildQuery(QueryBuilderContext ctx) {
            String entityPrefix = "e.";
            ctx.append(entityPrefix).append(OrderByQueryPart.this.rewriteSeparator(this.attribute)).append(this.direction.queryDirection());
        }
    }
}

