/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.strings;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.charset.StandardCharsets;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.tuple.UpdatableSummary;
import org.apache.datasketches.tuple.Util;

public final class ArrayOfStringsSummary
implements UpdatableSummary<String[]> {
    private String[] stringArr = null;

    ArrayOfStringsSummary() {
        this.stringArr = null;
    }

    ArrayOfStringsSummary(String[] stringArr) {
        this.stringArr = (String[])stringArr.clone();
        ArrayOfStringsSummary.checkNumNodes(stringArr.length);
    }

    ArrayOfStringsSummary(MemorySegment seg) {
        int pos = 0;
        int totBytes = seg.get(ValueLayout.JAVA_INT_UNALIGNED, (long)pos);
        ArrayOfStringsSummary.checkInBytes(seg, totBytes);
        int nodes = seg.get(ValueLayout.JAVA_BYTE, (long)(pos += 4));
        ++pos;
        ArrayOfStringsSummary.checkNumNodes(nodes);
        String[] stringArr = new String[nodes];
        for (int i = 0; i < nodes; ++i) {
            int len = seg.get(ValueLayout.JAVA_INT_UNALIGNED, (long)pos);
            byte[] byteArr = new byte[len];
            MemorySegment.copy(seg, ValueLayout.JAVA_BYTE, pos += 4, byteArr, 0, len);
            pos += len;
            stringArr[i] = new String(byteArr, StandardCharsets.UTF_8);
        }
        assert (pos == totBytes);
        this.stringArr = stringArr;
    }

    @Override
    public ArrayOfStringsSummary copy() {
        ArrayOfStringsSummary nodes = new ArrayOfStringsSummary(this.stringArr);
        return nodes;
    }

    @Override
    public byte[] toByteArray() {
        ComputeBytes cb = new ComputeBytes(this.stringArr);
        int totBytes = cb.totBytes_;
        byte[] out = new byte[totBytes];
        MemorySegment wseg = MemorySegment.ofArray(out);
        int pos = 0;
        wseg.set(ValueLayout.JAVA_INT_UNALIGNED, (long)pos, totBytes);
        int numNodes = cb.numNodes_;
        wseg.set(ValueLayout.JAVA_BYTE, (long)(pos += 4), (byte)numNodes);
        ++pos;
        for (int i = 0; i < numNodes; ++i) {
            int nodeLen = cb.nodeLengthsArr_[i];
            wseg.set(ValueLayout.JAVA_INT_UNALIGNED, (long)pos, nodeLen);
            MemorySegment.copy(cb.nodeBytesArr_[i], 0, wseg, ValueLayout.JAVA_BYTE, (long)(pos += 4), nodeLen);
            pos += nodeLen;
        }
        assert (pos == totBytes);
        return out;
    }

    public ArrayOfStringsSummary update(String[] value) {
        if (this.stringArr == null) {
            this.stringArr = (String[])value.clone();
        }
        return this;
    }

    public int hashCode() {
        return (int)Util.stringArrHash(this.stringArr);
    }

    public boolean equals(Object summary) {
        if (summary == null || !(summary instanceof ArrayOfStringsSummary)) {
            return false;
        }
        String thatStr = Util.stringConcat(((ArrayOfStringsSummary)summary).stringArr);
        String thisStr = Util.stringConcat(this.stringArr);
        return thisStr.equals(thatStr);
    }

    public String[] getValue() {
        return (String[])this.stringArr.clone();
    }

    static void checkNumNodes(int numNodes) {
        if (numNodes > 127 || numNodes < 0) {
            throw new SketchesArgumentException("Number of nodes cannot exceed 127 or be negative.");
        }
    }

    static void checkInBytes(MemorySegment seg, int totBytes) {
        if (seg.byteSize() < (long)totBytes) {
            throw new SketchesArgumentException("Incoming MemorySegment has insufficient capacity.");
        }
    }

    private static class ComputeBytes {
        final byte numNodes_;
        final int[] nodeLengthsArr_;
        final byte[][] nodeBytesArr_;
        final int totBytes_;

        ComputeBytes(String[] stringArr) {
            this.numNodes_ = (byte)stringArr.length;
            ArrayOfStringsSummary.checkNumNodes(this.numNodes_);
            this.nodeLengthsArr_ = new int[this.numNodes_];
            this.nodeBytesArr_ = new byte[this.numNodes_][];
            int sumNodeBytes = 0;
            for (int i = 0; i < this.numNodes_; ++i) {
                this.nodeBytesArr_[i] = stringArr[i].getBytes(StandardCharsets.UTF_8);
                this.nodeLengthsArr_[i] = this.nodeBytesArr_[i].length;
                sumNodeBytes += this.nodeLengthsArr_[i];
            }
            this.totBytes_ = sumNodeBytes + (this.numNodes_ + 1) * 4 + 1;
        }
    }
}

