/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.cpc;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Objects;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.cpc.CpcUtil;
import org.apache.datasketches.cpc.Flavor;
import org.apache.datasketches.cpc.Format;
import org.apache.datasketches.cpc.RuntimeAsserts;

final class PreambleUtil {
    private static final String fmt = "%10d%10x";
    static final byte SER_VER = 1;
    static final int RESERVED_FLAG_MASK = 1;
    static final int COMPRESSED_FLAG_MASK = 2;
    static final int HIP_FLAG_MASK = 4;
    static final int SUP_VAL_FLAG_MASK = 8;
    static final int WINDOW_FLAG_MASK = 16;
    private static final byte[] preIntDefs = new byte[]{2, 2, 4, 8, 4, 8, 6, 10};
    private static final byte[][] hiFieldOffset = new byte[][]{{0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0}, {8, 0, 0, 0, 12, 0, 16, 0}, {8, 0, 16, 24, 12, 0, 32, 0}, {8, 0, 0, 0, 0, 12, 0, 16}, {8, 0, 16, 24, 0, 12, 0, 32}, {8, 12, 0, 0, 16, 20, 24, 24}, {8, 12, 16, 24, 32, 36, 40, 40}};

    private PreambleUtil() {
    }

    static byte getDefinedPreInts(Format format) {
        return preIntDefs[format.ordinal()];
    }

    static int getLoFieldOffset(LoField loField) {
        return loField.ordinal();
    }

    static int getPreInts(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, (long)PreambleUtil.getLoFieldOffset(LoField.PRE_INTS)) & 0xFF;
    }

    static int getSerVer(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, (long)PreambleUtil.getLoFieldOffset(LoField.SER_VERSION)) & 0xFF;
    }

    static Family getFamily(MemorySegment seg) {
        int fam = seg.get(ValueLayout.JAVA_BYTE, (long)PreambleUtil.getLoFieldOffset(LoField.FAMILY)) & 0xFF;
        return Family.idToFamily(fam);
    }

    static int getLgK(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, (long)PreambleUtil.getLoFieldOffset(LoField.LG_K)) & 0xFF;
    }

    static int getFiCol(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, (long)PreambleUtil.getLoFieldOffset(LoField.FI_COL)) & 0xFF;
    }

    static int getFlags(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, (long)PreambleUtil.getLoFieldOffset(LoField.FLAGS)) & 0xFF;
    }

    static short getSeedHash(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_SHORT_UNALIGNED, (long)PreambleUtil.getLoFieldOffset(LoField.SEED_HASH));
    }

    static int getFormatOrdinal(MemorySegment seg) {
        int flags = PreambleUtil.getFlags(seg);
        return flags >>> 2 & 7;
    }

    static Format getFormat(MemorySegment seg) {
        int ordinal = PreambleUtil.getFormatOrdinal(seg);
        return Format.ordinalToFormat(ordinal);
    }

    static boolean hasHip(MemorySegment seg) {
        return (PreambleUtil.getFlags(seg) & 4) > 0;
    }

    static boolean hasSv(MemorySegment seg) {
        return (PreambleUtil.getFlags(seg) & 8) > 0;
    }

    static boolean hasWindow(MemorySegment seg) {
        return (PreambleUtil.getFlags(seg) & 0x10) > 0;
    }

    static boolean isCompressed(MemorySegment seg) {
        return (PreambleUtil.getFlags(seg) & 2) > 0;
    }

    static long getHiFieldOffset(Format format, HiField hiField) {
        int hiFieldIdx;
        int formatIdx = format.ordinal();
        long fieldOffset = hiFieldOffset[formatIdx][hiFieldIdx = hiField.ordinal()] & 0xFF;
        if (fieldOffset == 0L) {
            throw new SketchesStateException("Undefined preamble field given the Format: Format: " + format.toString() + ", HiField: " + hiField.toString());
        }
        return fieldOffset;
    }

    static int getNumCoupons(MemorySegment seg) {
        Format format = PreambleUtil.getFormat(seg);
        HiField hiField = HiField.NUM_COUPONS;
        long offset = PreambleUtil.getHiFieldOffset(format, hiField);
        return seg.get(ValueLayout.JAVA_INT_UNALIGNED, offset);
    }

    static int getNumSv(MemorySegment seg) {
        Format format = PreambleUtil.getFormat(seg);
        HiField hiField = HiField.NUM_SV;
        long offset = PreambleUtil.getHiFieldOffset(format, hiField);
        return seg.get(ValueLayout.JAVA_INT_UNALIGNED, offset);
    }

    static int getSvLengthInts(MemorySegment seg) {
        Format format = PreambleUtil.getFormat(seg);
        HiField hiField = HiField.SV_LENGTH_INTS;
        long offset = PreambleUtil.getHiFieldOffset(format, hiField);
        return seg.get(ValueLayout.JAVA_INT_UNALIGNED, offset);
    }

    static int getWLengthInts(MemorySegment seg) {
        Format format = PreambleUtil.getFormat(seg);
        HiField hiField = HiField.W_LENGTH_INTS;
        long offset = PreambleUtil.getHiFieldOffset(format, hiField);
        return seg.get(ValueLayout.JAVA_INT_UNALIGNED, offset);
    }

    static double getKxP(MemorySegment seg) {
        Format format = PreambleUtil.getFormat(seg);
        HiField hiField = HiField.KXP;
        long offset = PreambleUtil.getHiFieldOffset(format, hiField);
        return seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, offset);
    }

    static double getHipAccum(MemorySegment seg) {
        Format format = PreambleUtil.getFormat(seg);
        HiField hiField = HiField.HIP_ACCUM;
        long offset = PreambleUtil.getHiFieldOffset(format, hiField);
        return seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, offset);
    }

    static long getSvStreamOffset(MemorySegment seg) {
        Format format = PreambleUtil.getFormat(seg);
        HiField svLenField = HiField.SV_LENGTH_INTS;
        if (!PreambleUtil.hasSv(seg)) {
            PreambleUtil.fieldError(format, svLenField);
        } else {
            long svLengthInts = (long)seg.get(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.SV_LENGTH_INTS)) & 0xFFFFFFFFL;
            if (svLengthInts == 0L) {
                throw new SketchesStateException("svLengthInts cannot be zero");
            }
        }
        long wLengthInts = 0L;
        if (PreambleUtil.hasWindow(seg) && (wLengthInts = (long)seg.get(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.W_LENGTH_INTS)) & 0xFFFFFFFFL) == 0L) {
            throw new SketchesStateException("wLengthInts cannot be zero");
        }
        return (long)PreambleUtil.getPreInts(seg) + wLengthInts << 2;
    }

    static long getWStreamOffset(MemorySegment seg) {
        long wLengthInts;
        Format format = PreambleUtil.getFormat(seg);
        HiField wLenField = HiField.W_LENGTH_INTS;
        if (!PreambleUtil.hasWindow(seg)) {
            PreambleUtil.fieldError(format, wLenField);
        }
        if ((wLengthInts = (long)seg.get(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.W_LENGTH_INTS)) & 0xFFFFFFFFL) == 0L) {
            throw new SketchesStateException("wLengthInts cannot be zero");
        }
        return PreambleUtil.getPreInts(seg) << 2;
    }

    static int[] getSvStream(MemorySegment seg) {
        long offset = PreambleUtil.getSvStreamOffset(seg);
        int svLengthInts = PreambleUtil.getSvLengthInts(seg);
        int[] svStream = new int[svLengthInts];
        MemorySegment.copy(seg, ValueLayout.JAVA_INT_UNALIGNED, offset, svStream, 0, svLengthInts);
        return svStream;
    }

    static int[] getWStream(MemorySegment seg) {
        long offset = PreambleUtil.getWStreamOffset(seg);
        int wLength = PreambleUtil.getWLengthInts(seg);
        int[] wStream = new int[wLength];
        MemorySegment.copy(seg, ValueLayout.JAVA_INT_UNALIGNED, offset, wStream, 0, wLength);
        return wStream;
    }

    static void putEmptyMerged(MemorySegment wseg, int lgK, short seedHash) {
        Format format = Format.EMPTY_MERGED;
        byte preInts = PreambleUtil.getDefinedPreInts(format);
        boolean fiCol = false;
        byte flags = (byte)(format.ordinal() << 2 | 2);
        PreambleUtil.checkCapacity(wseg.byteSize(), 8L);
        PreambleUtil.putFirst8(wseg, preInts, (byte)lgK, (byte)0, flags, seedHash);
    }

    static void putEmptyHip(MemorySegment wseg, int lgK, short seedHash) {
        Format format = Format.EMPTY_HIP;
        byte preInts = PreambleUtil.getDefinedPreInts(format);
        boolean fiCol = false;
        byte flags = (byte)(format.ordinal() << 2 | 2);
        PreambleUtil.checkCapacity(wseg.byteSize(), 8L);
        PreambleUtil.putFirst8(wseg, preInts, (byte)lgK, (byte)0, flags, seedHash);
    }

    static void putSparseHybridMerged(MemorySegment wseg, int lgK, int numCoupons, int svLengthInts, short seedHash, int[] svStream) {
        Format format = Format.SPARSE_HYBRID_MERGED;
        byte preInts = PreambleUtil.getDefinedPreInts(format);
        boolean fiCol = false;
        byte flags = (byte)(format.ordinal() << 2 | 2);
        PreambleUtil.checkCapacity(wseg.byteSize(), 4L * (long)(preInts + svLengthInts));
        PreambleUtil.putFirst8(wseg, preInts, (byte)lgK, (byte)0, flags, seedHash);
        wseg.set(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.NUM_COUPONS), numCoupons);
        wseg.set(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.SV_LENGTH_INTS), svLengthInts);
        MemorySegment.copy(svStream, 0, wseg, ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getSvStreamOffset(wseg), svLengthInts);
    }

    static void putSparseHybridHip(MemorySegment wseg, int lgK, int numCoupons, int svLengthInts, double kxp, double hipAccum, short seedHash, int[] svStream) {
        Format format = Format.SPARSE_HYBRID_HIP;
        byte preInts = PreambleUtil.getDefinedPreInts(format);
        boolean fiCol = false;
        byte flags = (byte)(format.ordinal() << 2 | 2);
        PreambleUtil.checkCapacity(wseg.byteSize(), 4L * (long)(preInts + svLengthInts));
        PreambleUtil.putFirst8(wseg, preInts, (byte)lgK, (byte)0, flags, seedHash);
        wseg.set(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.NUM_COUPONS), numCoupons);
        wseg.set(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.SV_LENGTH_INTS), svLengthInts);
        wseg.set(ValueLayout.JAVA_DOUBLE_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.KXP), kxp);
        wseg.set(ValueLayout.JAVA_DOUBLE_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.HIP_ACCUM), hipAccum);
        MemorySegment.copy(svStream, 0, wseg, ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getSvStreamOffset(wseg), svLengthInts);
    }

    static void putPinnedSlidingMergedNoSv(MemorySegment wseg, int lgK, int fiCol, int numCoupons, int wLengthInts, short seedHash, int[] wStream) {
        Format format = Format.PINNED_SLIDING_MERGED_NOSV;
        byte preInts = PreambleUtil.getDefinedPreInts(format);
        byte flags = (byte)(format.ordinal() << 2 | 2);
        PreambleUtil.checkCapacity(wseg.byteSize(), 4L * (long)(preInts + wLengthInts));
        PreambleUtil.putFirst8(wseg, preInts, (byte)lgK, (byte)fiCol, flags, seedHash);
        wseg.set(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.NUM_COUPONS), numCoupons);
        wseg.set(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.W_LENGTH_INTS), wLengthInts);
        MemorySegment.copy(wStream, 0, wseg, ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getWStreamOffset(wseg), wLengthInts);
    }

    static void putPinnedSlidingHipNoSv(MemorySegment wseg, int lgK, int fiCol, int numCoupons, int wLengthInts, double kxp, double hipAccum, short seedHash, int[] wStream) {
        Format format = Format.PINNED_SLIDING_HIP_NOSV;
        byte preInts = PreambleUtil.getDefinedPreInts(format);
        byte flags = (byte)(format.ordinal() << 2 | 2);
        PreambleUtil.checkCapacity(wseg.byteSize(), 4L * (long)(preInts + wLengthInts));
        PreambleUtil.putFirst8(wseg, preInts, (byte)lgK, (byte)fiCol, flags, seedHash);
        wseg.set(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.NUM_COUPONS), numCoupons);
        wseg.set(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.W_LENGTH_INTS), wLengthInts);
        wseg.set(ValueLayout.JAVA_DOUBLE_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.KXP), kxp);
        wseg.set(ValueLayout.JAVA_DOUBLE_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.HIP_ACCUM), hipAccum);
        MemorySegment.copy(wStream, 0, wseg, ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getWStreamOffset(wseg), wLengthInts);
    }

    static void putPinnedSlidingMerged(MemorySegment wseg, int lgK, int fiCol, int numCoupons, int numSv, int svLengthInts, int wLengthInts, short seedHash, int[] svStream, int[] wStream) {
        Format format = Format.PINNED_SLIDING_MERGED;
        byte preInts = PreambleUtil.getDefinedPreInts(format);
        byte flags = (byte)(format.ordinal() << 2 | 2);
        PreambleUtil.checkCapacity(wseg.byteSize(), 4L * (long)(preInts + svLengthInts + wLengthInts));
        PreambleUtil.putFirst8(wseg, preInts, (byte)lgK, (byte)fiCol, flags, seedHash);
        wseg.set(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.NUM_COUPONS), numCoupons);
        wseg.set(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.NUM_SV), numSv);
        wseg.set(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.SV_LENGTH_INTS), svLengthInts);
        wseg.set(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.W_LENGTH_INTS), wLengthInts);
        MemorySegment.copy(svStream, 0, wseg, ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getSvStreamOffset(wseg), svLengthInts);
        MemorySegment.copy(wStream, 0, wseg, ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getWStreamOffset(wseg), wLengthInts);
    }

    static void putPinnedSlidingHip(MemorySegment wseg, int lgK, int fiCol, int numCoupons, int numSv, double kxp, double hipAccum, int svLengthInts, int wLengthInts, short seedHash, int[] svStream, int[] wStream) {
        Format format = Format.PINNED_SLIDING_HIP;
        byte preInts = PreambleUtil.getDefinedPreInts(format);
        byte flags = (byte)(format.ordinal() << 2 | 2);
        PreambleUtil.checkCapacity(wseg.byteSize(), 4L * (long)(preInts + svLengthInts + wLengthInts));
        PreambleUtil.putFirst8(wseg, preInts, (byte)lgK, (byte)fiCol, flags, seedHash);
        wseg.set(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.NUM_COUPONS), numCoupons);
        wseg.set(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.NUM_SV), numSv);
        wseg.set(ValueLayout.JAVA_DOUBLE_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.KXP), kxp);
        wseg.set(ValueLayout.JAVA_DOUBLE_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.HIP_ACCUM), hipAccum);
        wseg.set(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.SV_LENGTH_INTS), svLengthInts);
        wseg.set(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.W_LENGTH_INTS), wLengthInts);
        MemorySegment.copy(svStream, 0, wseg, ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getSvStreamOffset(wseg), svLengthInts);
        MemorySegment.copy(wStream, 0, wseg, ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getWStreamOffset(wseg), wLengthInts);
    }

    private static void putFirst8(MemorySegment wseg, byte preInts, byte lgK, byte fiCol, byte flags, short seedHash) {
        Util.clear(wseg, 0L, 4L * (long)preInts);
        wseg.set(ValueLayout.JAVA_BYTE, (long)PreambleUtil.getLoFieldOffset(LoField.PRE_INTS), preInts);
        wseg.set(ValueLayout.JAVA_BYTE, (long)PreambleUtil.getLoFieldOffset(LoField.SER_VERSION), (byte)1);
        wseg.set(ValueLayout.JAVA_BYTE, (long)PreambleUtil.getLoFieldOffset(LoField.FAMILY), (byte)Family.CPC.getID());
        wseg.set(ValueLayout.JAVA_BYTE, (long)PreambleUtil.getLoFieldOffset(LoField.LG_K), lgK);
        wseg.set(ValueLayout.JAVA_BYTE, (long)PreambleUtil.getLoFieldOffset(LoField.FI_COL), fiCol);
        wseg.set(ValueLayout.JAVA_BYTE, (long)PreambleUtil.getLoFieldOffset(LoField.FLAGS), flags);
        wseg.set(ValueLayout.JAVA_SHORT_UNALIGNED, (long)PreambleUtil.getLoFieldOffset(LoField.SEED_HASH), seedHash);
    }

    static String toString(byte[] byteArr, boolean detail) {
        MemorySegment seg = MemorySegment.ofArray(byteArr);
        return PreambleUtil.toString(seg, detail);
    }

    static String toString(MemorySegment seg, boolean detail) {
        long capBytes = seg.byteSize();
        int preInts = seg.get(ValueLayout.JAVA_BYTE, (long)PreambleUtil.getLoFieldOffset(LoField.PRE_INTS)) & 0xFF;
        int serVer = seg.get(ValueLayout.JAVA_BYTE, (long)PreambleUtil.getLoFieldOffset(LoField.SER_VERSION)) & 0xFF;
        Family family = Family.idToFamily(seg.get(ValueLayout.JAVA_BYTE, (long)PreambleUtil.getLoFieldOffset(LoField.FAMILY)) & 0xFF);
        int lgK = seg.get(ValueLayout.JAVA_BYTE, (long)PreambleUtil.getLoFieldOffset(LoField.LG_K)) & 0xFF;
        int fiCol = seg.get(ValueLayout.JAVA_BYTE, (long)PreambleUtil.getLoFieldOffset(LoField.FI_COL)) & 0xFF;
        int flags = seg.get(ValueLayout.JAVA_BYTE, (long)PreambleUtil.getLoFieldOffset(LoField.FLAGS)) & 0xFF;
        int seedHash = seg.get(ValueLayout.JAVA_SHORT_UNALIGNED, (long)PreambleUtil.getLoFieldOffset(LoField.SEED_HASH)) & 0xFFFF;
        String seedHashStr = Integer.toHexString(seedHash);
        String flagsStr = Util.zeroPad(Integer.toBinaryString(flags), 8) + ", " + flags;
        boolean compressed = (flags & 2) > 0;
        boolean hasHip = (flags & 4) > 0;
        boolean hasSV = (flags & 8) > 0;
        boolean hasWindow = (flags & 0x10) > 0;
        int formatOrdinal = flags >>> 2 & 7;
        Format format = Format.ordinalToFormat(formatOrdinal);
        long numCoupons = 0L;
        long numSv = 0L;
        long winOffset = 0L;
        long svLengthInts = 0L;
        long wLengthInts = 0L;
        double kxp = 0.0;
        double hipAccum = 0.0;
        long svStreamStart = 0L;
        long wStreamStart = 0L;
        long reqBytes = 0L;
        StringBuilder sb = new StringBuilder();
        sb.append(Util.LS);
        sb.append("### CPC SKETCH IMAGE - PREAMBLE:").append(Util.LS);
        sb.append("Format                          : ").append(format.name()).append(Util.LS);
        sb.append("Byte 0: Preamble Ints           : ").append(preInts).append(Util.LS);
        sb.append("Byte 1: SerVer                  : ").append(serVer).append(Util.LS);
        sb.append("Byte 2: Family                  : ").append((Object)family).append(Util.LS);
        sb.append("Byte 3: lgK                     : ").append(lgK).append(Util.LS);
        sb.append("Byte 4: First Interesting Col   : ").append(fiCol).append(Util.LS);
        sb.append("Byte 5: Flags                   : ").append(flagsStr).append(Util.LS);
        sb.append("  Compressed                    : ").append(compressed).append(Util.LS);
        sb.append("  Has HIP                       : ").append(hasHip).append(Util.LS);
        sb.append("  Has Surprising Values         : ").append(hasSV).append(Util.LS);
        sb.append("  Has Window Values             : ").append(hasWindow).append(Util.LS);
        sb.append("Byte 6, 7: Seed Hash            : ").append(seedHashStr).append(Util.LS);
        switch (format) {
            case EMPTY_MERGED: 
            case EMPTY_HIP: {
                Flavor flavor = CpcUtil.determineFlavor(lgK, numCoupons);
                sb.append("Flavor                          : ").append((Object)flavor).append(Util.LS);
                break;
            }
            case SPARSE_HYBRID_MERGED: {
                numSv = numCoupons = (long)seg.get(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.NUM_COUPONS)) & 0xFFFFFFFFL;
                svLengthInts = (long)seg.get(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.SV_LENGTH_INTS)) & 0xFFFFFFFFL;
                svStreamStart = PreambleUtil.getSvStreamOffset(seg);
                reqBytes = svStreamStart + (svLengthInts << 2);
                Flavor flavor = CpcUtil.determineFlavor(lgK, numCoupons);
                sb.append("Flavor                          : ").append((Object)flavor).append(Util.LS);
                sb.append("Num Coupons                     : ").append(numCoupons).append(Util.LS);
                sb.append("Num SV                          : ").append(numSv).append(Util.LS);
                sb.append("SV Length Ints                  : ").append(svLengthInts).append(Util.LS);
                sb.append("SV Stream Start                 : ").append(svStreamStart).append(Util.LS);
                break;
            }
            case SPARSE_HYBRID_HIP: {
                numSv = numCoupons = (long)seg.get(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.NUM_COUPONS)) & 0xFFFFFFFFL;
                svLengthInts = (long)seg.get(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.SV_LENGTH_INTS)) & 0xFFFFFFFFL;
                svStreamStart = PreambleUtil.getSvStreamOffset(seg);
                kxp = seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.KXP));
                hipAccum = seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.HIP_ACCUM));
                reqBytes = svStreamStart + (svLengthInts << 2);
                Flavor flavor = CpcUtil.determineFlavor(lgK, numCoupons);
                sb.append("Flavor                          : ").append((Object)flavor).append(Util.LS);
                sb.append("Num Coupons                     : ").append(numCoupons).append(Util.LS);
                sb.append("Num SV                          : ").append(numSv).append(Util.LS);
                sb.append("SV Length Ints                  : ").append(svLengthInts).append(Util.LS);
                sb.append("SV Stream Start                 : ").append(svStreamStart).append(Util.LS);
                sb.append("KxP                             : ").append(kxp).append(Util.LS);
                sb.append("HipAccum                        : ").append(hipAccum).append(Util.LS);
                break;
            }
            case PINNED_SLIDING_MERGED_NOSV: {
                numCoupons = (long)seg.get(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.NUM_COUPONS)) & 0xFFFFFFFFL;
                winOffset = CpcUtil.determineCorrectOffset(lgK, numCoupons);
                wLengthInts = (long)seg.get(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.W_LENGTH_INTS)) & 0xFFFFFFFFL;
                wStreamStart = PreambleUtil.getWStreamOffset(seg);
                reqBytes = wStreamStart + (wLengthInts << 2);
                Flavor flavor = CpcUtil.determineFlavor(lgK, numCoupons);
                sb.append("Flavor                          : ").append((Object)flavor).append(Util.LS);
                sb.append("Num Coupons                     : ").append(numCoupons).append(Util.LS);
                sb.append("Window Offset                   : ").append(winOffset).append(Util.LS);
                sb.append("Window Length Ints              : ").append(wLengthInts).append(Util.LS);
                sb.append("Window Stream Start             : ").append(wStreamStart).append(Util.LS);
                break;
            }
            case PINNED_SLIDING_HIP_NOSV: {
                numCoupons = (long)seg.get(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.NUM_COUPONS)) & 0xFFFFFFFFL;
                winOffset = CpcUtil.determineCorrectOffset(lgK, numCoupons);
                wLengthInts = (long)seg.get(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.W_LENGTH_INTS)) & 0xFFFFFFFFL;
                wStreamStart = PreambleUtil.getWStreamOffset(seg);
                kxp = seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.KXP));
                hipAccum = seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.HIP_ACCUM));
                reqBytes = wStreamStart + (wLengthInts << 2);
                Flavor flavor = CpcUtil.determineFlavor(lgK, numCoupons);
                sb.append("Flavor                          : ").append((Object)flavor).append(Util.LS);
                sb.append("Num Coupons                     : ").append(numCoupons).append(Util.LS);
                sb.append("Window Offset                   : ").append(winOffset).append(Util.LS);
                sb.append("Window Length Ints              : ").append(wLengthInts).append(Util.LS);
                sb.append("Window Stream Start             : ").append(wStreamStart).append(Util.LS);
                sb.append("KxP                             : ").append(kxp).append(Util.LS);
                sb.append("HipAccum                        : ").append(hipAccum).append(Util.LS);
                break;
            }
            case PINNED_SLIDING_MERGED: {
                numCoupons = seg.get(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.NUM_COUPONS) & 0xFFFFFFFFL);
                winOffset = CpcUtil.determineCorrectOffset(lgK, numCoupons);
                wLengthInts = (long)seg.get(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.W_LENGTH_INTS)) & 0xFFFFFFFFL;
                numSv = (long)seg.get(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.NUM_SV)) & 0xFFFFFFFFL;
                svLengthInts = (long)seg.get(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.SV_LENGTH_INTS)) & 0xFFFFFFFFL;
                wStreamStart = PreambleUtil.getWStreamOffset(seg);
                svStreamStart = PreambleUtil.getSvStreamOffset(seg);
                reqBytes = svStreamStart + (svLengthInts << 2);
                Flavor flavor = CpcUtil.determineFlavor(lgK, numCoupons);
                sb.append("Flavor                          : ").append((Object)flavor).append(Util.LS);
                sb.append("Num Coupons                     : ").append(numCoupons).append(Util.LS);
                sb.append("Num SV                          : ").append(numSv).append(Util.LS);
                sb.append("SV Length Ints                  : ").append(svLengthInts).append(Util.LS);
                sb.append("SV Stream Start                 : ").append(svStreamStart).append(Util.LS);
                sb.append("Window Offset                   : ").append(winOffset).append(Util.LS);
                sb.append("Window Length Ints              : ").append(wLengthInts).append(Util.LS);
                sb.append("Window Stream Start             : ").append(wStreamStart).append(Util.LS);
                break;
            }
            case PINNED_SLIDING_HIP: {
                numCoupons = seg.get(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.NUM_COUPONS) & 0xFFFFFFFFL);
                winOffset = CpcUtil.determineCorrectOffset(lgK, numCoupons);
                wLengthInts = (long)seg.get(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.W_LENGTH_INTS)) & 0xFFFFFFFFL;
                numSv = (long)seg.get(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.NUM_SV)) & 0xFFFFFFFFL;
                svLengthInts = (long)seg.get(ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.SV_LENGTH_INTS)) & 0xFFFFFFFFL;
                wStreamStart = PreambleUtil.getWStreamOffset(seg);
                svStreamStart = PreambleUtil.getSvStreamOffset(seg);
                kxp = seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.KXP));
                hipAccum = seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, PreambleUtil.getHiFieldOffset(format, HiField.HIP_ACCUM));
                reqBytes = svStreamStart + (svLengthInts << 2);
                Flavor flavor = CpcUtil.determineFlavor(lgK, numCoupons);
                sb.append("Flavor                          : ").append((Object)flavor).append(Util.LS);
                sb.append("Num Coupons                     : ").append(numCoupons).append(Util.LS);
                sb.append("Num SV                          : ").append(numSv).append(Util.LS);
                sb.append("SV Length Ints                  : ").append(svLengthInts).append(Util.LS);
                sb.append("SV Stream Start                 : ").append(svStreamStart).append(Util.LS);
                sb.append("Window Offset                   : ").append(winOffset).append(Util.LS);
                sb.append("Window Length Ints              : ").append(wLengthInts).append(Util.LS);
                sb.append("Window Stream Start             : ").append(wStreamStart).append(Util.LS);
                sb.append("KxP                             : ").append(kxp).append(Util.LS);
                sb.append("HipAccum                        : ").append(hipAccum).append(Util.LS);
            }
        }
        sb.append("Actual Bytes                    : ").append(capBytes).append(Util.LS);
        sb.append("Required Bytes                  : ").append(reqBytes).append(Util.LS);
        if (detail) {
            sb.append(Util.LS).append("### CPC SKETCH IMAGE - DATA").append(Util.LS);
            if (wLengthInts > 0L) {
                sb.append(Util.LS).append("Window Stream:").append(Util.LS);
                PreambleUtil.listData(seg, wStreamStart, wLengthInts, sb);
            }
            if (svLengthInts > 0L) {
                sb.append(Util.LS).append("SV Stream:").append(Util.LS);
                PreambleUtil.listData(seg, svStreamStart, svLengthInts, sb);
            }
        }
        sb.append("### END CPC SKETCH IMAGE").append(Util.LS);
        return sb.toString();
    }

    private static void listData(MemorySegment seg, long offsetBytes, long lengthInts, StringBuilder sb) {
        long segCap = seg.byteSize();
        long expectedCap = offsetBytes + 4L * lengthInts;
        PreambleUtil.checkCapacity(segCap, expectedCap);
        for (long i = 0L; i < lengthInts; ++i) {
            sb.append(String.format(fmt, i, seg.get(ValueLayout.JAVA_INT_UNALIGNED, offsetBytes + 4L * i))).append(Util.LS);
        }
    }

    static void fieldError(Format format, HiField hiField) {
        throw new SketchesArgumentException("Operation is illegal: Format = " + format.name() + ", HiField = " + String.valueOf((Object)hiField));
    }

    static void checkCapacity(long segCap, long expectedCap) {
        if (segCap < expectedCap) {
            throw new SketchesArgumentException("Insufficient Image Bytes = " + segCap + ", Expected = " + expectedCap);
        }
    }

    static void checkLoPreamble(MemorySegment seg) {
        Objects.requireNonNull(seg, "Source MemorySegment must not be null");
        Util.checkBounds(0L, 8L, seg.byteSize());
        RuntimeAsserts.rtAssertEquals(PreambleUtil.getSerVer(seg), 1L);
        Format fmat = PreambleUtil.getFormat(seg);
        int preIntsDef = PreambleUtil.getDefinedPreInts(fmat) & 0xFF;
        RuntimeAsserts.rtAssertEquals(PreambleUtil.getPreInts(seg), preIntsDef);
        Family fam = PreambleUtil.getFamily(seg);
        RuntimeAsserts.rtAssert(fam == Family.CPC);
        int lgK = PreambleUtil.getLgK(seg);
        RuntimeAsserts.rtAssert(lgK >= 4 && lgK <= 26);
        int fiCol = PreambleUtil.getFiCol(seg);
        RuntimeAsserts.rtAssert(fiCol <= 63 && fiCol >= 0);
    }

    static enum LoField {
        PRE_INTS,
        SER_VERSION,
        FAMILY,
        LG_K,
        FI_COL,
        FLAGS,
        SEED_HASH;

    }

    static enum HiField {
        NUM_COUPONS,
        NUM_SV,
        KXP,
        HIP_ACCUM,
        SV_LENGTH_INTS,
        W_LENGTH_INTS,
        SV_STREAM,
        W_STREAM;

    }
}

