/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.Objects;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllDirectCompactItemsSketch;
import org.apache.datasketches.kll.KllHeapItemsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllItemsHelper;
import org.apache.datasketches.kll.KllItemsSketchIterator;
import org.apache.datasketches.kll.KllItemsSketchSortedView;
import org.apache.datasketches.kll.KllMemoryValidate;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantilescommon.GenericPartitionBoundaries;
import org.apache.datasketches.quantilescommon.PartitioningFeature;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesGenericAPI;
import org.apache.datasketches.quantilescommon.QuantilesGenericSketchIterator;

public abstract class KllItemsSketch<T>
extends KllSketch
implements QuantilesGenericAPI<T>,
PartitioningFeature<T> {
    private KllItemsSketchSortedView<T> kllItemsSV = null;
    final Comparator<? super T> comparator;
    final ArrayOfItemsSerDe<T> serDe;

    KllItemsSketch(KllSketch.SketchStructure skStructure, Comparator<? super T> comparator, ArrayOfItemsSerDe<T> serDe) {
        super(KllSketch.SketchType.ITEMS_SKETCH, skStructure);
        Objects.requireNonNull(comparator, "Comparator must not be null.");
        Objects.requireNonNull(serDe, "SerDe must not be null.");
        this.comparator = comparator;
        this.serDe = serDe;
    }

    public static <T> KllItemsSketch<T> newHeapInstance(Comparator<? super T> comparator, ArrayOfItemsSerDe<T> serDe) {
        KllHeapItemsSketch<? super T> itmSk = new KllHeapItemsSketch<T>(200, 8, comparator, serDe);
        return itmSk;
    }

    public static <T> KllItemsSketch<T> newHeapInstance(int k, Comparator<? super T> comparator, ArrayOfItemsSerDe<T> serDe) {
        return new KllHeapItemsSketch<T>(k, 8, comparator, serDe);
    }

    public static <T> KllItemsSketch<T> heapify(Memory srcMem, Comparator<? super T> comparator, ArrayOfItemsSerDe<T> serDe) {
        return new KllHeapItemsSketch<T>(srcMem, comparator, serDe);
    }

    public static <T> KllItemsSketch<T> wrap(Memory srcMem, Comparator<? super T> comparator, ArrayOfItemsSerDe<T> serDe) {
        KllMemoryValidate memVal = new KllMemoryValidate(srcMem, KllSketch.SketchType.ITEMS_SKETCH, serDe);
        return new KllDirectCompactItemsSketch<T>(memVal, comparator, serDe);
    }

    @Override
    public double[] getCDF(T[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.kllItemsSV.getCDF(splitPoints, searchCrit);
    }

    @Override
    public GenericPartitionBoundaries<T> getPartitionBoundaries(int numEquallySized, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.kllItemsSV.getPartitionBoundaries(numEquallySized, searchCrit);
    }

    @Override
    public double[] getPMF(T[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.kllItemsSV.getPMF(splitPoints, searchCrit);
    }

    @Override
    public T getQuantile(double rank, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.kllItemsSV.getQuantile(rank, searchCrit);
    }

    @Override
    public T[] getQuantiles(double[] ranks, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        int len = ranks.length;
        Object[] quantiles = (Object[])Array.newInstance(this.getMinItem().getClass(), len);
        for (int i = 0; i < len; ++i) {
            quantiles[i] = this.kllItemsSV.getQuantile(ranks[i], searchCrit);
        }
        return quantiles;
    }

    @Override
    public T getQuantileLowerBound(double rank) {
        return this.getQuantile(Math.max(0.0, rank - KllHelper.getNormalizedRankError(this.getMinK(), false)));
    }

    @Override
    public T getQuantileUpperBound(double rank) {
        return this.getQuantile(Math.min(1.0, rank + KllHelper.getNormalizedRankError(this.getMinK(), false)));
    }

    @Override
    public double getRank(T quantile, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.kllItemsSV.getRank(quantile, searchCrit);
    }

    @Override
    public double getRankLowerBound(double rank) {
        return Math.max(0.0, rank - KllHelper.getNormalizedRankError(this.getMinK(), false));
    }

    @Override
    public double getRankUpperBound(double rank) {
        return Math.min(1.0, rank + KllHelper.getNormalizedRankError(this.getMinK(), false));
    }

    @Override
    public double[] getRanks(T[] quantiles, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        int len = quantiles.length;
        double[] ranks = new double[len];
        for (int i = 0; i < len; ++i) {
            ranks[i] = this.kllItemsSV.getRank(quantiles[i], searchCrit);
        }
        return ranks;
    }

    @Override
    public final KllItemsSketchSortedView<T> getSortedView() {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        return this.refreshSortedView();
    }

    @Override
    public QuantilesGenericSketchIterator<T> iterator() {
        return new KllItemsSketchIterator(this.getTotalItemsArray(), this.getLevelsArray(KllSketch.SketchStructure.UPDATABLE), this.getNumLevels());
    }

    @Override
    public final void merge(KllSketch other) {
        if (this.readOnly || this.sketchStructure != KllSketch.SketchStructure.UPDATABLE) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllItemsSketch othItmSk = (KllItemsSketch)other;
        if (othItmSk.isEmpty()) {
            return;
        }
        KllItemsHelper.mergeItemImpl(this, othItmSk, this.comparator);
        this.kllItemsSV = null;
    }

    @Override
    public void reset() {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int k = this.getK();
        this.setN(0L);
        this.setMinK(k);
        this.setNumLevels(1);
        this.setLevelZeroSorted(false);
        this.setLevelsArray(new int[]{k, k});
        this.setMinItem(null);
        this.setMaxItem(null);
        this.setItemsArray(new Object[k]);
        this.kllItemsSV = null;
    }

    public byte[] toByteArray() {
        return KllHelper.toByteArray(this, false);
    }

    @Override
    public String toString(boolean withSummary, boolean withData) {
        KllItemsSketch<T> sketch = this;
        if (withData && this.sketchStructure != KllSketch.SketchStructure.UPDATABLE) {
            WritableMemory mem = this.getWritableMemory();
            assert (mem != null);
            sketch = KllItemsSketch.heapify((Memory)this.getWritableMemory(), this.comparator, this.serDe);
        }
        return KllHelper.toStringImpl(sketch, withSummary, withData, this.getSerDe());
    }

    @Override
    public void update(T item) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllItemsHelper.updateItem(this, item, this.comparator);
        this.kllItemsSV = null;
    }

    @Override
    MemoryRequestServer getMemoryRequestServer() {
        return null;
    }

    @Override
    abstract byte[] getMinMaxByteArr();

    @Override
    abstract int getMinMaxSizeBytes();

    private final KllItemsSketchSortedView<T> refreshSortedView() {
        KllItemsSketchSortedView<T> sv = this.kllItemsSV == null ? (this.kllItemsSV = new KllItemsSketchSortedView(this)) : this.kllItemsSV;
        return sv;
    }

    abstract T[] getRetainedItemsArray();

    @Override
    abstract byte[] getRetainedItemsByteArr();

    @Override
    abstract int getRetainedItemsSizeBytes();

    ArrayOfItemsSerDe<T> getSerDe() {
        return this.serDe;
    }

    abstract T getSingleItem();

    @Override
    abstract byte[] getSingleItemByteArr();

    @Override
    abstract int getSingleItemSizeBytes();

    abstract T[] getTotalItemsArray();

    @Override
    byte[] getTotalItemsByteArr() {
        throw new SketchesArgumentException("Unsupported operation for this Sketch Type. ");
    }

    @Override
    int getTotalItemsNumBytes() {
        throw new SketchesArgumentException("Unsupported operation for this Sketch Type. ");
    }

    @Override
    void incNumLevels() {
    }

    abstract void setItemsArray(Object[] var1);

    abstract void setItemsArrayAt(int var1, Object var2);

    abstract void setMaxItem(Object var1);

    abstract void setMinItem(Object var1);

    @Override
    void setNumLevels(int numLevels) {
    }

    @Override
    void setWritableMemory(WritableMemory wmem) {
        throw new SketchesArgumentException("Unsupported operation for this Sketch Type. Sketch not writable.");
    }
}

