/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.util.Arrays;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllFloatsSketchSortedViewIterator;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.quantilescommon.FloatsSortedView;
import org.apache.datasketches.quantilescommon.InequalitySearch;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesUtil;

public final class KllFloatsSketchSortedView
implements FloatsSortedView {
    private final float[] quantiles;
    private final long[] cumWeights;
    private final long totalN;

    KllFloatsSketchSortedView(float[] quantiles, long[] cumWeights, long totalN) {
        this.quantiles = quantiles;
        this.cumWeights = cumWeights;
        this.totalN = totalN;
    }

    public KllFloatsSketchSortedView(KllFloatsSketch sk) {
        this.totalN = sk.getN();
        float[] srcQuantiles = sk.getFloatItemsArray();
        int[] srcLevels = sk.levelsArr;
        int srcNumLevels = sk.getNumLevels();
        if (!sk.isLevelZeroSorted()) {
            Arrays.sort(srcQuantiles, srcLevels[0], srcLevels[1]);
            if (!sk.hasMemory()) {
                sk.setLevelZeroSorted(true);
            }
        }
        int numQuantiles = srcLevels[srcNumLevels] - srcLevels[0];
        this.quantiles = new float[numQuantiles];
        this.cumWeights = new long[numQuantiles];
        this.populateFromSketch(srcQuantiles, srcLevels, srcNumLevels, numQuantiles);
    }

    @Override
    public long[] getCumulativeWeights() {
        return (long[])this.cumWeights.clone();
    }

    @Override
    public float getQuantile(double rank, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        QuantilesUtil.checkNormalizedRankBounds(rank);
        int len = this.cumWeights.length;
        long naturalRank = searchCrit == QuantileSearchCriteria.INCLUSIVE ? (long)Math.ceil(rank * (double)this.totalN) : (long)Math.floor(rank * (double)this.totalN);
        InequalitySearch crit = searchCrit == QuantileSearchCriteria.INCLUSIVE ? InequalitySearch.GE : InequalitySearch.GT;
        int index = InequalitySearch.find(this.cumWeights, 0, len - 1, naturalRank, crit);
        if (index == -1) {
            return this.quantiles[this.quantiles.length - 1];
        }
        return this.quantiles[index];
    }

    @Override
    public float[] getQuantiles() {
        return (float[])this.quantiles.clone();
    }

    @Override
    public double getRank(float quantile, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        int len = this.quantiles.length;
        InequalitySearch crit = searchCrit == QuantileSearchCriteria.INCLUSIVE ? InequalitySearch.LE : InequalitySearch.LT;
        int index = InequalitySearch.find(this.quantiles, 0, len - 1, quantile, crit);
        if (index == -1) {
            return 0.0;
        }
        return (double)this.cumWeights[index] / (double)this.totalN;
    }

    @Override
    public boolean isEmpty() {
        return this.totalN == 0L;
    }

    @Override
    public KllFloatsSketchSortedViewIterator iterator() {
        return new KllFloatsSketchSortedViewIterator(this.quantiles, this.cumWeights);
    }

    private void populateFromSketch(float[] srcQuantiles, int[] srcLevels, int srcNumLevels, int numItems) {
        int[] myLevels = new int[srcNumLevels + 1];
        int offset = srcLevels[0];
        System.arraycopy(srcQuantiles, offset, this.quantiles, 0, numItems);
        int srcLevel = 0;
        int dstLevel = 0;
        long weight = 1L;
        while (srcLevel < srcNumLevels) {
            int fromIndex = srcLevels[srcLevel] - offset;
            int toIndex = srcLevels[srcLevel + 1] - offset;
            if (fromIndex < toIndex) {
                Arrays.fill(this.cumWeights, fromIndex, toIndex, weight);
                myLevels[dstLevel] = fromIndex;
                myLevels[dstLevel + 1] = toIndex;
                ++dstLevel;
            }
            ++srcLevel;
            weight *= 2L;
        }
        int numLevels = dstLevel;
        KllFloatsSketchSortedView.blockyTandemMergeSort(this.quantiles, this.cumWeights, myLevels, numLevels);
        KllHelper.convertToCumulative(this.cumWeights);
    }

    private static void blockyTandemMergeSort(float[] quantiles, long[] weights, int[] levels, int numLevels) {
        if (numLevels == 1) {
            return;
        }
        float[] quantilesTmp = Arrays.copyOf(quantiles, quantiles.length);
        long[] weightsTmp = Arrays.copyOf(weights, quantiles.length);
        KllFloatsSketchSortedView.blockyTandemMergeSortRecursion(quantilesTmp, weightsTmp, quantiles, weights, levels, 0, numLevels);
    }

    private static void blockyTandemMergeSortRecursion(float[] quantilesSrc, long[] weightsSrc, float[] quantilesDst, long[] weightsDst, int[] levels, int startingLevel, int numLevels) {
        if (numLevels == 1) {
            return;
        }
        int numLevels1 = numLevels / 2;
        int numLevels2 = numLevels - numLevels1;
        assert (numLevels1 >= 1);
        assert (numLevels2 >= numLevels1);
        int startingLevel1 = startingLevel;
        int startingLevel2 = startingLevel + numLevels1;
        KllFloatsSketchSortedView.blockyTandemMergeSortRecursion(quantilesDst, weightsDst, quantilesSrc, weightsSrc, levels, startingLevel1, numLevels1);
        KllFloatsSketchSortedView.blockyTandemMergeSortRecursion(quantilesDst, weightsDst, quantilesSrc, weightsSrc, levels, startingLevel2, numLevels2);
        KllFloatsSketchSortedView.tandemMerge(quantilesSrc, weightsSrc, quantilesDst, weightsDst, levels, startingLevel1, numLevels1, startingLevel2, numLevels2);
    }

    private static void tandemMerge(float[] quantilesSrc, long[] weightsSrc, float[] quantilesDst, long[] weightsDst, int[] levelStarts, int startingLevel1, int numLevels1, int startingLevel2, int numLevels2) {
        int fromIndex1 = levelStarts[startingLevel1];
        int toIndex1 = levelStarts[startingLevel1 + numLevels1];
        int fromIndex2 = levelStarts[startingLevel2];
        int toIndex2 = levelStarts[startingLevel2 + numLevels2];
        int iSrc1 = fromIndex1;
        int iSrc2 = fromIndex2;
        int iDst = fromIndex1;
        while (iSrc1 < toIndex1 && iSrc2 < toIndex2) {
            if (quantilesSrc[iSrc1] < quantilesSrc[iSrc2]) {
                quantilesDst[iDst] = quantilesSrc[iSrc1];
                weightsDst[iDst] = weightsSrc[iSrc1];
                ++iSrc1;
            } else {
                quantilesDst[iDst] = quantilesSrc[iSrc2];
                weightsDst[iDst] = weightsSrc[iSrc2];
                ++iSrc2;
            }
            ++iDst;
        }
        if (iSrc1 < toIndex1) {
            System.arraycopy(quantilesSrc, iSrc1, quantilesDst, iDst, toIndex1 - iSrc1);
            System.arraycopy(weightsSrc, iSrc1, weightsDst, iDst, toIndex1 - iSrc1);
        } else if (iSrc2 < toIndex2) {
            System.arraycopy(quantilesSrc, iSrc2, quantilesDst, iDst, toIndex2 - iSrc2);
            System.arraycopy(weightsSrc, iSrc2, weightsDst, iDst, toIndex2 - iSrc2);
        }
    }
}

