/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.util.Objects;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllMemoryValidate;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;

final class KllHeapDoublesSketch
extends KllDoublesSketch {
    private final int k_;
    private final int m_;
    private long n_;
    private int minK_;
    private boolean isLevelZeroSorted_;
    private double minItem_;
    private double maxItem_;
    private double[] quantiles_;

    KllHeapDoublesSketch(int k, int m) {
        super(null, null);
        KllHelper.checkM(m);
        KllHelper.checkK(k, m);
        this.k_ = k;
        this.m_ = m;
        this.n_ = 0L;
        this.minK_ = k;
        this.isLevelZeroSorted_ = false;
        this.levelsArr = new int[]{k, k};
        this.minItem_ = Double.NaN;
        this.maxItem_ = Double.NaN;
        this.quantiles_ = new double[k];
    }

    private KllHeapDoublesSketch(Memory srcMem, KllMemoryValidate memValidate) {
        super(null, null);
        this.k_ = memValidate.k;
        this.m_ = memValidate.m;
        this.n_ = memValidate.n;
        this.minK_ = memValidate.minK;
        this.levelsArr = memValidate.levelsArr;
        this.isLevelZeroSorted_ = memValidate.level0Sorted;
        boolean updatableMemFormat = memValidate.updatableMemFormat;
        if (memValidate.empty && !updatableMemFormat) {
            this.minItem_ = Double.NaN;
            this.maxItem_ = Double.NaN;
            this.quantiles_ = new double[this.k_];
        } else if (memValidate.singleItem && !updatableMemFormat) {
            double item;
            this.minItem_ = this.maxItem_ = (item = srcMem.getDouble(8L));
            this.quantiles_ = new double[this.k_];
            this.quantiles_[this.k_ - 1] = item;
        } else {
            int offsetBytes = 20;
            this.minItem_ = srcMem.getDouble((long)(offsetBytes += updatableMemFormat ? this.levelsArr.length * 4 : (this.levelsArr.length - 1) * 4));
            this.maxItem_ = srcMem.getDouble((long)(offsetBytes += 8));
            offsetBytes += 8;
            int capacityItems = this.levelsArr[this.getNumLevels()];
            int retainedItems = capacityItems - this.levelsArr[0];
            this.quantiles_ = new double[capacityItems];
            int shift = this.levelsArr[0];
            if (updatableMemFormat) {
                srcMem.getDoubleArray((long)(offsetBytes += shift * 8), this.quantiles_, shift, retainedItems);
            } else {
                srcMem.getDoubleArray((long)offsetBytes, this.quantiles_, shift, retainedItems);
            }
        }
    }

    static KllHeapDoublesSketch heapifyImpl(Memory srcMem) {
        Objects.requireNonNull(srcMem, "Parameter 'srcMem' must not be null");
        KllMemoryValidate memVal = new KllMemoryValidate(srcMem);
        if (!memVal.doublesSketch) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.SRC_MUST_BE_DOUBLE);
        }
        return new KllHeapDoublesSketch(srcMem, memVal);
    }

    @Override
    public int getK() {
        return this.k_;
    }

    @Override
    public long getN() {
        return this.n_;
    }

    @Override
    double[] getDoubleItemsArray() {
        return this.quantiles_;
    }

    @Override
    double getDoubleSingleItem() {
        if (this.n_ != 1L) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.NOT_SINGLE_ITEM);
            return Double.NaN;
        }
        return this.quantiles_[this.k_ - 1];
    }

    @Override
    float getFloatSingleItem() {
        KllSketch.Error.kllSketchThrow(KllSketch.Error.MUST_NOT_CALL);
        return Float.NaN;
    }

    @Override
    int getM() {
        return this.m_;
    }

    @Override
    double getMaxDoubleItem() {
        return this.maxItem_;
    }

    @Override
    double getMinDoubleItem() {
        return this.minItem_;
    }

    @Override
    int getMinK() {
        return this.minK_;
    }

    @Override
    void incN() {
        ++this.n_;
    }

    @Override
    void incNumLevels() {
    }

    @Override
    boolean isLevelZeroSorted() {
        return this.isLevelZeroSorted_;
    }

    @Override
    void setDoubleItemsArray(double[] doubleItems) {
        this.quantiles_ = doubleItems;
    }

    @Override
    void setDoubleItemsArrayAt(int index, double item) {
        this.quantiles_[index] = item;
    }

    @Override
    void setLevelZeroSorted(boolean sorted) {
        this.isLevelZeroSorted_ = sorted;
    }

    @Override
    void setMaxDoubleItem(double item) {
        this.maxItem_ = item;
    }

    @Override
    void setMinDoubleItem(double item) {
        this.minItem_ = item;
    }

    @Override
    void setMinK(int minK) {
        this.minK_ = minK;
    }

    @Override
    void setN(long n) {
        this.n_ = n;
    }

    @Override
    void setNumLevels(int numLevels) {
    }
}

