/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.util.Arrays;
import java.util.Random;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllSketch;

final class KllFloatsHelper {
    KllFloatsHelper() {
    }

    static void mergeFloatImpl(KllFloatsSketch sketch, KllSketch other) {
        float[] otherFloatItemsArr;
        if (other.isEmpty()) {
            return;
        }
        sketch.nullSortedView();
        long finalN = sketch.getN() + other.getN();
        int otherNumLevels = other.getNumLevels();
        int[] otherLevelsArr = other.getLevelsArray();
        float myMin = sketch.isEmpty() ? Float.NaN : sketch.getMinFloatItem();
        float myMax = sketch.isEmpty() ? Float.NaN : sketch.getMaxFloatItem();
        int myMinK = sketch.getMinK();
        if (other.isCompactSingleItem()) {
            KllFloatsHelper.updateFloat(sketch, other.getFloatSingleItem());
            otherFloatItemsArr = new float[]{};
        } else {
            otherFloatItemsArr = other.getFloatItemsArray();
            for (int i = otherLevelsArr[0]; i < otherLevelsArr[1]; ++i) {
                KllFloatsHelper.updateFloat(sketch, otherFloatItemsArr[i]);
            }
        }
        int myCurNumLevels = sketch.getNumLevels();
        int[] myCurLevelsArr = sketch.getLevelsArray();
        float[] myCurFloatItemsArr = sketch.getFloatItemsArray();
        int myNewNumLevels = myCurNumLevels;
        int[] myNewLevelsArr = myCurLevelsArr;
        float[] myNewFloatItemsArr = myCurFloatItemsArr;
        if (otherNumLevels > 1 && !other.isCompactSingleItem()) {
            int tmpSpaceNeeded = sketch.getNumRetained() + KllHelper.getNumRetainedAboveLevelZero(otherNumLevels, otherLevelsArr);
            float[] workbuf = new float[tmpSpaceNeeded];
            int ub = KllHelper.ubOnNumLevels(finalN);
            int[] worklevels = new int[ub + 2];
            int[] outlevels = new int[ub + 2];
            int provisionalNumLevels = Math.max(myCurNumLevels, otherNumLevels);
            KllFloatsHelper.populateFloatWorkArrays(workbuf, worklevels, provisionalNumLevels, myCurNumLevels, myCurLevelsArr, myCurFloatItemsArr, otherNumLevels, otherLevelsArr, otherFloatItemsArr);
            int[] result = KllFloatsHelper.generalFloatsCompress(sketch.getK(), sketch.getM(), provisionalNumLevels, workbuf, worklevels, workbuf, outlevels, sketch.isLevelZeroSorted(), KllSketch.random);
            int targetItemCount = result[1];
            int curItemCount = result[2];
            myNewNumLevels = result[0];
            assert (myNewNumLevels <= ub);
            myNewFloatItemsArr = targetItemCount == myCurFloatItemsArr.length ? myCurFloatItemsArr : new float[targetItemCount];
            int freeSpaceAtBottom = targetItemCount - curItemCount;
            System.arraycopy(workbuf, outlevels[0], myNewFloatItemsArr, freeSpaceAtBottom, curItemCount);
            int theShift = freeSpaceAtBottom - outlevels[0];
            int finalLevelsArrLen = myCurLevelsArr.length < myNewNumLevels + 1 ? myNewNumLevels + 1 : myCurLevelsArr.length;
            myNewLevelsArr = new int[finalLevelsArrLen];
            for (int lvl = 0; lvl < myNewNumLevels + 1; ++lvl) {
                myNewLevelsArr[lvl] = outlevels[lvl] + theShift;
            }
            if (sketch.updatableMemFormat) {
                sketch.wmem = KllHelper.memorySpaceMgmt(sketch, myNewLevelsArr.length, myNewFloatItemsArr.length);
            }
        }
        sketch.setN(finalN);
        if (other.isEstimationMode()) {
            sketch.setMinK(Math.min(myMinK, other.getMinK()));
        }
        sketch.setNumLevels(myNewNumLevels);
        sketch.setLevelsArray(myNewLevelsArr);
        sketch.setFloatItemsArray(myNewFloatItemsArr);
        float otherMin = other.getMinFloatItem();
        float otherMax = other.getMaxFloatItem();
        sketch.setMinFloatItem(KllFloatsHelper.resolveFloatMinItem(myMin, otherMin));
        sketch.setMaxFloatItem(KllFloatsHelper.resolveFloatMaxItem(myMax, otherMax));
        assert (KllHelper.sumTheSampleWeights(sketch.getNumLevels(), sketch.getLevelsArray()) == sketch.getN());
    }

    static void mergeSortedFloatArrays(float[] bufA, int startA, int lenA, float[] bufB, int startB, int lenB, float[] bufC, int startC) {
        int lenC = lenA + lenB;
        int limA = startA + lenA;
        int limB = startB + lenB;
        int limC = startC + lenC;
        int a = startA;
        int b = startB;
        for (int c = startC; c < limC; ++c) {
            if (a == limA) {
                bufC[c] = bufB[b];
                ++b;
                continue;
            }
            if (b == limB) {
                bufC[c] = bufA[a];
                ++a;
                continue;
            }
            if (bufA[a] < bufB[b]) {
                bufC[c] = bufA[a];
                ++a;
                continue;
            }
            bufC[c] = bufB[b];
            ++b;
        }
        assert (a == limA);
        assert (b == limB);
    }

    static void randomlyHalveDownFloats(float[] buf, int start, int length, Random random) {
        assert (Util.isEven(length));
        int half_length = length / 2;
        int offset = random.nextInt(2);
        int j = start + offset;
        for (int i = start; i < start + half_length; ++i) {
            buf[i] = buf[j];
            j += 2;
        }
    }

    static void randomlyHalveUpFloats(float[] buf, int start, int length, Random random) {
        assert (Util.isEven(length));
        int half_length = length / 2;
        int offset = random.nextInt(2);
        int j = start + length - 1 - offset;
        for (int i = start + length - 1; i >= start + half_length; --i) {
            buf[i] = buf[j];
            j -= 2;
        }
    }

    static void updateFloat(KllSketch sketch, float item) {
        if (Float.isNaN(item)) {
            return;
        }
        float prevMin = sketch.getMinFloatItem();
        float prevMax = sketch.getMaxFloatItem();
        sketch.setMinFloatItem(KllFloatsHelper.resolveFloatMinItem(prevMin, item));
        sketch.setMaxFloatItem(KllFloatsHelper.resolveFloatMaxItem(prevMax, item));
        if (sketch.getLevelsArray()[0] == 0) {
            KllHelper.compressWhileUpdatingSketch(sketch);
        }
        int myLevelsArrAtZero = sketch.getLevelsArray()[0];
        sketch.incN();
        sketch.setLevelZeroSorted(false);
        int nextPos = myLevelsArrAtZero - 1;
        assert (myLevelsArrAtZero >= 0);
        sketch.setLevelsArrayAt(0, nextPos);
        sketch.setFloatItemsArrayAt(nextPos, item);
    }

    private static int[] generalFloatsCompress(int k, int m, int numLevelsIn, float[] inBuf, int[] inLevels, float[] outBuf, int[] outLevels, boolean isLevelZeroSorted, Random random) {
        assert (numLevelsIn > 0);
        int numLevels = numLevelsIn;
        int currentItemCount = inLevels[numLevels] - inLevels[0];
        int targetItemCount = KllHelper.computeTotalItemCapacity(k, m, numLevels);
        boolean doneYet = false;
        outLevels[0] = 0;
        int curLevel = -1;
        while (!doneYet) {
            if (++curLevel == numLevels - 1) {
                inLevels[curLevel + 2] = inLevels[curLevel + 1];
            }
            int rawBeg = inLevels[curLevel];
            int rawLim = inLevels[curLevel + 1];
            int rawPop = rawLim - rawBeg;
            if (currentItemCount < targetItemCount || rawPop < KllHelper.levelCapacity(k, numLevels, curLevel, m)) {
                assert (rawBeg >= outLevels[curLevel]);
                System.arraycopy(inBuf, rawBeg, outBuf, outLevels[curLevel], rawPop);
                outLevels[curLevel + 1] = outLevels[curLevel] + rawPop;
            } else {
                int popAbove = inLevels[curLevel + 2] - rawLim;
                boolean oddPop = Util.isOdd(rawPop);
                int adjBeg = oddPop ? 1 + rawBeg : rawBeg;
                int adjPop = oddPop ? rawPop - 1 : rawPop;
                int halfAdjPop = adjPop / 2;
                if (oddPop) {
                    outBuf[outLevels[curLevel]] = inBuf[rawBeg];
                    outLevels[curLevel + 1] = outLevels[curLevel] + 1;
                } else {
                    outLevels[curLevel + 1] = outLevels[curLevel];
                }
                if (curLevel == 0 && !isLevelZeroSorted) {
                    Arrays.sort(inBuf, adjBeg, adjBeg + adjPop);
                }
                if (popAbove == 0) {
                    KllFloatsHelper.randomlyHalveUpFloats(inBuf, adjBeg, adjPop, random);
                } else {
                    KllFloatsHelper.randomlyHalveDownFloats(inBuf, adjBeg, adjPop, random);
                    KllFloatsHelper.mergeSortedFloatArrays(inBuf, adjBeg, halfAdjPop, inBuf, rawLim, popAbove, inBuf, adjBeg + halfAdjPop);
                }
                currentItemCount -= halfAdjPop;
                inLevels[curLevel + 1] = inLevels[curLevel + 1] - halfAdjPop;
                if (curLevel == numLevels - 1) {
                    targetItemCount += KllHelper.levelCapacity(k, ++numLevels, 0, m);
                }
            }
            if (curLevel != numLevels - 1) continue;
            doneYet = true;
        }
        assert (outLevels[numLevels] - outLevels[0] == currentItemCount);
        return new int[]{numLevels, targetItemCount, currentItemCount};
    }

    private static void populateFloatWorkArrays(float[] workbuf, int[] worklevels, int provisionalNumLevels, int myCurNumLevels, int[] myCurLevelsArr, float[] myCurFloatItemsArr, int otherNumLevels, int[] otherLevelsArr, float[] otherFloatItemsArr) {
        worklevels[0] = 0;
        int selfPopZero = KllHelper.currentLevelSize(0, myCurNumLevels, myCurLevelsArr);
        System.arraycopy(myCurFloatItemsArr, myCurLevelsArr[0], workbuf, worklevels[0], selfPopZero);
        worklevels[1] = worklevels[0] + selfPopZero;
        for (int lvl = 1; lvl < provisionalNumLevels; ++lvl) {
            int selfPop = KllHelper.currentLevelSize(lvl, myCurNumLevels, myCurLevelsArr);
            int otherPop = KllHelper.currentLevelSize(lvl, otherNumLevels, otherLevelsArr);
            worklevels[lvl + 1] = worklevels[lvl] + selfPop + otherPop;
            if (selfPop > 0 && otherPop == 0) {
                System.arraycopy(myCurFloatItemsArr, myCurLevelsArr[lvl], workbuf, worklevels[lvl], selfPop);
                continue;
            }
            if (selfPop == 0 && otherPop > 0) {
                System.arraycopy(otherFloatItemsArr, otherLevelsArr[lvl], workbuf, worklevels[lvl], otherPop);
                continue;
            }
            if (selfPop <= 0 || otherPop <= 0) continue;
            KllFloatsHelper.mergeSortedFloatArrays(myCurFloatItemsArr, myCurLevelsArr[lvl], selfPop, otherFloatItemsArr, otherLevelsArr[lvl], otherPop, workbuf, worklevels[lvl]);
        }
    }

    private static float resolveFloatMaxItem(float myMax, float otherMax) {
        if (Float.isNaN(myMax) && Float.isNaN(otherMax)) {
            return Float.NaN;
        }
        if (Float.isNaN(myMax)) {
            return otherMax;
        }
        if (Float.isNaN(otherMax)) {
            return myMax;
        }
        return Math.max(myMax, otherMax);
    }

    private static float resolveFloatMinItem(float myMin, float otherMin) {
        if (Float.isNaN(myMin) && Float.isNaN(otherMin)) {
            return Float.NaN;
        }
        if (Float.isNaN(myMin)) {
            return otherMin;
        }
        if (Float.isNaN(otherMin)) {
            return myMin;
        }
        return Math.min(myMin, otherMin);
    }
}

