/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import java.lang.reflect.Array;
import java.nio.ByteOrder;
import org.apache.datasketches.ByteArrayUtil;
import org.apache.datasketches.Family;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.DeserializeResult;
import org.apache.datasketches.tuple.SerializerDeserializer;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.SketchIterator;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummaryDeserializer;

public class CompactSketch<S extends Summary>
extends Sketch<S> {
    private static final byte serialVersionWithSummaryClassNameUID = 1;
    private static final byte serialVersionUID = 2;
    private long[] hashArr_;
    private S[] summaryArr_;

    CompactSketch(long[] hashArr, S[] summaryArr, long thetaLong, boolean empty) {
        this.hashArr_ = hashArr;
        this.summaryArr_ = summaryArr;
        this.thetaLong_ = thetaLong;
        this.empty_ = empty;
    }

    CompactSketch(Memory mem, SummaryDeserializer<S> deserializer) {
        boolean hasEntries;
        boolean isThetaIncluded;
        boolean isBigEndian;
        int offset = 0;
        byte preambleLongs = mem.getByte((long)offset++);
        byte version = mem.getByte((long)offset++);
        byte familyId = mem.getByte((long)offset++);
        SerializerDeserializer.validateFamily(familyId, preambleLongs);
        if (version > 2) {
            throw new SketchesArgumentException("Unsupported serial version. Expected: 2 or lower, actual: " + version);
        }
        SerializerDeserializer.validateType(mem.getByte((long)offset++), SerializerDeserializer.SketchType.CompactSketch);
        byte flags = mem.getByte((long)offset++);
        boolean bl = isBigEndian = (flags & 1 << Flags.IS_BIG_ENDIAN.ordinal()) > 0;
        if (isBigEndian ^ ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN)) {
            throw new SketchesArgumentException("Byte order mismatch");
        }
        this.empty_ = (flags & 1 << Flags.IS_EMPTY.ordinal()) > 0;
        boolean bl2 = isThetaIncluded = (flags & 1 << Flags.IS_THETA_INCLUDED.ordinal()) > 0;
        if (isThetaIncluded) {
            this.thetaLong_ = mem.getLong((long)offset);
            offset += 8;
        } else {
            this.thetaLong_ = Long.MAX_VALUE;
        }
        boolean bl3 = hasEntries = (flags & 1 << Flags.HAS_ENTRIES.ordinal()) > 0;
        if (hasEntries) {
            int i;
            byte classNameLength = 0;
            if (version == 1) {
                classNameLength = mem.getByte((long)offset++);
            }
            int count = mem.getInt((long)offset);
            offset += 4;
            if (version == 1) {
                offset += classNameLength;
            }
            this.hashArr_ = new long[count];
            for (i = 0; i < count; ++i) {
                this.hashArr_[i] = mem.getLong((long)offset);
                offset += 8;
            }
            for (i = 0; i < count; ++i) {
                Memory memRegion = mem.region((long)offset, mem.getCapacity() - (long)offset);
                DeserializeResult<S> result = deserializer.heapifySummary(memRegion);
                Summary summary = (Summary)result.getObject();
                Class<?> summaryType = ((Summary)result.getObject()).getClass();
                offset += result.getSize();
                if (this.summaryArr_ == null) {
                    this.summaryArr_ = (Summary[])Array.newInstance(summaryType, count);
                }
                this.summaryArr_[i] = summary;
            }
        }
    }

    @Override
    public CompactSketch<S> compact() {
        return this;
    }

    long[] getHashArr() {
        return this.hashArr_;
    }

    S[] getSummaryArr() {
        return this.summaryArr_;
    }

    @Override
    public int getRetainedEntries() {
        return this.hashArr_ == null ? 0 : this.hashArr_.length;
    }

    @Override
    public byte[] toByteArray() {
        boolean isThetaIncluded;
        int summariesBytesLength = 0;
        Object summariesBytes = null;
        int count = this.getRetainedEntries();
        if (count > 0) {
            summariesBytes = new byte[count][];
            for (int i = 0; i < count; ++i) {
                summariesBytes[i] = this.summaryArr_[i].toByteArray();
                summariesBytesLength += summariesBytes[i].length;
            }
        }
        int sizeBytes = 5;
        boolean bl = isThetaIncluded = this.thetaLong_ < Long.MAX_VALUE;
        if (isThetaIncluded) {
            sizeBytes += 8;
        }
        if (count > 0) {
            sizeBytes += 4 + 8 * count + summariesBytesLength;
        }
        byte[] bytes = new byte[sizeBytes];
        int offset = 0;
        bytes[offset++] = 1;
        bytes[offset++] = 2;
        bytes[offset++] = (byte)Family.TUPLE.getID();
        bytes[offset++] = (byte)SerializerDeserializer.SketchType.CompactSketch.ordinal();
        boolean isBigEndian = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
        bytes[offset++] = (byte)((isBigEndian ? 1 << Flags.IS_BIG_ENDIAN.ordinal() : 0) | (this.empty_ ? 1 << Flags.IS_EMPTY.ordinal() : 0) | (count > 0 ? 1 << Flags.HAS_ENTRIES.ordinal() : 0) | (isThetaIncluded ? 1 << Flags.IS_THETA_INCLUDED.ordinal() : 0));
        if (isThetaIncluded) {
            ByteArrayUtil.putLongLE(bytes, offset, this.thetaLong_);
            offset += 8;
        }
        if (count > 0) {
            int i;
            ByteArrayUtil.putIntLE(bytes, offset, this.getRetainedEntries());
            offset += 4;
            for (i = 0; i < count; ++i) {
                ByteArrayUtil.putLongLE(bytes, offset, this.hashArr_[i]);
                offset += 8;
            }
            for (i = 0; i < count; ++i) {
                System.arraycopy(summariesBytes[i], 0, bytes, offset, summariesBytes[i].length);
                offset += summariesBytes[i].length;
            }
        }
        return bytes;
    }

    @Override
    public SketchIterator<S> iterator() {
        return new SketchIterator(this.hashArr_, this.summaryArr_);
    }

    private static enum Flags {
        IS_BIG_ENDIAN,
        IS_EMPTY,
        HAS_ENTRIES,
        IS_THETA_INCLUDED;

    }
}

