/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.util.Arrays;
import java.util.Random;
import org.apache.datasketches.Util;

class KllHelper {
    private static final Random random = new Random();
    private static final long[] powersOfThree = new long[]{1L, 3L, 9L, 27L, 81L, 243L, 729L, 2187L, 6561L, 19683L, 59049L, 177147L, 531441L, 1594323L, 4782969L, 14348907L, 43046721L, 129140163L, 387420489L, 1162261467L, 3486784401L, 10460353203L, 31381059609L, 94143178827L, 282429536481L, 847288609443L, 2541865828329L, 7625597484987L, 22876792454961L, 68630377364883L, 205891132094649L};

    KllHelper() {
    }

    static boolean isEven(int value) {
        return (value & 1) == 0;
    }

    static boolean isOdd(int value) {
        return (value & 1) == 1;
    }

    static int[] growIntArray(int[] oldArr, int newLen) {
        int oldLen = oldArr.length;
        assert (newLen > oldLen);
        int[] newArr = new int[newLen];
        System.arraycopy(oldArr, 0, newArr, 0, oldLen);
        return newArr;
    }

    static int ubOnNumLevels(long n) {
        return 1 + Long.numberOfTrailingZeros(Util.floorPowerOf2(n));
    }

    static int computeTotalCapacity(int k, int m, int numLevels) {
        long total = 0L;
        for (int h = 0; h < numLevels; ++h) {
            total += (long)KllHelper.levelCapacity(k, numLevels, h, m);
        }
        return (int)total;
    }

    static int levelCapacity(int k, int numLevels, int height, int minWidth) {
        assert (k <= 0x20000000);
        assert (numLevels >= 1 && numLevels <= 61);
        assert (height >= 0 && height < numLevels);
        int depth = numLevels - height - 1;
        return (int)Math.max((long)minWidth, KllHelper.intCapAux(k, depth));
    }

    private static long intCapAux(int k, int depth) {
        if (depth <= 30) {
            return (int)KllHelper.intCapAuxAux(k, depth);
        }
        int half = depth / 2;
        int rest = depth - half;
        long tmp = KllHelper.intCapAuxAux(k, half);
        return KllHelper.intCapAuxAux(tmp, rest);
    }

    private static long intCapAuxAux(long k, int depth) {
        long twok = k << 1;
        long tmp = (twok << depth) / powersOfThree[depth];
        long result = tmp + 1L >> 1;
        assert (result <= k);
        return result;
    }

    static long sumTheSampleWeights(int num_levels, int[] levels) {
        long total = 0L;
        long weight = 1L;
        for (int i = 0; i < num_levels; ++i) {
            total += weight * (long)(levels[i + 1] - levels[i]);
            weight *= 2L;
        }
        return total;
    }

    static void mergeSortedArrays(float[] bufA, int startA, int lenA, float[] bufB, int startB, int lenB, float[] bufC, int startC) {
        int lenC = lenA + lenB;
        int limA = startA + lenA;
        int limB = startB + lenB;
        int limC = startC + lenC;
        int a = startA;
        int b = startB;
        for (int c = startC; c < limC; ++c) {
            if (a == limA) {
                bufC[c] = bufB[b];
                ++b;
                continue;
            }
            if (b == limB) {
                bufC[c] = bufA[a];
                ++a;
                continue;
            }
            if (bufA[a] < bufB[b]) {
                bufC[c] = bufA[a];
                ++a;
                continue;
            }
            bufC[c] = bufB[b];
            ++b;
        }
        assert (a == limA);
        assert (b == limB);
    }

    static int[] generalCompress(int k, int m, int numLevelsIn, float[] inBuf, int[] inLevels, float[] outBuf, int[] outLevels, boolean isLevelZeroSorted) {
        assert (numLevelsIn > 0);
        int numLevels = numLevelsIn;
        int currentItemCount = inLevels[numLevels] - inLevels[0];
        int targetItemCount = KllHelper.computeTotalCapacity(k, m, numLevels);
        boolean doneYet = false;
        outLevels[0] = 0;
        int curLevel = -1;
        while (!doneYet) {
            if (++curLevel == numLevels - 1) {
                inLevels[curLevel + 2] = inLevels[curLevel + 1];
            }
            int rawBeg = inLevels[curLevel];
            int rawLim = inLevels[curLevel + 1];
            int rawPop = rawLim - rawBeg;
            if (currentItemCount < targetItemCount || rawPop < KllHelper.levelCapacity(k, numLevels, curLevel, m)) {
                assert (rawBeg >= outLevels[curLevel]);
                System.arraycopy(inBuf, rawBeg, outBuf, outLevels[curLevel], rawPop);
                outLevels[curLevel + 1] = outLevels[curLevel] + rawPop;
            } else {
                int popAbove = inLevels[curLevel + 2] - rawLim;
                boolean oddPop = KllHelper.isOdd(rawPop);
                int adjBeg = oddPop ? 1 + rawBeg : rawBeg;
                int adjPop = oddPop ? rawPop - 1 : rawPop;
                int halfAdjPop = adjPop / 2;
                if (oddPop) {
                    outBuf[outLevels[curLevel]] = inBuf[rawBeg];
                    outLevels[curLevel + 1] = outLevels[curLevel] + 1;
                } else {
                    outLevels[curLevel + 1] = outLevels[curLevel];
                }
                if (curLevel == 0 && !isLevelZeroSorted) {
                    Arrays.sort(inBuf, adjBeg, adjBeg + adjPop);
                }
                if (popAbove == 0) {
                    KllHelper.randomlyHalveUp(inBuf, adjBeg, adjPop);
                } else {
                    KllHelper.randomlyHalveDown(inBuf, adjBeg, adjPop);
                    KllHelper.mergeSortedArrays(inBuf, adjBeg, halfAdjPop, inBuf, rawLim, popAbove, inBuf, adjBeg + halfAdjPop);
                }
                currentItemCount -= halfAdjPop;
                inLevels[curLevel + 1] = inLevels[curLevel + 1] - halfAdjPop;
                if (curLevel == numLevels - 1) {
                    targetItemCount += KllHelper.levelCapacity(k, ++numLevels, 0, m);
                }
            }
            if (curLevel != numLevels - 1) continue;
            doneYet = true;
        }
        assert (outLevels[numLevels] - outLevels[0] == currentItemCount);
        return new int[]{numLevels, targetItemCount, currentItemCount};
    }

    static void randomlyHalveDown(float[] buf, int start, int length) {
        assert (KllHelper.isEven(length));
        int half_length = length / 2;
        int offset = random.nextInt(2);
        int j = start + offset;
        for (int i = start; i < start + half_length; ++i) {
            buf[i] = buf[j];
            j += 2;
        }
    }

    static void randomlyHalveUp(float[] buf, int start, int length) {
        assert (KllHelper.isEven(length));
        int half_length = length / 2;
        int offset = random.nextInt(2);
        int j = start + length - 1 - offset;
        for (int i = start + length - 1; i >= start + half_length; --i) {
            buf[i] = buf[j];
            j -= 2;
        }
    }
}

