/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.util.Arrays;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.Util;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.EmptyCompactSketch;
import org.apache.datasketches.theta.HeapAnotB;
import org.apache.datasketches.theta.Intersection;
import org.apache.datasketches.theta.IntersectionImpl;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;

public class PairwiseSetOperations {
    public static CompactSketch intersect(Sketch skA, Sketch skB) {
        if ((skA == null || skA instanceof EmptyCompactSketch) && (skB == null || skB instanceof EmptyCompactSketch)) {
            return EmptyCompactSketch.getInstance();
        }
        short seedHash = skA == null ? skB.getSeedHash() : skA.getSeedHash();
        IntersectionImpl inter = new IntersectionImpl(seedHash);
        return ((Intersection)inter).intersect(skA, skB, true, null);
    }

    public static CompactSketch aNotB(Sketch skA, Sketch skB) {
        if ((skA == null || skA instanceof EmptyCompactSketch) && (skB == null || skB instanceof EmptyCompactSketch)) {
            return EmptyCompactSketch.getInstance();
        }
        short seedHash = skA == null || skA instanceof EmptyCompactSketch ? skB.getSeedHash() : skA.getSeedHash();
        HeapAnotB anotb = new HeapAnotB(seedHash);
        return anotb.aNotB(skA, skB, true, null);
    }

    public static CompactSketch union(CompactSketch skA, CompactSketch skB) {
        return PairwiseSetOperations.union(skA, skB, 4096);
    }

    public static CompactSketch union(CompactSketch skA, CompactSketch skB, int k) {
        long[] outArr;
        long hashB;
        int swA = skA == null || skA instanceof EmptyCompactSketch ? 0 : 2;
        int swB = skB == null || skB instanceof EmptyCompactSketch ? 0 : 1;
        int sw = swA | swB;
        switch (sw) {
            case 0: {
                return EmptyCompactSketch.getInstance();
            }
            case 1: {
                PairwiseSetOperations.checkOrdered(skB);
                return PairwiseSetOperations.maybeCutback(skB, k);
            }
            case 2: {
                PairwiseSetOperations.checkOrdered(skA);
                return PairwiseSetOperations.maybeCutback(skA, k);
            }
            case 3: {
                PairwiseSetOperations.checkOrdered(skA);
                PairwiseSetOperations.checkOrdered(skB);
                PairwiseSetOperations.seedHashesCheck(skA, skB);
            }
        }
        long thetaLongA = skA.getThetaLong();
        long thetaLongB = skB.getThetaLong();
        long thetaLong = Math.min(thetaLongA, thetaLongB);
        long[] cacheA = skA.hasMemory() ? skA.getCache() : (long[])skA.getCache().clone();
        long[] cacheB = skB.hasMemory() ? skB.getCache() : (long[])skB.getCache().clone();
        int aLen = cacheA.length;
        int bLen = cacheB.length;
        long[] outCache = new long[aLen + bLen];
        int indexA = 0;
        int indexB = 0;
        int indexOut = 0;
        long hashA = aLen == 0 ? thetaLong : cacheA[indexA];
        long l = hashB = bLen == 0 ? thetaLong : cacheB[indexB];
        while (indexA < aLen || indexB < bLen) {
            if (hashA == hashB) {
                if (hashA >= thetaLong) break;
                if (indexOut >= k) {
                    thetaLong = hashA;
                    break;
                }
                outCache[indexOut++] = hashA;
                hashA = ++indexA < aLen ? cacheA[indexA] : thetaLong;
                hashB = ++indexB < bLen ? cacheB[indexB] : thetaLong;
                continue;
            }
            if (hashA < hashB) {
                if (hashA >= thetaLong) break;
                if (indexOut >= k) {
                    thetaLong = hashA;
                    break;
                }
                outCache[indexOut++] = hashA;
                hashA = ++indexA < aLen ? cacheA[indexA] : thetaLong;
                continue;
            }
            if (hashB >= thetaLong) break;
            if (indexOut >= k) {
                thetaLong = hashB;
                break;
            }
            outCache[indexOut++] = hashB;
            hashB = ++indexB < bLen ? cacheB[indexB] : thetaLong;
        }
        int curCount = indexOut;
        if (indexOut > k) {
            outArr = Arrays.copyOf(outCache, k);
            curCount = k;
        } else {
            outArr = Arrays.copyOf(outCache, curCount);
        }
        return SetOperation.createCompactSketch(outArr, false, skA.getSeedHash(), curCount, thetaLong, true, null);
    }

    private static CompactSketch maybeCutback(CompactSketch csk, int k) {
        boolean empty = csk.isEmpty();
        int curCount = csk.getRetainedEntries(true);
        long thetaLong = csk.getThetaLong();
        if (curCount > k) {
            long[] cache = csk.hasMemory() ? csk.getCache() : (long[])csk.getCache().clone();
            thetaLong = cache[k];
            long[] arr = Arrays.copyOf(cache, k);
            curCount = k;
            return SetOperation.createCompactSketch(arr, empty, csk.getSeedHash(), curCount, thetaLong, true, null);
        }
        return csk;
    }

    private static void checkOrdered(CompactSketch csk) {
        if (!csk.isOrdered()) {
            throw new SketchesArgumentException("Given sketch must be ordered.");
        }
    }

    private static short seedHashesCheck(Sketch skA, Sketch skB) {
        short seedHashA = skA.getSeedHash();
        short seedHashB = skB.getSeedHash();
        return Util.checkSeedHashes(seedHashA, seedHashB);
    }
}

