/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.Family;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.DirectCompactOrderedSketch;
import org.apache.datasketches.theta.DirectCompactUnorderedSketch;
import org.apache.datasketches.theta.EmptyCompactSketch;
import org.apache.datasketches.theta.HeapCompactOrderedSketch;
import org.apache.datasketches.theta.HeapCompactUnorderedSketch;
import org.apache.datasketches.theta.IntersectionImpl;
import org.apache.datasketches.theta.IntersectionImplR;
import org.apache.datasketches.theta.SetOperationBuilder;
import org.apache.datasketches.theta.SingleItemSketch;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.UnionImpl;

public abstract class SetOperation {
    static final int CONST_PREAMBLE_LONGS = 3;

    SetOperation() {
    }

    public static final SetOperationBuilder builder() {
        return new SetOperationBuilder();
    }

    public static SetOperation heapify(Memory srcMem) {
        return SetOperation.heapify(srcMem, 9001L);
    }

    public static SetOperation heapify(Memory srcMem, long seed) {
        byte famID = srcMem.getByte(2L);
        Family family = Family.idToFamily(famID);
        switch (family) {
            case UNION: {
                return UnionImpl.heapifyInstance(srcMem, seed);
            }
            case INTERSECTION: {
                return IntersectionImpl.heapifyInstance(srcMem, seed);
            }
        }
        throw new SketchesArgumentException("SetOperation cannot heapify family: " + family.toString());
    }

    public static SetOperation wrap(Memory srcMem) {
        return SetOperation.wrap(srcMem, 9001L);
    }

    public static SetOperation wrap(Memory srcMem, long seed) {
        byte famID = srcMem.getByte(2L);
        Family family = Family.idToFamily(famID);
        byte serVer = srcMem.getByte(1L);
        if (serVer != 3) {
            throw new SketchesArgumentException("SerVer must be 3: " + serVer);
        }
        switch (family) {
            case UNION: {
                return UnionImpl.wrapInstance(srcMem, seed);
            }
            case INTERSECTION: {
                return IntersectionImplR.wrapInstance(srcMem, seed);
            }
        }
        throw new SketchesArgumentException("SetOperation cannot wrap family: " + family.toString());
    }

    public static SetOperation wrap(WritableMemory srcMem) {
        return SetOperation.wrap(srcMem, 9001L);
    }

    public static SetOperation wrap(WritableMemory srcMem, long seed) {
        byte famID = srcMem.getByte(2L);
        Family family = Family.idToFamily(famID);
        byte serVer = srcMem.getByte(1L);
        if (serVer != 3) {
            throw new SketchesArgumentException("SerVer must be 3: " + serVer);
        }
        switch (family) {
            case UNION: {
                return UnionImpl.wrapInstance(srcMem, seed);
            }
            case INTERSECTION: {
                return IntersectionImpl.wrapInstance(srcMem, seed);
            }
        }
        throw new SketchesArgumentException("SetOperation cannot wrap family: " + family.toString());
    }

    public static int getMaxUnionBytes(int nomEntries) {
        int nomEnt = Util.ceilingPowerOf2(nomEntries);
        return (nomEnt << 4) + (Family.UNION.getMaxPreLongs() << 3);
    }

    public static int getMaxIntersectionBytes(int nomEntries) {
        int nomEnt = Util.ceilingPowerOf2(nomEntries);
        int bytes = (nomEnt << 4) + (Family.INTERSECTION.getMaxPreLongs() << 3);
        return bytes;
    }

    public abstract Family getFamily();

    public abstract boolean isSameResource(Memory var1);

    abstract long[] getCache();

    abstract int getRetainedEntries(boolean var1);

    abstract short getSeedHash();

    abstract long getThetaLong();

    static short computeSeedHash(long seed) {
        return Util.computeSeedHash(seed);
    }

    abstract boolean isEmpty();

    static final CompactSketch createCompactSketch(long[] compactCache, boolean empty, short seedHash, int curCount, long thetaLong, boolean dstOrdered, WritableMemory dstMem) {
        if (empty = Sketch.emptyFromCountAndTheta(curCount, thetaLong = Sketch.thetaOnCompact(empty, curCount, thetaLong))) {
            EmptyCompactSketch sk = EmptyCompactSketch.getInstance();
            if (dstMem != null) {
                dstMem.putByteArray(0L, sk.toByteArray(), 0, 8);
            }
            return sk;
        }
        if (thetaLong == Long.MAX_VALUE && curCount == 1) {
            SingleItemSketch sis = new SingleItemSketch(compactCache[0], seedHash);
            if (dstMem != null && dstMem.getCapacity() >= 16L) {
                dstMem.putByteArray(0L, sis.toByteArray(), 0, 16);
            }
            return sis;
        }
        if (dstMem == null) {
            if (dstOrdered) {
                return HeapCompactOrderedSketch.compact(compactCache, empty, seedHash, curCount, thetaLong);
            }
            return HeapCompactUnorderedSketch.compact(compactCache, empty, seedHash, curCount, thetaLong);
        }
        if (dstOrdered) {
            return DirectCompactOrderedSketch.compact(compactCache, empty, seedHash, curCount, thetaLong, dstMem);
        }
        return DirectCompactUnorderedSketch.compact(compactCache, empty, seedHash, curCount, thetaLong, dstMem);
    }

    static final int computeMinLgArrLongsFromCount(int count) {
        int upperCount = (int)Math.ceil((double)count / 0.9375);
        int arrLongs = Math.max(Util.ceilingPowerOf2(upperCount), 32);
        int newLgArrLongs = Integer.numberOfTrailingZeros(arrLongs);
        return newLgArrLongs;
    }

    static boolean isValidSetOpID(int id) {
        Family family = Family.idToFamily(id);
        boolean ret = family == Family.UNION || family == Family.INTERSECTION || family == Family.A_NOT_B;
        return ret;
    }
}

