/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import org.apache.datasketches.Util;
import org.apache.datasketches.hll.AuxHashMap;
import org.apache.datasketches.hll.Conversions;
import org.apache.datasketches.hll.CurMode;
import org.apache.datasketches.hll.HllArray;
import org.apache.datasketches.hll.HllEstimators;
import org.apache.datasketches.hll.HllSketchImpl;
import org.apache.datasketches.hll.HllUtil;
import org.apache.datasketches.hll.PairIterator;
import org.apache.datasketches.hll.PreambleUtil;
import org.apache.datasketches.hll.TgtHllType;

abstract class AbstractHllArray
extends HllSketchImpl {
    AuxHashMap auxHashMap = null;
    final int auxStart;

    AbstractHllArray(int lgConfigK, TgtHllType tgtHllType, CurMode curMode) {
        super(lgConfigK, tgtHllType, curMode);
        this.auxStart = PreambleUtil.HLL_BYTE_ARR_START + AbstractHllArray.hll4ArrBytes(lgConfigK);
    }

    abstract void addToHipAccum(double var1);

    @Override
    HllArray copyAs(TgtHllType tgtHllType) {
        if (tgtHllType == this.getTgtHllType()) {
            return (HllArray)this.copy();
        }
        if (tgtHllType == TgtHllType.HLL_4) {
            return Conversions.convertToHll4(this);
        }
        if (tgtHllType == TgtHllType.HLL_6) {
            return Conversions.convertToHll6(this);
        }
        return Conversions.convertToHll8(this);
    }

    abstract void decNumAtCurMin();

    AuxHashMap getAuxHashMap() {
        return this.auxHashMap;
    }

    PairIterator getAuxIterator() {
        return this.auxHashMap == null ? null : this.auxHashMap.getIterator();
    }

    @Override
    int getCompactSerializationBytes() {
        AuxHashMap auxHashMap = this.getAuxHashMap();
        int auxCountBytes = auxHashMap == null ? 0 : auxHashMap.getAuxCount() << 2;
        return PreambleUtil.HLL_BYTE_ARR_START + this.getHllByteArrBytes() + auxCountBytes;
    }

    @Override
    double getCompositeEstimate() {
        return HllEstimators.hllCompositeEstimate(this);
    }

    abstract int getCurMin();

    @Override
    double getEstimate() {
        if (this.isOutOfOrderFlag()) {
            return this.getCompositeEstimate();
        }
        return this.getHipAccum();
    }

    abstract double getHipAccum();

    abstract int getHllByteArrBytes();

    @Override
    abstract PairIterator iterator();

    abstract double getKxQ0();

    abstract double getKxQ1();

    @Override
    double getLowerBound(int numStdDev) {
        HllUtil.checkNumStdDev(numStdDev);
        return HllEstimators.hllLowerBound(this, numStdDev);
    }

    @Override
    int getMemDataStart() {
        return PreambleUtil.HLL_BYTE_ARR_START;
    }

    abstract AuxHashMap getNewAuxHashMap();

    abstract int getNumAtCurMin();

    @Override
    int getPreInts() {
        return 10;
    }

    abstract int getSlot(int var1);

    @Override
    int getUpdatableSerializationBytes() {
        return PreambleUtil.HLL_BYTE_ARR_START + this.getHllByteArrBytes();
    }

    @Override
    double getUpperBound(int numStdDev) {
        HllUtil.checkNumStdDev(numStdDev);
        return HllEstimators.hllUpperBound(this, numStdDev);
    }

    abstract void putAuxHashMap(AuxHashMap var1, boolean var2);

    abstract void putCurMin(int var1);

    abstract void putHipAccum(double var1);

    abstract void putKxQ0(double var1);

    abstract void putKxQ1(double var1);

    abstract void putNumAtCurMin(int var1);

    abstract void putSlot(int var1, int var2);

    static final int hll4ArrBytes(int lgConfigK) {
        return 1 << lgConfigK - 1;
    }

    static final int hll6ArrBytes(int lgConfigK) {
        int numSlots = 1 << lgConfigK;
        return (numSlots * 3 >>> 2) + 1;
    }

    static final int hll8ArrBytes(int lgConfigK) {
        return 1 << lgConfigK;
    }

    static final void hipAndKxQIncrementalUpdate(AbstractHllArray host, int oldValue, int newValue) {
        assert (newValue > oldValue);
        int configK = 1 << host.getLgConfigK();
        double kxq0 = host.getKxQ0();
        double kxq1 = host.getKxQ1();
        host.addToHipAccum((double)configK / (kxq0 + kxq1));
        if (oldValue < 32) {
            host.putKxQ0(kxq0 -= Util.invPow2(oldValue));
        } else {
            host.putKxQ1(kxq1 -= Util.invPow2(oldValue));
        }
        if (newValue < 32) {
            host.putKxQ0(kxq0 += Util.invPow2(newValue));
        } else {
            host.putKxQ1(kxq1 += Util.invPow2(newValue));
        }
    }
}

