/*
 * Decompiled with CFR 0.152.
 */
package org.cxf.interceptor.logging;

import com.google.common.base.Throwables;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.cxf.common.i18n.UncheckedException;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.LoggingMessage;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.cxf.interceptor.logging.LoggingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomizableCxfInterceptor
extends AbstractPhaseInterceptor {
    private static final Logger log = LoggerFactory.getLogger(CustomizableCxfInterceptor.class);
    private final Consumer<LoggingContext> loggingAction;

    public CustomizableCxfInterceptor(Consumer<LoggingContext> loggingAction) {
        this("setup", loggingAction);
    }

    public CustomizableCxfInterceptor(String phase, Consumer<LoggingContext> loggingAction) {
        super(phase);
        this.loggingAction = loggingAction;
    }

    public void handleMessage(Message message) throws Fault {
        try {
            Logger messageLogger = this.getMessageLogger(message);
            if (message.containsKey((Object)LoggingMessage.ID_KEY)) {
                return;
            }
            String id = this.getMessageId(message);
            message.put((Object)LoggingMessage.ID_KEY, (Object)id);
            Optional.ofNullable(message.getContent(List.class)).ifPresent(list -> list.forEach(o -> this.loggingAction.accept(new LoggingContext(id, o, message, messageLogger))));
        }
        catch (UndeclaredThrowableException exception) {
            Throwable rootCause = Throwables.getRootCause((Throwable)exception);
            Throwables.propagateIfInstanceOf((Throwable)rootCause, UncheckedException.class);
            this.logUnexpectedException(Throwables.getRootCause((Throwable)exception));
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, UncheckedException.class);
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            this.logUnexpectedException(rootCause);
        }
    }

    private String getMessageId(Message message) {
        String id = (String)message.getExchange().get((Object)LoggingMessage.ID_KEY);
        if (id == null) {
            id = LoggingMessage.nextId();
            message.getExchange().put((Object)LoggingMessage.ID_KEY, (Object)id);
        }
        return id;
    }

    void logUnexpectedException(Throwable ex) {
        log.debug("Unexpected error: class: {}, message: {}", ex.getClass(), (Object)ex.getMessage());
    }

    protected Logger getMessageLogger(Message msg) {
        Endpoint ep = msg.getExchange().getEndpoint();
        if (ep == null || ep.getEndpointInfo() == null) {
            return this.getLogger();
        }
        EndpointInfo endpoint = ep.getEndpointInfo();
        if (endpoint.getService() == null) {
            return this.getLogger();
        }
        Logger logger = (Logger)endpoint.getProperty("MessageLogger", Logger.class);
        if (logger == null) {
            String serviceName = endpoint.getService().getName().getLocalPart();
            InterfaceInfo iface = endpoint.getService().getInterface();
            String portName = endpoint.getName().getLocalPart();
            String portTypeName = iface.getName().getLocalPart();
            String logName = "org.apache.cxf.services." + serviceName + "." + portName + "." + portTypeName;
            logger = LoggerFactory.getLogger((String)logName);
            endpoint.setProperty("MessageLogger", (Object)logger);
        }
        return logger;
    }

    protected Logger getLogger() {
        return log;
    }
}

