/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.validator.internal;

import java.util.Stack;
import org.apache.cxf.common.i18n.Message;

public final class ValidationResult {
    private Stack<String> errors = new Stack();
    private Stack<String> warnings = new Stack();

    public Stack<String> getErrors() {
        return this.errors;
    }

    public Stack<String> getWarnings() {
        return this.warnings;
    }

    public void addError(Message msg) {
        this.addError(msg.toString());
    }

    public void addError(String error) {
        this.errors.push(error);
    }

    public void addWarning(Message msg) {
        this.addWarning(msg.toString());
    }

    public void addWarning(String warning) {
        this.warnings.push(warning);
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public boolean isSuccessful() {
        return this.errors.isEmpty() && this.warnings.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("\n Summary: ");
        sb.append(" Failures: ");
        sb.append(this.errors.size());
        sb.append(", Warnings: ");
        sb.append(this.warnings.size());
        if (!this.errors.isEmpty()) {
            sb.append("\n\n <<< ERROR! \n");
            while (!this.errors.empty()) {
                sb.append(this.errors.pop());
                sb.append('\n');
            }
        }
        if (!this.warnings.isEmpty()) {
            sb.append("\n <<< WARNING! \n");
            while (!this.warnings.empty()) {
                sb.append(this.warnings.pop());
                sb.append('\n');
            }
        }
        return sb.toString();
    }
}

