/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.testutil.common;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.embedded.EmbeddedActiveMQ;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.apache.cxf.wsdl.WSDLManager;

public class EmbeddedJMSBrokerLauncher
extends AbstractBusTestServerBase {
    public static final String PORT = EmbeddedJMSBrokerLauncher.allocatePort(EmbeddedJMSBrokerLauncher.class);
    EmbeddedActiveMQ broker;
    String brokerName;
    private final String brokerUrl1;

    public EmbeddedJMSBrokerLauncher() {
        this(null);
    }

    public EmbeddedJMSBrokerLauncher(String url) {
        this.brokerUrl1 = url != null ? url : "tcp://localhost:" + PORT;
    }

    public void setBrokerName(String s) {
        this.brokerName = s;
    }

    public String getBrokerURL() {
        return this.brokerUrl1;
    }

    public String getEncodedBrokerURL() {
        return this.brokerUrl1.replace("?", "%3F");
    }

    public void updateWsdl(Bus b, URL wsdlLocation) {
        this.updateWsdl(b, wsdlLocation.toString());
    }

    public void updateWsdl(Bus b, String wsdlLocation) {
        EmbeddedJMSBrokerLauncher.updateWsdlExtensors(b, wsdlLocation, this.brokerUrl1, this.getEncodedBrokerURL());
    }

    public static void updateWsdlExtensors(Bus bus, String wsdlLocation) {
        EmbeddedJMSBrokerLauncher.updateWsdlExtensors(bus, wsdlLocation, "tcp://localhost:" + PORT, null);
    }

    public static void updateWsdlExtensors(Bus bus, String wsdlLocation, String url, String encodedUrl) {
        try {
            if (encodedUrl == null) {
                encodedUrl = url;
            }
            if (bus == null) {
                bus = BusFactory.getThreadDefaultBus();
            }
            Definition def = ((WSDLManager)bus.getExtension(WSDLManager.class)).getDefinition(wsdlLocation);
            Map map = def.getAllServices();
            for (Object o : map.values()) {
                Service service = (Service)o;
                Map ports = service.getPorts();
                EmbeddedJMSBrokerLauncher.adjustExtensibilityElements(service.getExtensibilityElements(), url, encodedUrl);
                for (Object p : ports.values()) {
                    Port port = (Port)p;
                    EmbeddedJMSBrokerLauncher.adjustExtensibilityElements(port.getExtensibilityElements(), url, encodedUrl);
                    EmbeddedJMSBrokerLauncher.adjustExtensibilityElements(port.getBinding().getExtensibilityElements(), url, encodedUrl);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void adjustExtensibilityElements(List<?> l, String url, String encodedUrl) {
        for (Object e : l) {
            if (e instanceof SOAPAddress) {
                Object add = ((SOAPAddress)e).getLocationURI();
                int idx = ((String)add).indexOf("jndiURL=");
                if (idx == -1) continue;
                int idx2 = ((String)add).indexOf(38, idx);
                add = ((String)add).substring(0, idx) + "jndiURL=" + encodedUrl + (idx2 == -1 ? "" : ((String)add).substring(idx2));
                ((SOAPAddress)e).setLocationURI((String)add);
                continue;
            }
            if (e.getClass().getSimpleName().startsWith("JndiURLType")) {
                try {
                    e.getClass().getMethod("setValue", String.class).invoke(e, url);
                }
                catch (Exception add) {}
                continue;
            }
            try {
                Field f = e.getClass().getDeclaredField("jmsNamingProperty");
                ReflectionUtil.setAccessible((AccessibleObject)f);
                List props = (List)f.get(e);
                for (Object prop : props) {
                    f = prop.getClass().getDeclaredField("name");
                    ReflectionUtil.setAccessible((AccessibleObject)f);
                    if (!"java.naming.provider.url".equals(f.get(prop))) continue;
                    f = prop.getClass().getDeclaredField("value");
                    ReflectionUtil.setAccessible((AccessibleObject)f);
                    String value = (String)f.get(prop);
                    if (value != null && value.startsWith("classpath")) continue;
                    f.set(prop, url);
                }
            }
            catch (Exception exception) {
            }
        }
    }

    public void stop() throws Exception {
        this.tearDown();
    }

    @Override
    public void tearDown() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    @Override
    public final void run() throws Exception {
        ConfigurationImpl config = new ConfigurationImpl().setSecurityEnabled(false).setPersistenceEnabled(false).setJMXManagementEnabled(false).addAcceptorConfiguration("def", this.brokerUrl1);
        if (this.brokerName != null) {
            config.setName(this.brokerName);
        }
        this.broker = new EmbeddedActiveMQ();
        this.broker.setConfiguration((Configuration)config);
        this.broker.start();
    }

    public static void main(String[] args) throws Exception {
        try {
            String url = null;
            if (args.length > 0) {
                url = args[0];
            }
            EmbeddedJMSBrokerLauncher s = new EmbeddedJMSBrokerLauncher(url);
            s.start();
        }
        finally {
            System.out.println("done!");
        }
    }
}

