/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.core.logging;

import java.io.Writer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jca.core.logging.WriterHandler;

public final class LoggerHelper {
    public static final Level DEFAULT_LOG_LEVEL = Level.WARNING;
    public static final String CONSOLE_HANDLER = "ConsoleHandler";
    public static final String WRITER_HANDLER = "WriterHandler";
    private static String rootLoggerName = "org.apache.cxf";
    private static boolean initComplete;
    private static Level currentLogLevel;

    private LoggerHelper() {
    }

    public static void initializeLoggingOnWriter(Writer writer) {
        Logger cxfLogger;
        if (writer != null && LoggerHelper.getHandler(cxfLogger = LoggerHelper.getRootCXFLogger(), WRITER_HANDLER) == null) {
            WriterHandler handler = new WriterHandler(writer);
            cxfLogger.addHandler(handler);
        }
    }

    public static void deleteLoggingOnWriter() {
        Logger cxfLogger = LoggerHelper.getRootCXFLogger();
        Handler handler = LoggerHelper.getHandler(cxfLogger, WRITER_HANDLER);
        if (handler != null) {
            cxfLogger.removeHandler(handler);
        }
        LoggerHelper.enableConsoleLogging();
    }

    public static boolean loggerInitialisedOutsideConnector() {
        Handler[] handlers = LoggerHelper.getConsoleLogger().getHandlers();
        return handlers != null && handlers.length > 0;
    }

    static Handler getHandler(Logger log, String handlerName) {
        Handler[] handlers = log.getHandlers();
        Handler result = null;
        for (int i = 0; i < handlers.length; ++i) {
            if (!handlers[i].getClass().getName().endsWith(handlerName)) continue;
            result = handlers[i];
        }
        return result;
    }

    public static void disableConsoleLogging() {
        Handler handler = LoggerHelper.getHandler(LoggerHelper.getConsoleLogger(), CONSOLE_HANDLER);
        LoggerHelper.getConsoleLogger().removeHandler(handler);
    }

    public static void enableConsoleLogging() {
        if (LoggerHelper.getHandler(LoggerHelper.getConsoleLogger(), CONSOLE_HANDLER) == null) {
            ConsoleHandler console = new ConsoleHandler();
            LoggerHelper.getConsoleLogger().addHandler(console);
        }
    }

    public static void setLogLevel(String logLevel) {
        LoggerHelper.init();
        try {
            currentLogLevel = Level.parse(logLevel);
        }
        catch (IllegalArgumentException ex) {
            currentLogLevel = DEFAULT_LOG_LEVEL;
        }
        LoggerHelper.getRootCXFLogger().setLevel(currentLogLevel);
    }

    public static String getLogLevel() {
        return currentLogLevel.toString();
    }

    public static Logger getRootCXFLogger() {
        return LogUtils.getLogger(LoggerHelper.class, null, (String)LoggerHelper.getRootLoggerName());
    }

    public static Logger getConsoleLogger() {
        return LogUtils.getLogger(LoggerHelper.class, null, (String)"");
    }

    public static void init() {
        if (!initComplete) {
            initComplete = true;
            if (!LoggerHelper.loggerInitialisedOutsideConnector()) {
                LoggerHelper.enableConsoleLogging();
            }
        }
    }

    public static String getRootLoggerName() {
        return rootLoggerName;
    }

    public static void setRootLoggerName(String loggerName) {
        rootLoggerName = loggerName;
    }

    static {
        currentLogLevel = Level.WARNING;
    }
}

