/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.maven_plugin.Option;
import org.apache.cxf.maven_plugin.WsdlOption;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WsdlOptionLoader {
    private static final String WSDL_OPTIONS = "-options$";
    private static final String WSDL_BINDINGS = "-binding-?\\d*.xml$";

    private String getIncludeExcludeString(String[] arr) {
        if (arr == null) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        if (arr != null) {
            for (String s : arr) {
                if (str.length() > 0) {
                    str.append(',');
                }
                str.append(s);
            }
        }
        return str.toString();
    }

    public List<WsdlOption> load(String wsdlRoot) throws MojoExecutionException {
        return this.load(new File(wsdlRoot), new String[]{"*.wsdl"}, null, null);
    }

    public List<WsdlOption> load(File wsdlBasedir, String[] includes, String[] excludes, Option defaultOptions) throws MojoExecutionException {
        if (wsdlBasedir == null) {
            return new ArrayList<WsdlOption>();
        }
        if (!wsdlBasedir.exists()) {
            throw new MojoExecutionException(wsdlBasedir + " does not exist");
        }
        return this.findJobs(wsdlBasedir, this.getWsdlFiles(wsdlBasedir, includes, excludes), defaultOptions);
    }

    private List<File> getWsdlFiles(File dir, String[] includes, String[] excludes) throws MojoExecutionException {
        ArrayList<String> exList = new ArrayList<String>();
        if (excludes != null) {
            exList.addAll(Arrays.asList(excludes));
        }
        exList.addAll(Arrays.asList(FileUtils.getDefaultExcludes()));
        String inc = this.getIncludeExcludeString(includes);
        String ex = this.getIncludeExcludeString(exList.toArray(new String[exList.size()]));
        try {
            List newfiles = FileUtils.getFiles((File)dir, (String)inc, (String)ex);
            return CastUtils.cast((List)newfiles);
        }
        catch (IOException exc) {
            throw new MojoExecutionException(exc.getMessage(), (Exception)exc);
        }
    }

    private File getOptions(File dir, String pattern) {
        List files = org.apache.cxf.helpers.FileUtils.getFiles((File)dir, (String)pattern);
        if (files.size() > 0) {
            return (File)files.iterator().next();
        }
        return null;
    }

    private List<File> getBindingFiles(File dir, String pattern) {
        return org.apache.cxf.helpers.FileUtils.getFiles((File)dir, (String)pattern);
    }

    protected List<WsdlOption> findJobs(File dir, List<File> wsdlFiles, Option defaultOptions) {
        ArrayList<WsdlOption> jobs = new ArrayList<WsdlOption>();
        for (File wsdl : wsdlFiles) {
            if (wsdl == null || !wsdl.exists()) continue;
            String wsdlName = wsdl.getName();
            int idx = wsdlName.toLowerCase().lastIndexOf(".wsdl");
            if (idx == -1) {
                idx = wsdlName.lastIndexOf(46);
            }
            if (idx == -1) continue;
            wsdlName = wsdlName.substring(0, idx);
            File options = this.getOptions(dir, wsdlName + WSDL_OPTIONS);
            List<File> bindings = this.getBindingFiles(dir, wsdlName + WSDL_BINDINGS);
            jobs.add(this.generateWsdlOption(wsdl, bindings, options, defaultOptions));
        }
        return jobs;
    }

    protected WsdlOption generateWsdlOption(File wsdl, List<File> bindingFiles, File options, Option defaultOptions) {
        WsdlOption wsdlOption = new WsdlOption();
        if (options != null && options.exists()) {
            try {
                List lines = org.apache.cxf.helpers.FileUtils.readLines((File)options);
                if (lines.size() > 0) {
                    wsdlOption.getExtraargs().addAll(Arrays.asList(((String)lines.iterator().next()).split(" ")));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (defaultOptions != null) {
            defaultOptions.copyOptions(wsdlOption);
        }
        if (bindingFiles != null) {
            for (File binding : bindingFiles) {
                wsdlOption.addBindingFile(binding);
            }
        }
        wsdlOption.setWsdl(wsdl.toURI().toString());
        return wsdlOption;
    }
}

