/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.maven_plugin.Option;
import org.apache.cxf.maven_plugin.WsdlOption;
import org.apache.cxf.maven_plugin.WsdlOptionLoader;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.wsdlto.WSDLToJava;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDL2JavaMojo
extends AbstractMojo {
    File testSourceRoot;
    File sourceRoot;
    String classesDirectory;
    MavenProject project;
    Option defaultOptions;
    WsdlOption[] wsdlOptions;
    File wsdlRoot;
    File testWsdlRoot;
    File markerDirectory;
    boolean useCompileClasspath;
    String[] includes;
    String[] excludes;

    private List<WsdlOption> getWsdlOptionsFromDir(File root, File output) throws MojoExecutionException {
        ArrayList<WsdlOption> options = new ArrayList<WsdlOption>();
        for (WsdlOption o : new WsdlOptionLoader().load(root, this.includes, this.excludes, this.defaultOptions)) {
            if (o.getOutputDir() == null) {
                o.setOutputDir(output);
            }
            if (options.contains(o)) continue;
            options.add(o);
        }
        return options;
    }

    private void mergeOptions(List<WsdlOption> options) {
        File outputDirFile = this.testSourceRoot == null ? this.sourceRoot : this.testSourceRoot;
        for (WsdlOption o : this.wsdlOptions) {
            File file;
            if (o.getOutputDir() == null) {
                o.setOutputDir(outputDirFile);
            }
            if (!(file = new File(o.getWsdl())).exists()) {
                file = new File(this.project.getBasedir(), o.getWsdl());
            }
            if (file.exists()) {
                file = file.getAbsoluteFile();
                for (WsdlOption o2 : options) {
                    File file2 = null;
                    try {
                        URI uri = new URI(o2.getWsdl());
                        if (uri.isAbsolute()) {
                            file2 = new File(uri);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (file2 == null || !file2.exists()) {
                        file2 = new File(o2.getWsdl());
                    }
                    if (file2 == null || !file2.exists()) {
                        file2 = new File(this.project.getBasedir(), o2.getWsdl());
                    }
                    if (!file2.exists() || !file2.getAbsoluteFile().equals(file)) continue;
                    o.getExtraargs().addAll(0, o2.getExtraargs());
                    options.remove(o2);
                    break;
                }
            }
            options.add(0, o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (this.includes == null) {
            this.includes = new String[]{"*.wsdl"};
        }
        File classesDir = new File(this.classesDirectory);
        classesDir.mkdirs();
        this.markerDirectory.mkdirs();
        ArrayList<WsdlOption> options = new ArrayList<WsdlOption>();
        if (this.wsdlRoot != null && this.wsdlRoot.exists()) {
            options.addAll(this.getWsdlOptionsFromDir(this.wsdlRoot, this.sourceRoot));
        }
        if (this.testWsdlRoot != null && this.testWsdlRoot.exists()) {
            options.addAll(this.getWsdlOptionsFromDir(this.testWsdlRoot, this.testSourceRoot));
        }
        if (this.wsdlOptions != null) {
            this.mergeOptions(options);
        }
        this.wsdlOptions = options.toArray(new WsdlOption[options.size()]);
        if (this.wsdlOptions.length == 0) {
            this.getLog().info((CharSequence)"Nothing to generate");
            return;
        }
        ArrayList<URL> urlList = new ArrayList<URL>();
        StringBuffer buf = new StringBuffer();
        try {
            urlList.add(classesDir.toURI().toURL());
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        buf.append(classesDir.getAbsolutePath());
        buf.append(File.pathSeparatorChar);
        List artifacts = this.useCompileClasspath ? this.project.getCompileArtifacts() : this.project.getTestArtifacts();
        for (Artifact a : CastUtils.cast((List)artifacts, Artifact.class)) {
            try {
                if (a.getFile() == null || !a.getFile().exists()) continue;
                urlList.add(a.getFile().toURI().toURL());
                buf.append(a.getFile().getAbsolutePath());
                buf.append(File.pathSeparatorChar);
            }
            catch (MalformedURLException e) {}
        }
        ClassLoader origContext = Thread.currentThread().getContextClassLoader();
        URLClassLoader loader = new URLClassLoader(urlList.toArray(new URL[urlList.size()]), origContext);
        String newCp = buf.toString();
        HashMap<Object, Object> origProps = new HashMap<Object, Object>(System.getProperties());
        String cp = System.getProperty("java.class.path");
        boolean result = true;
        try {
            Thread.currentThread().setContextClassLoader(loader);
            System.setProperty("java.class.path", newCp);
            for (WsdlOption o : this.wsdlOptions) {
                this.processWsdl(o);
                File[] dirs = o.getDeleteDirs();
                if (dirs == null) continue;
                for (int idx = 0; idx < dirs.length; ++idx) {
                    result = result && this.deleteDir(dirs[idx]);
                }
            }
            Object var19_20 = null;
        }
        catch (Throwable throwable) {
            Object var19_21 = null;
            Bus bus = BusFactory.getDefaultBus((boolean)false);
            if (bus != null) {
                bus.shutdown(true);
            }
            Thread.currentThread().setContextClassLoader(origContext);
            System.setProperty("java.class.path", cp);
            HashMap<Object, Object> newProps = new HashMap<Object, Object>(System.getProperties());
            for (Object o : newProps.keySet()) {
                if (origProps.containsKey(o)) continue;
                System.clearProperty(o.toString());
            }
            System.getProperties().putAll((Map<?, ?>)origProps);
            throw throwable;
        }
        Bus bus = BusFactory.getDefaultBus((boolean)false);
        if (bus != null) {
            bus.shutdown(true);
        }
        Thread.currentThread().setContextClassLoader(origContext);
        System.setProperty("java.class.path", cp);
        HashMap<Object, Object> newProps = new HashMap<Object, Object>(System.getProperties());
        for (Object o : newProps.keySet()) {
            if (origProps.containsKey(o)) continue;
            System.clearProperty(o.toString());
        }
        {
        }
        System.getProperties().putAll((Map<?, ?>)origProps);
        if (this.project != null && this.sourceRoot != null && this.sourceRoot.exists()) {
            this.project.addCompileSourceRoot(this.sourceRoot.getAbsolutePath());
        }
        if (this.project != null && this.testSourceRoot != null && this.testSourceRoot.exists()) {
            this.project.addTestCompileSourceRoot(this.testSourceRoot.getAbsolutePath());
        }
        System.gc();
    }

    private void processWsdl(WsdlOption wsdlOption) throws MojoExecutionException {
        File outputDirFile = wsdlOption.getOutputDir();
        outputDirFile.mkdirs();
        String wsdlLocation = wsdlOption.getWsdl();
        File wsdlFile = new File(wsdlLocation);
        URI basedir = this.project.getBasedir().toURI();
        URI wsdlURI = wsdlFile.exists() ? wsdlFile.toURI() : basedir.resolve(wsdlLocation);
        String doneFileName = wsdlURI.toString();
        if (doneFileName.startsWith(basedir.toString())) {
            doneFileName = doneFileName.substring(basedir.toString().length());
        }
        doneFileName = doneFileName.replace('?', '_').replace('&', '_').replace('/', '_').replace('\\', '_');
        File doneFile = new File(this.markerDirectory, "." + doneFileName + ".DONE");
        long timestamp = 0L;
        if ("file".equals(wsdlURI.getScheme())) {
            timestamp = new File(wsdlURI).lastModified();
        } else {
            try {
                timestamp = wsdlURI.toURL().openConnection().getDate();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        boolean doWork = false;
        if (!doneFile.exists()) {
            doWork = true;
        } else if (timestamp > doneFile.lastModified()) {
            doWork = true;
        } else if (this.isDefServiceName(wsdlOption)) {
            doWork = true;
        } else {
            File[] files = wsdlOption.getDependencies();
            if (files != null) {
                for (int z = 0; z < files.length; ++z) {
                    if (files[z].lastModified() <= doneFile.lastModified()) continue;
                    doWork = true;
                }
            }
        }
        if (doWork) {
            doneFile.delete();
            List<String> list = this.generateCommandLine(wsdlOption, outputDirFile, basedir, wsdlURI);
            this.getLog().debug((CharSequence)("Calling wsdl2java with args: " + list));
            try {
                new WSDLToJava(list.toArray(new String[list.size()])).run(new ToolContext());
            }
            catch (Throwable e) {
                this.getLog().debug(e);
                throw new MojoExecutionException(e.getMessage(), e);
            }
            try {
                doneFile.createNewFile();
            }
            catch (Throwable e) {
                this.getLog().warn((CharSequence)("Could not create marker file " + doneFile.getAbsolutePath()));
                this.getLog().debug(e);
            }
        }
    }

    private List<String> generateCommandLine(WsdlOption wsdlOption, File outputDirFile, URI basedir, URI wsdlURI) {
        Iterator<String> it;
        ArrayList<String> list = new ArrayList<String>();
        if (wsdlOption.getPackagenames() != null) {
            it = wsdlOption.getPackagenames().iterator();
            while (it.hasNext()) {
                list.add("-p");
                list.add(it.next().toString());
            }
        }
        if (wsdlOption.getNamespaceExcludes() != null) {
            it = wsdlOption.getNamespaceExcludes().iterator();
            while (it.hasNext()) {
                list.add("-nexclude");
                list.add(it.next().toString());
            }
        }
        if (this.getLog().isDebugEnabled()) {
            list.add("-verbose");
        }
        list.add("-d");
        list.add(outputDirFile.toString());
        for (String binding : wsdlOption.getBindingFiles()) {
            File bindingFile = new File(binding);
            URI bindingURI = bindingFile.exists() ? bindingFile.toURI() : basedir.resolve(binding);
            list.add("-b");
            list.add(bindingURI.toString());
        }
        if (wsdlOption.getFrontEnd() != null) {
            list.add("-fe");
            list.add(wsdlOption.getFrontEnd());
        }
        if (wsdlOption.getDataBinding() != null) {
            list.add("-db");
            list.add(wsdlOption.getDataBinding());
        }
        if (wsdlOption.getWsdlVersion() != null) {
            list.add("-wv");
            list.add(wsdlOption.getWsdlVersion());
        }
        if (wsdlOption.getCatalog() != null) {
            list.add("-catalog");
            list.add(wsdlOption.getCatalog());
        }
        if (wsdlOption.isExtendedSoapHeaders()) {
            list.add("-exsh");
        }
        if (wsdlOption.isValidateWsdl()) {
            list.add("-validate");
        }
        if (wsdlOption.getDefaultExcludesNamespace() != null) {
            list.add("-dex");
            list.add(wsdlOption.getDefaultExcludesNamespace().toString());
        }
        if (wsdlOption.getDefaultNamespacePackageMapping() != null) {
            list.add("-dns");
            list.add(wsdlOption.getDefaultNamespacePackageMapping().toString());
        }
        if (wsdlOption.getServiceName() != null) {
            list.add("-sn");
            list.add(wsdlOption.getServiceName());
        }
        if (wsdlOption.isAutoNameResolution()) {
            list.add("-autoNameResolution");
        }
        if (wsdlOption.isNoAddressBinding()) {
            list.add("-noAddressBinding");
        }
        if (wsdlOption.getExtraargs() != null) {
            for (String value : wsdlOption.getExtraargs()) {
                if (value == null) {
                    value = "";
                }
                list.add(value.toString());
            }
        }
        if (wsdlOption.isSetWsdlLocation()) {
            list.add("-wsdlLocation");
            list.add(wsdlOption.getWsdlLocation() == null ? "" : wsdlOption.getWsdlLocation());
        }
        list.add(wsdlURI.toString());
        return list;
    }

    private boolean deleteDir(File f) {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int idx = 0; idx < files.length; ++idx) {
                this.deleteDir(files[idx]);
            }
        }
        if (f.exists()) {
            return f.delete();
        }
        return true;
    }

    private boolean isDefServiceName(WsdlOption wsdlOption) {
        List args = wsdlOption.extraargs;
        if (args == null) {
            return false;
        }
        for (int i = 0; i < args.size(); ++i) {
            if (!"-sn".equalsIgnoreCase((String)args.get(i))) continue;
            return true;
        }
        return false;
    }
}

