/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.utils;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;

public class MessageDigestGenerator {
    private String algorithm = "MD5";

    public String generate(byte[] input) throws OAuthServiceException {
        if (input == null) {
            throw new OAuthServiceException("You have to pass input to Token Generator");
        }
        try {
            byte[] messageDigest = this.createDigest(input, this.algorithm);
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < messageDigest.length; ++i) {
                hexString.append(Integer.toHexString(0xFF & messageDigest[i]));
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new OAuthServiceException("server_error", (Throwable)e);
        }
    }

    public byte[] createDigest(String input, String algo) {
        try {
            return this.createDigest(input.getBytes("UTF-8"), algo);
        }
        catch (UnsupportedEncodingException e) {
            throw new OAuthServiceException("server_error", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new OAuthServiceException("server_error", (Throwable)e);
        }
    }

    public byte[] createDigest(byte[] input, String algo) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algo);
        md.reset();
        md.update(input);
        return md.digest();
    }

    public void setAlgorithm(String algo) {
        this.algorithm = algo;
    }
}

