/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.code;

import java.io.StringWriter;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.grants.AbstractGrantHandler;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeDataProvider;
import org.apache.cxf.rs.security.oauth2.grants.code.ServerAuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.utils.Base64UrlUtility;
import org.apache.cxf.rs.security.oauth2.utils.MessageDigestGenerator;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public class AuthorizationCodeGrantHandler
extends AbstractGrantHandler {
    public AuthorizationCodeGrantHandler() {
        super("authorization_code");
    }

    @Override
    public ServerAccessToken createAccessToken(Client client, MultivaluedMap<String, String> params) throws OAuthServiceException {
        String tempClientSecret;
        String codeValue = (String)params.getFirst((Object)"code");
        ServerAuthorizationCodeGrant grant = ((AuthorizationCodeDataProvider)this.getDataProvider()).removeCodeGrant(codeValue);
        if (grant == null) {
            return null;
        }
        if (OAuthUtils.isExpired(grant.getIssuedAt(), grant.getLifetime())) {
            throw new OAuthServiceException("invalid_grant");
        }
        if (!grant.getClient().getClientId().equals(client.getClientId())) {
            throw new OAuthServiceException("invalid_grant");
        }
        String expectedRedirectUri = grant.getRedirectUri();
        String providedRedirectUri = (String)params.getFirst((Object)"redirect_uri");
        if (providedRedirectUri != null ? expectedRedirectUri == null || !providedRedirectUri.equals(expectedRedirectUri) : expectedRedirectUri == null && !this.isCanSupportPublicClients() || expectedRedirectUri != null && (client.getRedirectUris().size() != 1 || !client.getRedirectUris().contains(expectedRedirectUri))) {
            throw new OAuthServiceException("invalid_request");
        }
        String tempClientSecretHash = grant.getTempClientSecretHash();
        if (tempClientSecretHash != null && !this.compareTcshWithTch(tempClientSecretHash, tempClientSecret = (String)params.getFirst((Object)"tcs"))) {
            throw new OAuthServiceException("invalid_grant");
        }
        return this.doCreateAccessToken(client, grant.getSubject(), grant.getApprovedScopes(), grant.getAudience());
    }

    private boolean compareTcshWithTch(String tempClientSecretHash, String tempClientSecret) {
        if (tempClientSecret == null) {
            return false;
        }
        MessageDigestGenerator mdg = new MessageDigestGenerator();
        byte[] digest = mdg.createDigest(tempClientSecret, "SHA-256");
        int length = digest.length > 16 ? 16 : digest.length;
        StringWriter stringWriter = new StringWriter();
        try {
            Base64UrlUtility.encode(digest, 0, length, stringWriter);
        }
        catch (Base64Exception e) {
            throw new OAuthServiceException("server_error", (Throwable)e);
        }
        String expectedHash = stringWriter.toString();
        return tempClientSecretHash.equals(expectedHash);
    }
}

