/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm.soap;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.BareInInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.soap.MAPCodec;
import org.apache.cxf.ws.rm.AbstractRMInterceptor;
import org.apache.cxf.ws.rm.EncoderDecoder;
import org.apache.cxf.ws.rm.ProtocolVariation;
import org.apache.cxf.ws.rm.RM10Constants;
import org.apache.cxf.ws.rm.RM11Constants;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.v200702.AckRequestedType;
import org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RMSoapInterceptor
extends AbstractSoapInterceptor {
    protected static JAXBContext jaxbContext;
    private static final Set<QName> HEADERS;
    private static final Logger LOG;

    public RMSoapInterceptor() {
        super("pre-protocol");
        this.addAfter(MAPCodec.class.getName());
    }

    @Override
    public Set<QName> getUnderstoodHeaders() {
        return HEADERS;
    }

    @Override
    public void handleMessage(SoapMessage message) throws Fault {
        this.mediate(message);
    }

    void mediate(SoapMessage message) {
        if (MessageUtils.isOutbound(message)) {
            this.encode(message);
        } else {
            this.decode(message);
            this.updateServiceModelInfo(message);
        }
    }

    void encode(SoapMessage message) {
        Exception ex;
        RMProperties rmps = RMContextUtils.retrieveRMProperties(message, true);
        if (null != rmps) {
            RMSoapInterceptor.encode(message, rmps);
        } else if (MessageUtils.isFault(message) && (ex = message.getContent(Exception.class)) instanceof SoapFault && ex.getCause() instanceof SequenceFault) {
            RMSoapInterceptor.encodeFault(message, (SequenceFault)ex.getCause());
        }
    }

    public static void encode(SoapMessage message, RMProperties rmps) {
        if (null == rmps) {
            return;
        }
        LOG.log(Level.FINE, "encoding RMPs in SOAP headers");
        try {
            List<Header> headers = message.getHeaders();
            RMSoapInterceptor.discardRMHeaders(headers);
            AddressingProperties maps = RMContextUtils.retrieveMAPs(message, false, true);
            ProtocolVariation protocol = ProtocolVariation.findVariant(rmps.getNamespaceURI(), maps.getNamespaceURI());
            Element header = protocol.getCodec().buildHeaders(rmps, Soap11.getInstance().getHeader());
            Node node = header.getFirstChild();
            if (node != null && MessageUtils.isPartialResponse(message)) {
                message.put(Message.RESPONSE_CODE, (Object)200);
            }
            while (node != null) {
                Header holder = null;
                if (node.getLocalName().equals("Sequence")) {
                    holder = new SoapHeader(new QName(node.getNamespaceURI(), node.getLocalName()), node);
                    ((SoapHeader)holder).setMustUnderstand(true);
                } else {
                    holder = new Header(new QName(node.getNamespaceURI(), node.getLocalName()), node);
                }
                headers.add(holder);
                node = node.getNextSibling();
            }
        }
        catch (JAXBException je) {
            LOG.log(Level.WARNING, "SOAP_HEADER_ENCODE_FAILURE_MSG", je);
        }
    }

    public static void encodeFault(SoapMessage message, SequenceFault sf) {
        LOG.log(Level.FINE, "Encoding SequenceFault in SOAP header");
        try {
            List<Header> headers = message.getHeaders();
            RMSoapInterceptor.discardRMHeaders(headers);
            Message inmsg = message.getExchange().getInMessage();
            RMProperties rmps = RMContextUtils.retrieveRMProperties(inmsg, false);
            AddressingProperties maps = RMContextUtils.retrieveMAPs(inmsg, false, false);
            ProtocolVariation protocol = ProtocolVariation.findVariant(rmps.getNamespaceURI(), maps.getNamespaceURI());
            Element header = protocol.getCodec().buildHeaderFault(sf, Soap11.getInstance().getHeader());
            Node node = header.getFirstChild();
            if (node instanceof Element) {
                Attr attr = header.getOwnerDocument().createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsrm");
                attr.setValue(rmps.getNamespaceURI());
                ((Element)node).setAttributeNodeNS(attr);
            }
            headers.add(new Header(new QName(node.getNamespaceURI(), node.getLocalName()), node));
        }
        catch (JAXBException je) {
            LOG.log(Level.WARNING, "SOAP_HEADER_ENCODE_FAILURE_MSG", je);
        }
    }

    void decode(SoapMessage message) {
        RMProperties rmps = this.unmarshalRMProperties(message);
        RMContextUtils.storeRMProperties(message, rmps, false);
    }

    public RMProperties unmarshalRMProperties(SoapMessage message) {
        RMProperties rmps = new RMProperties();
        List<Header> headers = message.getHeaders();
        if (headers != null) {
            this.decodeHeaders(message, headers, rmps);
        }
        return rmps;
    }

    public void decodeHeaders(SoapMessage message, List<Header> headers, RMProperties rmps) {
        try {
            ArrayList<SequenceAcknowledgement> acks = new ArrayList<SequenceAcknowledgement>();
            ArrayList<AckRequestedType> requested = new ArrayList<AckRequestedType>();
            String rmUri = null;
            EncoderDecoder codec = null;
            Iterator<Header> iter = headers.iterator();
            while (iter.hasNext()) {
                Element elem;
                Object node = iter.next().getObject();
                if (!(node instanceof Element) || 1 != (elem = (Element)node).getNodeType()) continue;
                String ns = elem.getNamespaceURI();
                if (rmUri == null && ("http://schemas.xmlsoap.org/ws/2005/02/rm".equals(ns) || "http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(ns))) {
                    LOG.log(Level.FINE, "set RM namespace {0}", ns);
                    rmUri = ns;
                    rmps.exposeAs(rmUri);
                }
                if (rmUri == null || !rmUri.equals(ns)) continue;
                if (codec == null) {
                    String wsauri = null;
                    AddressingProperties maps = ContextUtils.retrieveMAPs(message, false, false, false);
                    wsauri = maps == null ? this.getManager(message).getAddressingNamespace(message) : maps.getNamespaceURI();
                    ProtocolVariation protocol = ProtocolVariation.findVariant(rmUri, wsauri);
                    if (protocol == null) {
                        LOG.log(Level.WARNING, "NAMESPACE_ERROR_MSG", wsauri);
                        break;
                    }
                    codec = protocol.getCodec();
                }
                String localName = elem.getLocalName();
                LOG.log(Level.FINE, "decoding RM header {0}", localName);
                if ("Sequence".equals(localName)) {
                    rmps.setSequence(codec.decodeSequenceType(elem));
                    rmps.setCloseSequence(codec.decodeSequenceTypeCloseSequence(elem));
                    continue;
                }
                if ("SequenceAcknowledgement".equals(localName)) {
                    acks.add(codec.decodeSequenceAcknowledgement(elem));
                    continue;
                }
                if (!"AckRequested".equals(localName)) continue;
                requested.add(codec.decodeAckRequestedType(elem));
            }
            if (acks.size() > 0) {
                rmps.setAcks(acks);
            }
            if (requested.size() > 0) {
                rmps.setAcksRequested(requested);
            }
        }
        catch (JAXBException ex) {
            LOG.log(Level.WARNING, "SOAP_HEADER_DECODE_FAILURE_MSG", ex);
        }
    }

    private static void discardRMHeaders(List<Header> header) {
        Iterator<Header> iter = header.iterator();
        while (iter.hasNext()) {
            Header hdr = iter.next();
            String uri = hdr.getName().getNamespaceURI();
            if (!"http://schemas.xmlsoap.org/ws/2005/02/rm".equals(uri) && !"http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(uri)) continue;
            iter.remove();
        }
    }

    private void updateServiceModelInfo(SoapMessage message) throws Fault {
        RMConstants consts;
        AddressingProperties maps = ContextUtils.retrieveMAPs(message, false, false, false);
        AttributedURIType actionURI = null == maps ? null : maps.getAction();
        String action = null == actionURI ? null : actionURI.getValue().trim();
        LOG.fine("action: " + action);
        if (RM10Constants.ACTIONS.contains(action)) {
            consts = RM10Constants.INSTANCE;
        } else if (RM11Constants.ACTIONS.contains(action)) {
            consts = RM11Constants.INSTANCE;
        } else {
            return;
        }
        RMProperties rmps = RMContextUtils.retrieveRMProperties(message, false);
        rmps.exposeAs(consts.getWSRMNamespace());
        ProtocolVariation protocol = ProtocolVariation.findVariant(consts.getWSRMNamespace(), maps.getNamespaceURI());
        LOG.info("Updating service model info in exchange");
        RMManager manager = this.getManager(message);
        assert (manager != null);
        RMEndpoint rme = null;
        try {
            rme = manager.getReliableEndpoint(message);
        }
        catch (RMException e) {
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("CANNOT_PROCESS", LOG, new Object[0]), (Throwable)e, message.getVersion().getSender());
        }
        Exchange exchange = message.getExchange();
        Endpoint ep = rme.getEndpoint(protocol);
        exchange.put(Endpoint.class, ep);
        exchange.put(Service.class, ep.getService());
        exchange.put(Binding.class, ep.getBinding());
        BindingInfo bi = ep.getEndpointInfo().getBinding();
        BindingOperationInfo boi = null;
        boolean isOneway = true;
        if (consts.getCreateSequenceAction().equals(action)) {
            if (RMContextUtils.isServerSide(message)) {
                boi = bi.getOperation(consts.getCreateSequenceOperationName());
                isOneway = false;
            } else {
                boi = bi.getOperation(consts.getCreateSequenceOnewayOperationName());
            }
        } else if (consts.getCreateSequenceResponseAction().equals(action)) {
            if (RMContextUtils.isServerSide(message)) {
                boi = bi.getOperation(consts.getCreateSequenceResponseOnewayOperationName());
            } else {
                boi = bi.getOperation(consts.getCreateSequenceOperationName());
                isOneway = false;
            }
        } else if (consts.getSequenceAckAction().equals(action)) {
            boi = bi.getOperation(consts.getSequenceAckOperationName());
        } else if (consts.getTerminateSequenceAction().equals(action)) {
            boi = bi.getOperation(consts.getTerminateSequenceOperationName());
        } else if (RM11Constants.INSTANCE.getTerminateSequenceResponseAction().equals(action)) {
            boi = bi.getOperation(RM11Constants.INSTANCE.getTerminateSequenceOperationName());
            isOneway = false;
        } else if (consts.getCloseSequenceAction().equals(action)) {
            boi = bi.getOperation(consts.getCloseSequenceOperationName());
        }
        assert (boi != null);
        exchange.put(BindingOperationInfo.class, boi);
        exchange.put(OperationInfo.class, boi.getOperationInfo());
        exchange.setOneWay(isOneway);
        if (!consts.getCreateSequenceResponseAction().equals(action) && !RM11Constants.INSTANCE.getTerminateSequenceResponseAction().equals(action)) {
            LOG.fine("Changing requestor role from " + message.get("org.apache.cxf.client") + " to false");
            Object originalRequestorRole = message.get("org.apache.cxf.client");
            if (null != originalRequestorRole) {
                message.put("org.apache.cxf.client.original", originalRequestorRole);
            }
            message.put("org.apache.cxf.client", (Object)Boolean.FALSE);
        }
        InterceptorChain chain = message.getInterceptorChain();
        ListIterator<Interceptor<? extends Message>> it = chain.getIterator();
        boolean bareIn = false;
        boolean wrappedIn = false;
        while (it.hasNext() && !wrappedIn && !bareIn) {
            PhaseInterceptor pi = (PhaseInterceptor)it.next();
            if (!BareInInterceptor.class.getName().equals(pi.getId())) continue;
            bareIn = true;
        }
        if (!bareIn) {
            chain.add(new BareInInterceptor());
            LOG.fine("Added BareInInterceptor to chain.");
        }
    }

    private RMManager getManager(SoapMessage message) {
        InterceptorChain chain = message.getInterceptorChain();
        ListIterator<Interceptor<? extends Message>> it = chain.getIterator();
        while (it.hasNext()) {
            Interceptor<? extends Message> i = it.next();
            if (!(i instanceof AbstractRMInterceptor)) continue;
            return ((AbstractRMInterceptor)i).getManager();
        }
        return null;
    }

    static {
        HashSet<QName> set = new HashSet<QName>();
        set.addAll(RM10Constants.HEADERS);
        set.addAll(RM11Constants.HEADERS);
        HEADERS = set;
        LOG = LogUtils.getL7dLogger(RMSoapInterceptor.class);
    }
}

