/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.resource.URIResolver;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.toolspec.ToolSpec;
import org.apache.cxf.tools.wsdlto.WSDLToJavaContainer;

public class JAXWSContainer
extends WSDLToJavaContainer {
    private static final String TOOL_NAME = "wsdl2java";

    public JAXWSContainer(ToolSpec toolspec) throws Exception {
        super(TOOL_NAME, toolspec);
    }

    @Override
    public Set<String> getArrayKeys() {
        Set<String> set = super.getArrayKeys();
        set.add("binding");
        set.add("reserveClass");
        set.add("asyncMethods");
        set.add("bareMethods");
        set.add("mimeMethods");
        return set;
    }

    @Override
    public void validate(ToolContext env) throws ToolException {
        super.validate(env);
        if (env.containsKey("binding")) {
            String[] bindings = (String[])env.get("binding");
            URIResolver resolver = null;
            for (int i = 0; i < bindings.length; ++i) {
                try {
                    resolver = new URIResolver(bindings[i]);
                }
                catch (IOException ioe) {
                    throw new ToolException(ioe);
                }
                if (resolver.isResolved()) continue;
                Message msg = new Message("FILE_NOT_EXIST", LOG, bindings[i]);
                throw new ToolException(msg);
            }
            env.put("binding", bindings);
        }
        this.cleanArrays(env, "asyncMethods");
        this.cleanArrays(env, "bareMethods");
        this.cleanArrays(env, "mimeMethods");
    }

    private void cleanArrays(ToolContext env, String key) {
        String[] s = env.getArray(key);
        if (s != null) {
            ArrayList<String> n = new ArrayList<String>();
            for (String s2 : s) {
                StringTokenizer tokenizer = new StringTokenizer(s2, ",=", false);
                while (tokenizer.hasMoreTokens()) {
                    String arg = tokenizer.nextToken();
                    n.add(arg);
                }
            }
            env.put(key, n.toArray(new String[n.size()]));
        }
    }
}

