/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.AlgorithmSuite;
import org.apache.cxf.ws.security.policy.model.Binding;
import org.apache.cxf.ws.security.policy.model.SamlToken;
import org.apache.cxf.ws.security.policy.model.SupportingToken;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;

public final class AlgorithmSuiteTranslater {
    public void translateAlgorithmSuites(AssertionInfoMap aim, RequestData data) throws WSSecurityException {
        Collection ais;
        if (aim == null) {
            return;
        }
        List<AlgorithmSuite> algorithmSuites = this.getAlgorithmSuites(this.getBindings(aim));
        if (!algorithmSuites.isEmpty()) {
            org.apache.ws.security.components.crypto.AlgorithmSuite algorithmSuite = this.translateAlgorithmSuites(algorithmSuites);
            data.setAlgorithmSuite(algorithmSuite);
        }
        if ((ais = (Collection)aim.get(SP12Constants.SAML_TOKEN)) != null && !ais.isEmpty()) {
            ArrayList<AlgorithmSuite> samlAlgorithmSuites = new ArrayList<AlgorithmSuite>();
            for (AssertionInfo ai : ais) {
                SamlToken samlToken = (SamlToken)ai.getAssertion();
                SupportingToken supportingToken = samlToken.getSupportingToken();
                if (supportingToken == null || supportingToken.getAlgorithmSuite() == null) continue;
                samlAlgorithmSuites.add(supportingToken.getAlgorithmSuite());
            }
            if (!samlAlgorithmSuites.isEmpty()) {
                data.setSamlAlgorithmSuite(this.translateAlgorithmSuites(samlAlgorithmSuites));
            }
        }
    }

    private org.apache.ws.security.components.crypto.AlgorithmSuite translateAlgorithmSuites(List<AlgorithmSuite> algorithmSuites) {
        org.apache.ws.security.components.crypto.AlgorithmSuite algorithmSuite = null;
        for (AlgorithmSuite cxfAlgorithmSuite : algorithmSuites) {
            if (cxfAlgorithmSuite == null) continue;
            if (algorithmSuite == null) {
                algorithmSuite = new org.apache.ws.security.components.crypto.AlgorithmSuite();
            }
            if (algorithmSuite.getMaximumAsymmetricKeyLength() < cxfAlgorithmSuite.getMaximumAsymmetricKeyLength()) {
                algorithmSuite.setMaximumAsymmetricKeyLength(cxfAlgorithmSuite.getMaximumAsymmetricKeyLength());
            }
            if (algorithmSuite.getMinimumAsymmetricKeyLength() > cxfAlgorithmSuite.getMinimumAsymmetricKeyLength()) {
                algorithmSuite.setMinimumAsymmetricKeyLength(cxfAlgorithmSuite.getMinimumAsymmetricKeyLength());
            }
            if (algorithmSuite.getMaximumSymmetricKeyLength() < cxfAlgorithmSuite.getMaximumSymmetricKeyLength()) {
                algorithmSuite.setMaximumSymmetricKeyLength(cxfAlgorithmSuite.getMaximumSymmetricKeyLength());
            }
            if (algorithmSuite.getMinimumSymmetricKeyLength() > cxfAlgorithmSuite.getMinimumSymmetricKeyLength()) {
                algorithmSuite.setMinimumSymmetricKeyLength(cxfAlgorithmSuite.getMinimumSymmetricKeyLength());
            }
            algorithmSuite.addEncryptionMethod(cxfAlgorithmSuite.getEncryption());
            algorithmSuite.addKeyWrapAlgorithm(cxfAlgorithmSuite.getSymmetricKeyWrap());
            algorithmSuite.addKeyWrapAlgorithm(cxfAlgorithmSuite.getAsymmetricKeyWrap());
            algorithmSuite.addSignatureMethod(cxfAlgorithmSuite.getAsymmetricSignature());
            algorithmSuite.addSignatureMethod(cxfAlgorithmSuite.getSymmetricSignature());
            algorithmSuite.addDigestAlgorithm(cxfAlgorithmSuite.getDigest());
            algorithmSuite.addC14nAlgorithm(cxfAlgorithmSuite.getInclusiveC14n());
            algorithmSuite.addTransformAlgorithm(cxfAlgorithmSuite.getInclusiveC14n());
            algorithmSuite.addTransformAlgorithm("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform");
            algorithmSuite.addTransformAlgorithm("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
            algorithmSuite.addDerivedKeyAlgorithm("http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1");
            algorithmSuite.addDerivedKeyAlgorithm("http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1");
        }
        return algorithmSuite;
    }

    private List<Binding> getBindings(AssertionInfoMap aim) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        if (aim != null) {
            Collection ais = (Collection)aim.get(SP12Constants.TRANSPORT_BINDING);
            if (ais != null && !ais.isEmpty()) {
                for (AssertionInfo ai : ais) {
                    bindings.add((Binding)ai.getAssertion());
                }
            }
            if ((ais = (Collection)aim.get(SP12Constants.ASYMMETRIC_BINDING)) != null && !ais.isEmpty()) {
                for (AssertionInfo ai : ais) {
                    bindings.add((Binding)ai.getAssertion());
                }
            }
            if ((ais = (Collection)aim.get(SP12Constants.SYMMETRIC_BINDING)) != null && !ais.isEmpty()) {
                for (AssertionInfo ai : ais) {
                    bindings.add((Binding)ai.getAssertion());
                }
            }
        }
        return bindings;
    }

    private List<AlgorithmSuite> getAlgorithmSuites(List<Binding> bindings) {
        ArrayList<AlgorithmSuite> algorithmSuites = new ArrayList<AlgorithmSuite>();
        for (Binding binding : bindings) {
            if (binding.getAlgorithmSuite() == null) continue;
            algorithmSuites.add(binding.getAlgorithmSuite());
        }
        return algorithmSuites;
    }
}

