/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.SecurityContextToken;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Element;

public class SecurityContextTokenBuilder
implements AssertionBuilder<Element> {
    public QName[] getKnownElements() {
        return new QName[]{SP11Constants.SECURITY_CONTEXT_TOKEN, SP12Constants.SECURITY_CONTEXT_TOKEN};
    }

    public Assertion build(Element element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        SecurityContextToken contextToken = new SecurityContextToken(consts);
        String includeAttr = DOMUtils.getAttribute(element, consts.getIncludeToken());
        if (includeAttr != null) {
            contextToken.setInclusion(consts.getInclusionFromAttributeValue(includeAttr));
        }
        if ((element = PolicyConstants.findPolicyElement(element)) == null && consts != SP11Constants.INSTANCE) {
            throw new IllegalArgumentException("sp:SecurityContextToken/wsp:Policy must have a value");
        }
        if (element != null) {
            if (DOMUtils.getFirstChildWithName(element, consts.getNamespace(), "RequireDerivedKeys") != null) {
                contextToken.setDerivedKeys(true);
            }
            if (DOMUtils.getFirstChildWithName(element, consts.getNamespace(), "RequireExternalUriReference") != null) {
                contextToken.setRequireExternalUriRef(true);
            }
            if (DOMUtils.getFirstChildWithName(element, consts.getNamespace(), "SC10SecurityContextToken") != null) {
                contextToken.setSc10SecurityContextToken(true);
            }
            if (DOMUtils.getFirstChildWithName(element, consts.getNamespace(), "SC13SecurityContextToken") != null) {
                contextToken.setSc13SecurityContextToken(true);
            }
        }
        return contextToken;
    }
}

