/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.object;

import java.util.HashSet;
import java.util.Set;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.transport.local.LocalConduit;
import org.apache.cxf.transport.local.LocalTransportFactory;

public class ObjectDispatchOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private Set<String> includes = new HashSet<String>();

    public ObjectDispatchOutInterceptor() {
        super("setup");
        this.includes.add("objectBinding.operationName");
        this.includes.add("objectBinding.bindingName");
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        Exchange ex = message.getExchange();
        message.put(LocalConduit.DIRECT_DISPATCH, Boolean.TRUE);
        message.put(LocalTransportFactory.MESSAGE_INCLUDE_PROPERTIES, this.includes);
        BindingOperationInfo bop = ex.get(BindingOperationInfo.class);
        message.put("objectBinding.operationName", bop.getName());
        message.put("objectBinding.bindingName", bop.getBinding().getName());
    }
}

