/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.HashSet;
import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.management.ManagedComponent;
import org.apache.cxf.management.annotation.ManagedAttribute;
import org.apache.cxf.management.annotation.ManagedOperation;
import org.apache.cxf.management.annotation.ManagedResource;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.RMUtils;

@ManagedResource(componentName="RMManager", description="Responsible for managing RMEndpoints.")
public class ManagedRMManager
implements ManagedComponent {
    private RMManager manager;

    public ManagedRMManager(RMManager manager) {
        this.manager = manager;
    }

    @Override
    public ObjectName getObjectName() throws JMException {
        return RMUtils.getManagedObjectName(this.manager);
    }

    @ManagedOperation
    public void shutdown() {
        this.manager.shutdown();
    }

    @ManagedOperation
    public String[] getEndpointIdentifiers() {
        HashSet<String> identifiers = new HashSet<String>();
        for (Endpoint ep : this.manager.getReliableEndpointsMap().keySet()) {
            identifiers.add(RMUtils.getEndpointIdentifier(ep, this.manager.getBus()));
        }
        return identifiers.toArray(new String[identifiers.size()]);
    }

    @ManagedAttribute(description="Using Store")
    public boolean isUsingStore() {
        return this.manager.getStore() != null;
    }

    @ManagedAttribute(description="Total Number of Outbound Queued Messages", currencyTimeLimit=10)
    public int getQueuedMessagesOutboundCount() {
        return this.manager.getRetransmissionQueue().countUnacknowledged();
    }
}

