/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.MAPAggregator;
import org.apache.cxf.ws.rm.AbstractRMInterceptor;
import org.apache.cxf.ws.rm.AbstractSequence;
import org.apache.cxf.ws.rm.Destination;
import org.apache.cxf.ws.rm.DestinationSequence;
import org.apache.cxf.ws.rm.ProtocolVariation;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.RetransmissionInterceptor;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.Source;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement;
import org.apache.cxf.ws.rm.v200702.TerminateSequenceType;

public class RMOutInterceptor
extends AbstractRMInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(RMOutInterceptor.class);

    public RMOutInterceptor() {
        this.addAfter(MAPAggregator.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handle(Message msg) throws SequenceFault, RMException {
        SourceSequence ss;
        Collection<SequenceAcknowledgement> acks;
        RMProperties rmpsOut;
        AddressingProperties maps = ContextUtils.retrieveMAPs(msg, false, true, false);
        if (null == maps) {
            LogUtils.log(LOG, Level.WARNING, "MAPS_RETRIEVAL_FAILURE_MSG");
            return;
        }
        String rmUri = this.getManager().getRMNamespace(msg);
        String addrUri = this.getManager().getAddressingNamespace(msg);
        if (this.isRuntimeFault(msg)) {
            LogUtils.log(LOG, Level.WARNING, "RUNTIME_FAULT_MSG");
            Throwable cause = msg.getContent(Exception.class).getCause();
            if (cause instanceof SequenceFault || cause instanceof RMException) {
                maps.getAction().setValue("http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(rmUri) ? "http://docs.oasis-open.org/ws-rx/wsrm/200702/fault" : addrUri + "/fault");
            }
            return;
        }
        Source source = this.getManager().getSource(msg);
        ProtocolVariation protocol = ProtocolVariation.findVariant(rmUri, addrUri);
        RMContextUtils.setProtocolVariation(msg, protocol);
        maps.exposeAs(protocol.getWSANamespace());
        Destination destination = this.getManager().getDestination(msg);
        String action = null;
        if (null != maps.getAction()) {
            action = maps.getAction().getValue();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Action: " + action);
        }
        boolean isApplicationMessage = !RMContextUtils.isRMProtocolMessage(action);
        boolean isPartialResponse = MessageUtils.isPartialResponse(msg);
        RMConstants constants = protocol.getConstants();
        boolean isLastMessage = constants.getCloseSequenceAction().equals(action);
        if (isApplicationMessage && !isPartialResponse) {
            RetransmissionInterceptor ri = new RetransmissionInterceptor();
            ri.setManager(this.getManager());
            msg.getInterceptorChain().add(ri);
            LOG.fine("Added RetransmissionInterceptor to chain.");
            this.getManager().getRetransmissionQueue().start();
        }
        if (null == (rmpsOut = RMContextUtils.retrieveRMProperties(msg, true))) {
            rmpsOut = new RMProperties();
            rmpsOut.exposeAs(protocol.getWSRMNamespace());
            RMContextUtils.storeRMProperties(msg, rmpsOut, true);
        }
        if (msg.getExchange().isOneWay()) {
            msg.getExchange().put("org.apache.cxf.transport.processOneWayResponse", true);
        }
        RMProperties rmpsIn = null;
        Identifier inSeqId = null;
        long inMessageNumber = 0L;
        if (isApplicationMessage) {
            rmpsIn = RMContextUtils.retrieveRMProperties(msg, false);
            if (null != rmpsIn && null != rmpsIn.getSequence()) {
                inSeqId = rmpsIn.getSequence().getIdentifier();
                inMessageNumber = rmpsIn.getSequence().getMessageNumber();
            }
            ContextUtils.storeDeferUncorrelatedMessageAbort(msg);
        }
        if ((isApplicationMessage || isLastMessage) && !isPartialResponse) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("inbound sequence: " + (null == inSeqId ? "null" : inSeqId.getValue()));
            }
            Source source2 = source;
            synchronized (source2) {
                SourceSequence seq = null;
                if (isLastMessage) {
                    Map invocationContext = (Map)msg.get("org.apache.cxf.invocation.context");
                    seq = (SourceSequence)invocationContext.get(SourceSequence.class.getName());
                } else {
                    seq = this.getManager().getSequence(inSeqId, msg, maps);
                }
                assert (null != seq);
                seq.nextMessageNumber(inSeqId, inMessageNumber, isLastMessage);
                if (Boolean.TRUE.equals(msg.getContextualProperty("org.apache.cxf.ws.rm.last-message"))) {
                    seq.setLastMessage(true);
                }
                rmpsOut.setSequence(seq);
                if (seq.isLastMessage()) {
                    source.setCurrent(null);
                }
            }
        } else if (!MessageUtils.isRequestor(msg) && constants.getCreateSequenceAction().equals(action)) {
            maps.getAction().setValue(constants.getCreateSequenceResponseAction());
        } else if (isPartialResponse && action == null && this.isResponseToAction(msg, constants.getSequenceAckAction()) && (acks = rmpsIn.getAcks()).size() == 1 && (ss = source.getSequence(acks.iterator().next().getIdentifier())) != null && ss.allAcknowledged()) {
            RMOutInterceptor.setAction(maps, constants.getTerminateSequenceAction());
            this.setTerminateSequence(msg, ss.getIdentifier(), protocol);
            msg.remove("org.apache.cxf.partial.response.empty");
            source.removeSequence(ss);
        }
        if (isApplicationMessage || constants.getSequenceAckAction().equals(action)) {
            AttributedURIType to = maps.getTo();
            assert (null != to);
            this.addAcknowledgements(destination, rmpsOut, inSeqId, to);
            if (isPartialResponse && rmpsOut.getAcks() != null && rmpsOut.getAcks().size() > 0) {
                RMOutInterceptor.setAction(maps, constants.getSequenceAckAction());
                msg.remove("org.apache.cxf.partial.response.empty");
            }
        }
        if (constants.getSequenceAckAction().equals(action) || constants.getTerminateSequenceAction().equals(action) && "http://schemas.xmlsoap.org/ws/2005/02/rm".equals(rmUri)) {
            maps.setReplyTo(RMUtils.createNoneReference());
        }
        this.assertReliability(msg);
    }

    void addAcknowledgements(Destination destination, RMProperties rmpsOut, Identifier inSeqId, AttributedURIType to) {
        for (DestinationSequence seq : destination.getAllSequences()) {
            if (!seq.sendAcknowledgement()) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("no need to add acknowledgements for sequence " + seq.getIdentifier().getValue());
                continue;
            }
            String address = seq.getAcksTo().getAddress().getValue();
            if (!to.getValue().equals(address)) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("sequences acksTo address (" + address + ") does not match to address (" + to.getValue() + ")");
                continue;
            }
            if (RMUtils.getAddressingConstants().getAnonymousURI().equals(address) && !AbstractSequence.identifierEquals(seq.getIdentifier(), inSeqId)) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("sequence identifier does not match inbound sequence identifier");
                continue;
            }
            rmpsOut.addAck(seq);
        }
        if (LOG.isLoggable(Level.FINE)) {
            Collection<SequenceAcknowledgement> acks = rmpsOut.getAcks();
            if (null == acks) {
                LOG.fine("No acknowledgements added.");
            } else {
                LOG.fine("Added " + acks.size() + " acknowledgements.");
            }
        }
    }

    boolean isRuntimeFault(Message message) {
        FaultMode mode = MessageUtils.getFaultMode(message);
        if (null == mode) {
            return false;
        }
        return FaultMode.CHECKED_APPLICATION_FAULT != mode;
    }

    private boolean isResponseToAction(Message msg, String action) {
        AddressingProperties inMaps = RMContextUtils.retrieveMAPs(msg, false, false);
        String inAction = null;
        if (null != inMaps.getAction()) {
            inAction = inMaps.getAction().getValue();
        }
        return action.equals(inAction);
    }

    private void setTerminateSequence(Message msg, Identifier identifier, ProtocolVariation protocol) throws RMException {
        TerminateSequenceType ts = new TerminateSequenceType();
        ts.setIdentifier(identifier);
        MessageContentsList contents = new MessageContentsList(protocol.getCodec().convertToSend(ts));
        msg.setContent(List.class, contents);
        ExchangeImpl newex = new ExchangeImpl();
        Exchange oldex = msg.getExchange();
        newex.put(Bus.class, oldex.getBus());
        newex.put(Endpoint.class, oldex.getEndpoint());
        newex.put(Service.class, oldex.getEndpoint().getService());
        newex.put(Binding.class, oldex.getEndpoint().getBinding());
        newex.setConduit(oldex.getConduit(msg));
        newex.setDestination(oldex.getDestination());
        RMEndpoint rmep = this.getManager().getReliableEndpoint(msg);
        OperationInfo oi = rmep.getEndpoint(protocol).getEndpointInfo().getService().getInterface().getOperation(protocol.getConstants().getTerminateSequenceAnonymousOperationName());
        BindingInfo bi = rmep.getBindingInfo(protocol);
        BindingOperationInfo boi = bi.getOperation(oi);
        newex.put(BindingInfo.class, bi);
        newex.put(BindingOperationInfo.class, boi);
        newex.put(OperationInfo.class, boi.getOperationInfo());
        msg.setExchange(newex);
        newex.setOutMessage(msg);
    }

    private static void setAction(AddressingProperties maps, String action) {
        AttributedURIType actionURI = new AttributedURIType();
        actionURI.setValue(action);
        maps.setAction(actionURI);
    }
}

