/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.generators;

import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.common.model.JavaPort;
import org.apache.cxf.tools.common.model.JavaServiceClass;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.util.NameUtil;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.generators.AbstractJAXWSGenerator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.WSDLToJavaProcessor;

public class ServerGenerator
extends AbstractJAXWSGenerator {
    private static final String SRV_TEMPLATE = "org/apache/cxf/tools/wsdlto/frontend/jaxws/template/server.vm";

    public ServerGenerator() {
        this.name = "svr.generator";
    }

    @Override
    public boolean passthrough() {
        if (this.env.optionSet("genServer") || this.env.optionSet("server") || this.env.optionSet("all")) {
            return false;
        }
        if (this.env.optionSet("genAnt") || this.env.optionSet("genTypes") || this.env.optionSet("genClient") || this.env.optionSet("genImpl") || this.env.optionSet("genSEI") || this.env.optionSet("genService") || this.env.optionSet("genFault")) {
            return true;
        }
        return true;
    }

    @Override
    public void generate(ToolContext penv) throws ToolException {
        this.env = penv;
        if (this.passthrough()) {
            return;
        }
        Map map = CastUtils.cast((Map)penv.get(WSDLToJavaProcessor.MODEL_MAP));
        for (JavaModel javaModel : map.values()) {
            String address = "CHANGE_ME";
            Map<String, JavaInterface> interfaces = javaModel.getInterfaces();
            if (javaModel.getServiceClasses().size() == 0) {
                ServiceInfo serviceInfo = this.env.get(ServiceInfo.class);
                String wsdl = serviceInfo.getDescription().getBaseURI();
                Message msg = new Message("CAN_NOT_GEN_SRV", LOG, wsdl);
                if (penv.isVerbose()) {
                    System.out.println(msg.toString());
                }
                return;
            }
            for (JavaServiceClass js : javaModel.getServiceClasses().values()) {
                for (JavaPort jp : js.getPorts()) {
                    String interfaceName = jp.getInterfaceClass();
                    JavaInterface intf = interfaces.get(interfaceName);
                    if (intf == null) {
                        interfaceName = jp.getPortType();
                        intf = interfaces.get(interfaceName);
                    }
                    address = StringUtils.isEmpty(jp.getBindingAdress()) ? address : jp.getBindingAdress();
                    String serverClassName = interfaceName + "_" + NameUtil.mangleNameToClassName(jp.getPortName()) + "_Server";
                    serverClassName = this.mapClassName(intf.getPackageName(), serverClassName, penv);
                    this.clearAttributes();
                    this.setAttributes("serverClassName", serverClassName);
                    this.setAttributes("intf", intf);
                    String name = this.getImplName(jp.getPortName(), js.getServiceName(), intf, penv);
                    this.setAttributes("impl", name);
                    this.setAttributes("address", address);
                    this.setCommonAttributes();
                    this.doWrite(SRV_TEMPLATE, this.parseOutputName(intf.getPackageName(), serverClassName));
                }
            }
        }
    }

    private String getImplName(String port, String service, JavaInterface intf, ToolContext penv) {
        String name;
        Map nm = CastUtils.cast((Map)penv.get("implClass"));
        if (nm == null) {
            nm = new HashMap();
            penv.put("implClass", nm);
        }
        if ((name = (String)nm.get(service + "/" + port)) == null) {
            name = intf.getName() + "Impl";
            name = this.mapClassName(intf.getPackageName(), name, penv);
            nm.put(service + "/" + port, name);
        }
        return name;
    }

    private String mapClassName(String packageName, String name, ToolContext context) {
        ClassCollector collector = context.get(ClassCollector.class);
        int count = 0;
        String checkName = name;
        while (collector.containServerClass(packageName, checkName)) {
            checkName = name + ++count;
        }
        collector.addServerClassName(packageName, checkName, packageName + "." + checkName);
        return checkName;
    }

    @Override
    public void register(ClassCollector collector, String packageName, String fileName) {
        collector.addServerClassName(packageName, fileName, packageName + "." + fileName);
    }
}

