/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml;

import java.io.InputStream;
import java.io.InputStreamReader;
import javax.ws.rs.core.Response;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.saml.AbstractSamlInHandler;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SamlEnvelopedInHandler
extends AbstractSamlInHandler {
    private static final String SAML2_NS = "urn:oasis:names:tc:SAML:2.0:assertion";
    private static final String SAML1_NS = "urn:oasis:names:tc:SAML:1.0:assertion";
    private static final String SAML_ASSERTION = "Assertion";
    private boolean bodyIsRoot;

    @Override
    public Response handleRequest(Message message, ClassResourceInfo resourceClass) {
        Element samlElement;
        String method = (String)message.get("org.apache.cxf.request.method");
        if ("GET".equals(method)) {
            return null;
        }
        Document doc = null;
        InputStream is = message.getContent(InputStream.class);
        if (is != null) {
            try {
                doc = StaxUtils.read(new InputStreamReader(is, "UTF-8"));
            }
            catch (Exception ex) {
                this.throwFault("Invalid XML payload", ex);
            }
        } else {
            XMLStreamReader reader = message.getContent(XMLStreamReader.class);
            if (reader instanceof W3CDOMStreamReader) {
                doc = ((W3CDOMStreamReader)reader).getDocument();
            }
        }
        if (doc == null) {
            this.throwFault("No payload is available", null);
        }
        if ((samlElement = this.getNode(doc.getDocumentElement(), SAML2_NS, SAML_ASSERTION)) == null) {
            samlElement = this.getNode(doc.getDocumentElement(), SAML1_NS, SAML_ASSERTION);
        }
        if (samlElement == null) {
            this.throwFault("SAML Assertion is not available", null);
        }
        this.validateToken(message, samlElement);
        doc.getDocumentElement().removeChild(samlElement);
        if (this.bodyIsRoot) {
            message.setContent(XMLStreamReader.class, new W3CDOMStreamReader(doc));
            message.setContent(InputStream.class, null);
        } else {
            Element actualBody = this.getActualBody(doc.getDocumentElement());
            if (actualBody != null) {
                Document newDoc = DOMUtils.createDocument();
                newDoc.adoptNode(actualBody);
                message.setContent(XMLStreamReader.class, new W3CDOMStreamReader(actualBody));
                message.setContent(InputStream.class, null);
            }
        }
        return null;
    }

    private Element getActualBody(Element root) {
        Element node = DOMUtils.getFirstElement(root);
        if (node != null) {
            root.removeChild(node);
        }
        return node;
    }

    protected Element getNode(Element parent, String ns, String name) {
        NodeList list = parent.getElementsByTagNameNS(ns, name);
        if (list != null && list.getLength() == 1) {
            return (Element)list.item(0);
        }
        return null;
    }

    public void setBodyIsRoot(boolean bodyIsRoot) {
        this.bodyIsRoot = bodyIsRoot;
    }
}

