/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.model.UserOperation;

public class UserResource {
    private String className;
    private String pathValue;
    private String consumesTypes;
    private String producesTypes;
    private List<UserOperation> opers;

    public UserResource() {
    }

    public UserResource(String className) {
        this(className, null);
    }

    public UserResource(String className, String pathValue) {
        this(className, pathValue, null);
    }

    public UserResource(String className, String pathValue, List<UserOperation> ops) {
        this.className = className;
        this.pathValue = pathValue;
        this.opers = ops;
    }

    public String getConsumes() {
        return this.consumesTypes;
    }

    public String getProduces() {
        return this.producesTypes;
    }

    public void setConsumes(String types) {
        if (!"".equals(types)) {
            this.consumesTypes = types;
        }
    }

    public void setProduces(String types) {
        if (!"".equals(types)) {
            this.producesTypes = types;
        }
    }

    public String getName() {
        return this.className;
    }

    public void setName(String name) {
        if (!"".equals(name)) {
            this.className = name;
        }
    }

    public String getPath() {
        return this.pathValue;
    }

    public void setPath(String path) {
        if (!"".equals(path)) {
            this.pathValue = path;
        }
    }

    public void setOperations(List<UserOperation> ops) {
        this.opers = ops;
    }

    public List<UserOperation> getOperations() {
        return this.opers == null ? CastUtils.cast(Collections.emptyList(), UserOperation.class) : Collections.unmodifiableList(this.opers);
    }

    public Map<String, UserOperation> getOperationsAsMap() {
        HashMap<String, UserOperation> map = new HashMap<String, UserOperation>();
        for (UserOperation op : this.opers) {
            map.put(op.getName(), op);
        }
        return map;
    }
}

