/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.mex;

import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.JAXWSMethodInvoker;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.MAPAggregator;
import org.apache.cxf.ws.addressing.WSAddressingFeature;
import org.apache.cxf.ws.mex.MEXEndpoint;
import org.apache.cxf.ws.policy.AssertionInfoMap;

public class MEXInInterceptor
extends AbstractPhaseInterceptor<Message> {
    final MEXEndpoint ep;
    Endpoint mexEndpoint;

    public MEXInInterceptor(Server serv) {
        super("pre-protocol");
        this.ep = new MEXEndpoint(serv);
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        AddressingProperties inProps;
        String action = (String)message.get("SOAPAction");
        if (action == null && (inProps = (AddressingProperties)message.getContextualProperty("javax.xml.ws.addressing.context.inbound")) != null && inProps.getAction() != null) {
            action = inProps.getAction().getValue();
        }
        if ("http://schemas.xmlsoap.org/ws/2004/09/transfer/Get".equals(action) || "http://schemas.xmlsoap.org/ws/2004/09/mex/GetMetadata/Request".equals(action)) {
            message.remove(AssertionInfoMap.class);
            Exchange ex = message.getExchange();
            Endpoint endpoint = this.createEndpoint(message);
            ex.put(Endpoint.class, endpoint);
            ex.put(Service.class, endpoint.getService());
            ex.put(Binding.class, endpoint.getBinding());
            ex.put(BindingOperationInfo.class, endpoint.getBinding().getBindingInfo().getOperation(new QName("http://mex.ws.cxf.apache.org/", "Get2004")));
            ex.remove(BindingOperationInfo.class);
            message.put(MAPAggregator.ACTION_VERIFIED, Boolean.TRUE);
            message.getInterceptorChain().add(endpoint.getInInterceptors());
            message.getInterceptorChain().add(endpoint.getBinding().getInInterceptors());
        }
    }

    private synchronized Endpoint createEndpoint(Message message) {
        if (this.mexEndpoint == null) {
            MEXJaxWsServerFactoryBean factory = new MEXJaxWsServerFactoryBean(message.getExchange().getBus());
            try {
                Endpoint endpoint = factory.createEndpoint();
                endpoint.getService().setInvoker(new JAXWSMethodInvoker(this.ep));
                this.mexEndpoint = endpoint;
            }
            catch (Exception ex) {
                throw new Fault(ex);
            }
        }
        return this.mexEndpoint;
    }

    private static class MEXJaxWsServerFactoryBean
    extends JaxWsServerFactoryBean {
        public MEXJaxWsServerFactoryBean(Bus b) {
            this.setServiceClass(MEXEndpoint.class);
            this.setServiceName(new QName("http://mex.ws.cxf.apache.org/", "MEXEndpoint"));
            this.setBus(b);
        }

        @Override
        public Endpoint createEndpoint() throws BusException, EndpointException {
            Endpoint ep = super.createEndpoint();
            new WSAddressingFeature().initialize(ep, this.getBus());
            return ep;
        }
    }
}

